/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.client.modloader;

import com.google.common.base.Equivalence;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapDifference;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import cpw.mods.fml.client.modloader.ModLoaderBlockRendererHandler;
import cpw.mods.fml.client.modloader.ModLoaderKeyBindingHandler;
import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.modloader.BaseModProxy;
import cpw.mods.fml.common.modloader.IModLoaderSidedHelper;
import cpw.mods.fml.common.modloader.ModLoaderHelper;
import cpw.mods.fml.common.modloader.ModLoaderModContainer;
import cpw.mods.fml.common.network.EntitySpawnPacket;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class ModLoaderClientHelper
implements IModLoaderSidedHelper {
    private ats client;
    private static Multimap<ModLoaderModContainer, ModLoaderKeyBindingHandler> keyBindingContainers;
    private Map<cl, ey> managerLookups = new MapMaker().weakKeys().weakValues().makeMap();

    public static int obtainBlockModelIdFor(BaseMod mod, boolean inventoryRenderer) {
        int renderId = RenderingRegistry.getNextAvailableRenderId();
        ModLoaderBlockRendererHandler bri = new ModLoaderBlockRendererHandler(renderId, inventoryRenderer, mod);
        RenderingRegistry.registerBlockHandler(bri);
        return renderId;
    }

    public static void handleFinishLoadingFor(ModLoaderModContainer mc, ats game) {
        FMLLog.log(mc.getModId(), Level.FINE, "Handling post startup activities for ModLoader mod %s", mc.getModId());
        BaseMod mod = (BaseMod)mc.getMod();
        HashMap renderers = Maps.newHashMap((Map)bgi.a.q);
        try {
            FMLLog.log(mc.getModId(), Level.FINEST, "Requesting renderers from basemod %s", mc.getModId());
            mod.addRenderer(renderers);
            FMLLog.log(mc.getModId(), Level.FINEST, "Received %d renderers from basemod %s", renderers.size(), mc.getModId());
        }
        catch (Exception e) {
            FMLLog.log(mc.getModId(), Level.SEVERE, e, "A severe problem was detected with the mod %s during the addRenderer call. Continuing, but expect odd results", mc.getModId());
        }
        MapDifference difference = Maps.difference((Map)bgi.a.q, (Map)renderers, (Equivalence)Equivalence.identity());
        for (Map.Entry e : difference.entriesOnlyOnLeft().entrySet()) {
            FMLLog.log(mc.getModId(), Level.WARNING, "The mod %s attempted to remove an entity renderer %s from the entity map. This will be ignored.", mc.getModId(), ((Class)e.getKey()).getName());
        }
        for (Map.Entry e : difference.entriesOnlyOnRight().entrySet()) {
            FMLLog.log(mc.getModId(), Level.FINEST, "Registering ModLoader entity renderer %s as instance of %s", ((Class)e.getKey()).getName(), ((bgj)e.getValue()).getClass().getName());
            RenderingRegistry.registerEntityRenderingHandler((Class)e.getKey(), (bgj)e.getValue());
        }
        for (Map.Entry e : difference.entriesDiffering().entrySet()) {
            FMLLog.log(mc.getModId(), Level.FINEST, "Registering ModLoader entity rendering override for %s as instance of %s", ((Class)e.getKey()).getName(), ((bgj)((MapDifference.ValueDifference)e.getValue()).rightValue()).getClass().getName());
            RenderingRegistry.registerEntityRenderingHandler((Class)e.getKey(), (bgj)((MapDifference.ValueDifference)e.getValue()).rightValue());
        }
        try {
            mod.registerAnimation(game);
        }
        catch (Exception e) {
            FMLLog.log(mc.getModId(), Level.SEVERE, e, "A severe problem was detected with the mod %s during the registerAnimation call. Continuing, but expect odd results", mc.getModId());
        }
    }

    public ModLoaderClientHelper(ats client) {
        this.client = client;
        ModLoaderHelper.sidedHelper = this;
        keyBindingContainers = Multimaps.newMultimap((Map)Maps.newHashMap(), (Supplier)new Supplier<Collection<ModLoaderKeyBindingHandler>>(){

            public Collection<ModLoaderKeyBindingHandler> get() {
                return Collections.singleton(new ModLoaderKeyBindingHandler());
            }
        });
    }

    @Override
    public void finishModLoading(ModLoaderModContainer mc) {
        ModLoaderClientHelper.handleFinishLoadingFor(mc, this.client);
    }

    public static void registerKeyBinding(BaseModProxy mod, atp keyHandler, boolean allowRepeat) {
        ModLoaderModContainer mlmc = (ModLoaderModContainer)Loader.instance().activeModContainer();
        ModLoaderKeyBindingHandler handler = (ModLoaderKeyBindingHandler)Iterables.getOnlyElement((Iterable)keyBindingContainers.get((Object)mlmc));
        handler.setModContainer(mlmc);
        handler.addKeyBinding(keyHandler, allowRepeat);
        KeyBindingRegistry.registerKeyBinding(handler);
    }

    @Override
    public Object getClientGui(BaseModProxy mod, ue player, int ID, int x2, int y, int z2) {
        return ((BaseMod)mod).getContainerGUI((bdf)player, ID, x2, y, z2);
    }

    @Override
    public nm spawnEntity(BaseModProxy mod, EntitySpawnPacket input, EntityRegistry.EntityRegistration er) {
        return ((BaseMod)mod).spawnEntity(er.getModEntityId(), (abv)this.client.f, input.scaledX, input.scaledY, input.scaledZ);
    }

    @Override
    public void sendClientPacket(BaseModProxy mod, dz packet) {
        ((BaseMod)mod).clientCustomPayload(this.client.h.a, packet);
    }

    @Override
    public void clientConnectionOpened(ey netClientHandler, cl manager, BaseModProxy mod) {
        this.managerLookups.put(manager, netClientHandler);
        ((BaseMod)mod).clientConnect((bct)netClientHandler);
    }

    @Override
    public boolean clientConnectionClosed(cl manager, BaseModProxy mod) {
        if (this.managerLookups.containsKey(manager)) {
            ((BaseMod)mod).clientDisconnect((bct)this.managerLookups.get(manager));
            return true;
        }
        return false;
    }
}

