/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network;

import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkItemEventListener;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.WorldData;
import ic2.core.item.IHandHeldInventory;
import ic2.core.item.armor.ItemArmorQuantumSuit;
import ic2.core.network.DataEncoder;
import ic2.core.network.IPlayerItemDataListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class NetworkManager
implements IPacketHandler {
    public static final int updatePeriod = 2;
    private static int maxNetworkedFieldsToUpdate = 4000;
    private static final int maxPacketDataLength = 32766;

    public void onTick(World world) {
        WorldData worldData = WorldData.get(world);
        if (--worldData.ticksLeftToNetworkUpdate == 0) {
            this.sendUpdatePacket(world);
            worldData.ticksLeftToNetworkUpdate = 2;
        }
    }

    public void sendPlayerItemData(EntityPlayer player, int slot, Object ... data) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(buffer);
        try {
            os.writeByte(10);
            os.writeByte(slot);
            os.writeInt(player.field_71071_by.field_70462_a[slot].field_77993_c);
            os.writeShort(data.length);
            for (Object o : data) {
                DataEncoder.encode(os, o);
            }
            os.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = "ic2";
        packet.field_73287_r = false;
        packet.field_73629_c = buffer.toByteArray();
        packet.field_73628_b = buffer.size();
        if (IC2.platform.isSimulating()) {
            PacketDispatcher.sendPacketToPlayer((Packet)packet, (Player)((Player)player));
        } else {
            PacketDispatcher.sendPacketToServer((Packet)packet);
        }
    }

    public void updateTileEntityField(TileEntity te, String field) {
        WorldData worldData = WorldData.get(te.field_70331_k);
        worldData.networkedFieldsToUpdate.add(new TileEntityField(te, field));
        if (worldData.networkedFieldsToUpdate.size() >= maxNetworkedFieldsToUpdate) {
            this.sendUpdatePacket(te.field_70331_k);
        }
    }

    public void initiateTileEntityEvent(TileEntity te, int event, boolean limitRange) {
        int maxDistance = limitRange ? 400 : MinecraftServer.func_71276_C().func_71203_ab().func_72372_a() + 16;
        World world = te.field_70331_k;
        Packet250CustomPayload packet = null;
        for (Object obj : world.field_73010_i) {
            EntityPlayerMP entityPlayer = (EntityPlayerMP)obj;
            int distanceX = te.field_70329_l - (int)entityPlayer.field_70165_t;
            int distanceZ = te.field_70327_n - (int)entityPlayer.field_70161_v;
            int distance = limitRange ? distanceX * distanceX + distanceZ * distanceZ : Math.max(Math.abs(distanceX), Math.abs(distanceZ));
            if (distance > maxDistance) continue;
            if (packet == null) {
                try {
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    DataOutputStream os = new DataOutputStream(buffer);
                    os.writeByte(1);
                    os.writeInt(world.field_73011_w.field_76574_g);
                    os.writeInt(te.field_70329_l);
                    os.writeInt(te.field_70330_m);
                    os.writeInt(te.field_70327_n);
                    os.writeInt(event);
                    os.close();
                    packet = new Packet250CustomPayload();
                    packet.field_73630_a = "ic2";
                    packet.field_73287_r = false;
                    packet.field_73629_c = buffer.toByteArray();
                    packet.field_73628_b = buffer.size();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            PacketDispatcher.sendPacketToPlayer(packet, (Player)((Player)entityPlayer));
        }
    }

    public void initiateItemEvent(EntityPlayer player, ItemStack itemStack, int event, boolean limitRange) {
        if (player.field_71092_bJ.length() > 127) {
            return;
        }
        int maxDistance = limitRange ? 400 : MinecraftServer.func_71276_C().func_71203_ab().func_72372_a() + 16;
        Packet250CustomPayload packet = null;
        for (Object obj : player.field_70170_p.field_73010_i) {
            EntityPlayerMP entityPlayer = (EntityPlayerMP)obj;
            int distanceX = (int)player.field_70165_t - (int)entityPlayer.field_70165_t;
            int distanceZ = (int)player.field_70161_v - (int)entityPlayer.field_70161_v;
            int distance = limitRange ? distanceX * distanceX + distanceZ * distanceZ : Math.max(Math.abs(distanceX), Math.abs(distanceZ));
            if (distance > maxDistance) continue;
            if (packet == null) {
                try {
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    DataOutputStream os = new DataOutputStream(buffer);
                    os.writeByte(2);
                    os.writeByte(player.field_71092_bJ.length());
                    os.writeChars(player.field_71092_bJ);
                    os.writeInt(itemStack.field_77993_c);
                    os.writeInt(itemStack.func_77960_j());
                    os.writeInt(event);
                    os.close();
                    packet = new Packet250CustomPayload();
                    packet.field_73630_a = "ic2";
                    packet.field_73287_r = false;
                    packet.field_73629_c = buffer.toByteArray();
                    packet.field_73628_b = buffer.size();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            PacketDispatcher.sendPacketToPlayer(packet, (Player)((Player)entityPlayer));
        }
    }

    public void announceBlockUpdate(World world, int x, int y, int z) {
        Packet250CustomPayload packet = null;
        for (Object obj : world.field_73010_i) {
            EntityPlayerMP entityPlayer = (EntityPlayerMP)obj;
            int distance = Math.min(Math.abs(x - (int)entityPlayer.field_70165_t), Math.abs(z - (int)entityPlayer.field_70161_v));
            if (distance > MinecraftServer.func_71276_C().func_71203_ab().func_72372_a() + 16) continue;
            if (packet == null) {
                try {
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    DataOutputStream os = new DataOutputStream(buffer);
                    os.writeByte(3);
                    os.writeInt(world.field_73011_w.field_76574_g);
                    os.writeInt(x);
                    os.writeInt(y);
                    os.writeInt(z);
                    os.writeShort(world.func_72798_a(x, y, z));
                    os.writeByte(world.func_72805_g(x, y, z));
                    os.close();
                    packet = new Packet250CustomPayload();
                    packet.field_73630_a = "ic2";
                    packet.field_73287_r = true;
                    packet.field_73629_c = buffer.toByteArray();
                    packet.field_73628_b = buffer.size();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            PacketDispatcher.sendPacketToPlayer(packet, (Player)((Player)entityPlayer));
        }
    }

    @Deprecated
    public void requestInitialData(INetworkDataProvider dataProvider) {
    }

    public void initiateClientItemEvent(ItemStack itemStack, int event) {
    }

    public void initiateClientTileEntityEvent(TileEntity te, int event) {
    }

    public void initiateGuiDisplay(EntityPlayerMP entityPlayer, IHasGui inventory, int windowId) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(buffer);
            os.writeByte(4);
            MinecraftServer server = MinecraftServer.func_71276_C();
            boolean isAdmin = server.func_71203_ab().func_72353_e(entityPlayer.field_71092_bJ);
            os.writeByte(isAdmin ? 1 : 0);
            if (inventory instanceof TileEntity) {
                TileEntity te = (TileEntity)inventory;
                os.writeByte(0);
                os.writeInt(te.field_70331_k.field_73011_w.field_76574_g);
                os.writeInt(te.field_70329_l);
                os.writeInt(te.field_70330_m);
                os.writeInt(te.field_70327_n);
            } else if (entityPlayer.field_71071_by.func_70448_g() != null && entityPlayer.field_71071_by.func_70448_g().func_77973_b() instanceof IHandHeldInventory) {
                os.writeByte(1);
                os.writeInt(entityPlayer.field_71071_by.field_70461_c);
            } else {
                IC2.platform.displayError("An unknown GUI type was attempted to be displayed.\nThis could happen due to corrupted data from a player or a bug.\n\n(Technical information: " + inventory + ")");
            }
            os.writeInt(windowId);
            os.close();
            Packet250CustomPayload packet = new Packet250CustomPayload();
            packet.field_73630_a = "ic2";
            packet.field_73287_r = false;
            packet.field_73629_c = buffer.toByteArray();
            packet.field_73628_b = buffer.size();
            PacketDispatcher.sendPacketToPlayer((Packet)packet, (Player)((Player)entityPlayer));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendInitialData(TileEntity te, EntityPlayerMP player) {
        if (te instanceof INetworkDataProvider) {
            WorldData worldData = WorldData.get(te.field_70331_k);
            for (String field : ((INetworkDataProvider)te).getNetworkedFields()) {
                worldData.networkedFieldsToUpdate.add(new TileEntityField(te, field, player));
                if (worldData.networkedFieldsToUpdate.size() < maxNetworkedFieldsToUpdate) continue;
                this.sendUpdatePacket(te.field_70331_k);
            }
        }
    }

    public void sendChat(EntityPlayerMP player, String message) {
        try {
            this.sendLargePacket(player, 1, false, message.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void sendConsole(EntityPlayerMP player, String message) {
        try {
            this.sendLargePacket(player, 2, false, message.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private void sendUpdatePacket(World world) {
        WorldData worldData = WorldData.get(world);
        if (worldData.networkedFieldsToUpdate.isEmpty()) {
            return;
        }
        HashMap data = new HashMap();
        for (TileEntityField tef : worldData.networkedFieldsToUpdate) {
            List<EntityPlayerMP> receivers;
            if (tef.te.func_70320_p()) continue;
            if (tef.target == null) {
                receivers = this.getPlayersInRange(world, tef.te);
            } else {
                if (tef.te.field_70331_k != tef.target.field_70170_p) continue;
                receivers = Arrays.asList(tef.target);
            }
            for (EntityPlayerMP player : receivers) {
                ByteArrayOutputStream teData;
                HashMap<TileEntity, ByteArrayOutputStream> playerData = (HashMap<TileEntity, ByteArrayOutputStream>)data.get(player);
                if (playerData == null) {
                    playerData = new HashMap<TileEntity, ByteArrayOutputStream>();
                    data.put(player, playerData);
                }
                if ((teData = (ByteArrayOutputStream)playerData.get(tef.te)) == null) {
                    teData = new ByteArrayOutputStream(512);
                    playerData.put(tef.te, teData);
                }
                try {
                    this.retrieveFieldData(tef, teData);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        worldData.networkedFieldsToUpdate.clear();
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(16384);
            for (Map.Entry entry : data.entrySet()) {
                EntityPlayerMP player = (EntityPlayerMP)entry.getKey();
                Map playerData = (Map)entry.getValue();
                DataOutputStream os = new DataOutputStream(buffer);
                os.writeInt(player.field_70170_p.field_73011_w.field_76574_g);
                for (Map.Entry entry2 : playerData.entrySet()) {
                    TileEntity te = (TileEntity)entry2.getKey();
                    ByteArrayOutputStream fieldData = (ByteArrayOutputStream)entry2.getValue();
                    os.writeInt(te.field_70329_l);
                    os.writeInt(te.field_70330_m);
                    os.writeInt(te.field_70327_n);
                    os.writeInt(fieldData.size());
                    fieldData.writeTo(os);
                }
                os.close();
                this.sendLargePacket(player, 0, true, buffer.toByteArray());
                buffer.reset();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<EntityPlayerMP> getPlayersInRange(World world, TileEntity te) {
        ArrayList<EntityPlayerMP> ret = new ArrayList<EntityPlayerMP>();
        for (Object obj : world.field_73010_i) {
            if (!(obj instanceof EntityPlayerMP)) continue;
            EntityPlayerMP player = (EntityPlayerMP)obj;
            int distance = Math.min(Math.abs(te.field_70329_l - (int)player.field_70165_t), Math.abs(te.field_70327_n - (int)player.field_70161_v));
            if (distance > MinecraftServer.func_71276_C().func_71203_ab().func_72372_a() + 16) continue;
            ret.add(player);
        }
        return ret;
    }

    private void sendLargePacket(EntityPlayerMP player, int id, boolean isChunkData, byte[] data) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(16384);
        try {
            DeflaterOutputStream deflate = new DeflaterOutputStream(buffer);
            deflate.write(data);
            deflate.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        data = buffer.toByteArray();
        int maxSize = 32764;
        for (int offset = 0; offset < data.length; offset += maxSize) {
            buffer.reset();
            buffer.write(0);
            int state = 0;
            if (offset == 0) {
                state |= 1;
            }
            if (offset + maxSize > data.length) {
                state |= 2;
            }
            buffer.write(state |= id << 2);
            buffer.write(data, offset, Math.min(maxSize, data.length - offset));
            Packet250CustomPayload packet = new Packet250CustomPayload();
            packet.field_73630_a = "ic2";
            packet.field_73287_r = isChunkData;
            packet.field_73629_c = buffer.toByteArray();
            packet.field_73628_b = buffer.size();
            PacketDispatcher.sendPacketToPlayer((Packet)packet, (Player)((Player)player));
        }
    }

    public void onPacketData(INetworkManager network, Packet250CustomPayload packet, Player iplayer) {
        block19: {
            if (packet.field_73629_c.length == 0) {
                return;
            }
            EntityPlayer player = (EntityPlayer)iplayer;
            ByteArrayInputStream isRaw = new ByteArrayInputStream(packet.field_73629_c, 1, packet.field_73629_c.length - 1);
            try {
                block1 : switch (packet.field_73629_c[0]) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        DataInputStream is = new DataInputStream(isRaw);
                        int itemId = is.readInt();
                        int itemDamage = is.readInt();
                        int event = is.readInt();
                        if (itemId >= Item.field_77698_e.length) break;
                        Item item = Item.field_77698_e[itemId];
                        if (item instanceof INetworkItemEventListener) {
                            ((INetworkItemEventListener)item).onNetworkEvent(itemDamage, player, event);
                        }
                        break;
                    }
                    case 2: {
                        DataInputStream is = new DataInputStream(isRaw);
                        int keyState = is.readInt();
                        IC2.keyboard.processKeyUpdate(player, keyState);
                        break;
                    }
                    case 3: {
                        DataInputStream is = new DataInputStream(isRaw);
                        int dimensionId = is.readInt();
                        int x = is.readInt();
                        int y = is.readInt();
                        int z = is.readInt();
                        int event = is.readInt();
                        for (WorldServer world : DimensionManager.getWorlds()) {
                            if (dimensionId != world.field_73011_w.field_76574_g) continue;
                            TileEntity te = world.func_72796_p(x, y, z);
                            if (te instanceof INetworkClientTileEntityEventListener) {
                                ((INetworkClientTileEntityEventListener)te).onNetworkEvent(player, event);
                                break block1;
                            }
                            break block19;
                        }
                        break;
                    }
                    case 4: {
                        GZIPInputStream gzip = new GZIPInputStream((InputStream)isRaw, packet.field_73629_c.length - 1);
                        DataInputStream is = new DataInputStream(gzip);
                        int clientNetworkProtocolVersion = is.readInt();
                        if (clientNetworkProtocolVersion != 1) {
                            ((EntityPlayerMP)player).field_71135_a.func_72565_c("IC2 network protocol version mismatch (expected 1 (2.0.140-experimental), got " + clientNetworkProtocolVersion + ")");
                        }
                        boolean enableQuantumSpeedOnSprint = is.readByte() != 0;
                        ItemArmorQuantumSuit.enableQuantumSpeedOnSprintMap.put(player, enableQuantumSpeedOnSprint);
                        is.readInt();
                        Properties clientRuntimeIdProperties = new Properties();
                        clientRuntimeIdProperties.load(is);
                        is.close();
                        for (Map.Entry<Object, Object> mapEntry : IC2.runtimeIdProperties.entrySet()) {
                            String key = (String)mapEntry.getKey();
                            String value = (String)mapEntry.getValue();
                            if (!clientRuntimeIdProperties.containsKey(key)) {
                                ((EntityPlayerMP)player).field_71135_a.func_72565_c("IC2 id value missing (" + key + ")");
                                break block1;
                            }
                            int separatorPos = key.indexOf(46);
                            if (separatorPos == -1) continue;
                            String section = key.substring(0, separatorPos);
                            key.substring(separatorPos + 1);
                            if (!section.equals("block") && !section.equals("item") || value.equals(clientRuntimeIdProperties.get(key))) continue;
                            ((EntityPlayerMP)player).field_71135_a.func_72565_c("IC2 id mismatch (" + key + ": expected " + value + ", got " + clientRuntimeIdProperties.get(key) + ")");
                        }
                        break;
                    }
                    case 10: {
                        Item item;
                        DataInputStream is = new DataInputStream(isRaw);
                        byte slot = is.readByte();
                        int itemId = is.readInt();
                        int dataCount = is.readShort();
                        Object[] data = new Object[dataCount];
                        for (int i = 0; i < dataCount; ++i) {
                            data[i] = DataEncoder.decode(is);
                        }
                        if (slot < 0 || slot > 9) break;
                        ItemStack itemStack = player.field_71071_by.field_70462_a[slot];
                        if (itemStack != null && itemStack.field_77993_c == itemId && (item = Item.field_77698_e[itemStack.field_77993_c]) instanceof IPlayerItemDataListener) {
                            ((IPlayerItemDataListener)item).onPlayerItemNetworkData(player, slot, data);
                        }
                        break;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void initiateKeyUpdate(int keyState) {
    }

    public void sendLoginData() {
    }

    public void initiateExplosionEffect(World world, double x, double y, double z) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(buffer);
            os.writeByte(5);
            os.writeInt(world.field_73011_w.field_76574_g);
            os.writeDouble(x);
            os.writeDouble(y);
            os.writeDouble(z);
            os.close();
            Packet250CustomPayload packet = new Packet250CustomPayload();
            packet.field_73630_a = "ic2";
            packet.field_73287_r = false;
            packet.field_73629_c = buffer.toByteArray();
            packet.field_73628_b = buffer.size();
            for (Object player : world.field_73010_i) {
                EntityPlayerMP entityPlayer = (EntityPlayerMP)player;
                if (!(entityPlayer.func_70092_e(x, y, z) < 128.0)) continue;
                PacketDispatcher.sendPacketToPlayer((Packet)packet, (Player)((Player)entityPlayer));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void retrieveFieldData(TileEntityField tef, OutputStream out) throws IOException {
        DataOutputStream os = new DataOutputStream(out);
        os.writeUTF(tef.field);
        Field field = null;
        try {
            Class<?> fieldDeclaringClass = tef.te.getClass();
            do {
                try {
                    field = fieldDeclaringClass.getDeclaredField(tef.field);
                }
                catch (NoSuchFieldException e) {
                    fieldDeclaringClass = fieldDeclaringClass.getSuperclass();
                }
            } while (field == null && fieldDeclaringClass != null);
            if (field == null) {
                throw new NoSuchFieldException(tef.field);
            }
            field.setAccessible(true);
            DataEncoder.encode(os, field.get(tef.te));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        os.flush();
    }

    public class TileEntityField {
        TileEntity te;
        String field;
        EntityPlayerMP target = null;

        TileEntityField(TileEntity te, String field) {
            this.te = te;
            this.field = field;
        }

        TileEntityField(TileEntity te, String field, EntityPlayerMP target) {
            this.te = te;
            this.field = field;
            this.target = target;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TileEntityField) {
                TileEntityField tef = (TileEntityField)obj;
                return tef.te == this.te && tef.field.equals(this.field) && tef.target == this.target;
            }
            return false;
        }

        public int hashCode() {
            return this.te.hashCode() * 31 ^ this.field.hashCode();
        }
    }
}

