/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.item.IBoxable;
import ic2.api.item.IItemHudInfo;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.wiring.TileEntityCable;
import ic2.core.init.InternalName;
import ic2.core.item.ItemGradual;
import ic2.core.item.armor.ItemArmorCFPack;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;

public class ItemSprayer
extends ItemGradual
implements IBoxable,
IItemHudInfo {
    public ItemSprayer(Configuration config, InternalName internalName) {
        super(config, internalName);
        this.func_77656_e(1602);
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int l, float a, float b, float c) {
        boolean pulledFromCFPack;
        if (!IC2.platform.isSimulating()) {
            return true;
        }
        ItemStack pack = entityplayer.field_71071_by.field_70460_b[2];
        boolean bl = pulledFromCFPack = pack != null && pack.field_77993_c == Ic2Items.cfPack.field_77993_c && ((ItemArmorCFPack)pack.func_77973_b()).getCFPellet(entityplayer, pack);
        if (!pulledFromCFPack && itemstack.func_77960_j() > 1501) {
            return false;
        }
        if (world.func_72798_a(i, j, k) == Ic2Items.scaffold.field_77993_c || world.func_72798_a(i, j, k) == Ic2Items.ironScaffold.field_77993_c) {
            this.sprayFoam(world, i, j, k, ItemSprayer.calculateDirectionsFromPlayer(entityplayer), true);
            if (!pulledFromCFPack) {
                itemstack.func_77972_a(100, (EntityLivingBase)entityplayer);
            }
            return true;
        }
        if (l == 0) {
            --j;
        }
        if (l == 1) {
            ++j;
        }
        if (l == 2) {
            --k;
        }
        if (l == 3) {
            ++k;
        }
        if (l == 4) {
            --i;
        }
        if (l == 5) {
            ++i;
        }
        world.func_72798_a(i, j, k);
        if (this.sprayFoam(world, i, j, k, ItemSprayer.calculateDirectionsFromPlayer(entityplayer), false)) {
            if (!pulledFromCFPack) {
                itemstack.func_77972_a(100, (EntityLivingBase)entityplayer);
            }
            return true;
        }
        return false;
    }

    public static boolean[] calculateDirectionsFromPlayer(EntityPlayer player) {
        float yaw = player.field_70177_z % 360.0f;
        float pitch = player.field_70125_A;
        boolean[] r = new boolean[]{true, true, true, true, true, true};
        if (pitch >= -65.0f && pitch <= 65.0f) {
            if (yaw >= 300.0f && yaw <= 360.0f || yaw >= 0.0f && yaw <= 60.0f) {
                r[2] = false;
            }
            if (yaw >= 30.0f && yaw <= 150.0f) {
                r[5] = false;
            }
            if (yaw >= 120.0f && yaw <= 240.0f) {
                r[3] = false;
            }
            if (yaw >= 210.0f && yaw <= 330.0f) {
                r[4] = false;
            }
        }
        if (pitch <= -40.0f) {
            r[0] = false;
        }
        if (pitch >= 40.0f) {
            r[1] = false;
        }
        return r;
    }

    public boolean sprayFoam(World world, int i, int j, int k, boolean[] directions, boolean scaffold) {
        int targetBlockId;
        int blockId = world.func_72798_a(i, j, k);
        if (!scaffold && !Block.field_71973_m[Ic2Items.constructionFoam.field_77993_c].func_71930_b(world, i, j, k) && (blockId != Ic2Items.copperCableBlock.field_77993_c || world.func_72805_g(i, j, k) == 13) || scaffold && blockId != Ic2Items.scaffold.field_77993_c && blockId != Ic2Items.ironScaffold.field_77993_c) {
            return false;
        }
        ArrayList<ChunkPosition> check = new ArrayList<ChunkPosition>();
        ArrayList<ChunkPosition> place = new ArrayList<ChunkPosition>();
        int foamcount = ItemSprayer.getSprayMass();
        check.add(new ChunkPosition(i, j, k));
        for (int x = 0; x < check.size() && foamcount > 0; ++x) {
            ChunkPosition set = (ChunkPosition)check.get(x);
            targetBlockId = world.func_72798_a(set.field_76930_a, set.field_76928_b, set.field_76929_c);
            if ((scaffold || !Block.field_71973_m[Ic2Items.constructionFoam.field_77993_c].func_71930_b(world, set.field_76930_a, set.field_76928_b, set.field_76929_c) && (targetBlockId != Ic2Items.copperCableBlock.field_77993_c || world.func_72805_g(set.field_76930_a, set.field_76928_b, set.field_76929_c) == 13)) && (!scaffold || targetBlockId != Ic2Items.scaffold.field_77993_c && targetBlockId != Ic2Items.ironScaffold.field_77993_c)) continue;
            this.considerAddingCoord(set, place);
            this.addAdjacentSpacesOnList(set.field_76930_a, set.field_76928_b, set.field_76929_c, check, directions, scaffold);
            --foamcount;
        }
        for (ChunkPosition pos : place) {
            targetBlockId = world.func_72798_a(pos.field_76930_a, pos.field_76928_b, pos.field_76929_c);
            if (targetBlockId == Ic2Items.scaffold.field_77993_c) {
                Block.field_71973_m[Ic2Items.scaffold.field_77993_c].func_71897_c(world, pos.field_76930_a, pos.field_76928_b, pos.field_76929_c, world.func_72805_g(pos.field_76930_a, pos.field_76928_b, pos.field_76929_c), 0);
                world.func_72832_d(pos.field_76930_a, pos.field_76928_b, pos.field_76929_c, Ic2Items.constructionFoam.field_77993_c, 0, 7);
                continue;
            }
            if (targetBlockId == Ic2Items.ironScaffold.field_77993_c) {
                world.func_72832_d(pos.field_76930_a, pos.field_76928_b, pos.field_76929_c, Ic2Items.constructionreinforcedFoam.field_77993_c, 0, 7);
                continue;
            }
            if (targetBlockId == Ic2Items.copperCableBlock.field_77993_c) {
                TileEntity te = world.func_72796_p(pos.field_76930_a, pos.field_76928_b, pos.field_76929_c);
                if (!(te instanceof TileEntityCable)) continue;
                ((TileEntityCable)te).changeFoam((byte)1);
                continue;
            }
            world.func_72832_d(pos.field_76930_a, pos.field_76928_b, pos.field_76929_c, Ic2Items.constructionFoam.field_77993_c, 0, 7);
        }
        return true;
    }

    public void addAdjacentSpacesOnList(int x, int y, int z, ArrayList<ChunkPosition> foam, boolean[] directions, boolean ignoreDirections) {
        int[] order = this.generateRngSpread(IC2.random);
        block8: for (int i = 0; i < order.length; ++i) {
            if (!ignoreDirections && !directions[order[i]]) continue;
            switch (order[i]) {
                case 0: {
                    this.considerAddingCoord(new ChunkPosition(x, y - 1, z), foam);
                    continue block8;
                }
                case 1: {
                    this.considerAddingCoord(new ChunkPosition(x, y + 1, z), foam);
                    continue block8;
                }
                case 2: {
                    this.considerAddingCoord(new ChunkPosition(x, y, z - 1), foam);
                    continue block8;
                }
                case 3: {
                    this.considerAddingCoord(new ChunkPosition(x, y, z + 1), foam);
                    continue block8;
                }
                case 4: {
                    this.considerAddingCoord(new ChunkPosition(x - 1, y, z), foam);
                    continue block8;
                }
                case 5: {
                    this.considerAddingCoord(new ChunkPosition(x + 1, y, z), foam);
                }
            }
        }
    }

    public void considerAddingCoord(ChunkPosition coord, ArrayList<ChunkPosition> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get((int)i).field_76930_a != coord.field_76930_a || list.get((int)i).field_76928_b != coord.field_76928_b || list.get((int)i).field_76929_c != coord.field_76929_c) continue;
            return;
        }
        list.add(coord);
    }

    @Override
    public List<String> getHudInfo(ItemStack itemStack) {
        LinkedList<String> info = new LinkedList<String>();
        info.add("Use Left: " + (itemStack.func_77958_k() - itemStack.func_77960_j()) / 100);
        return info;
    }

    public int[] generateRngSpread(Random random) {
        int[] re = new int[]{0, 1, 2, 3, 4, 5};
        for (int i = 0; i < 16; ++i) {
            int first = random.nextInt(6);
            int second = random.nextInt(6);
            int save = re[first];
            re[first] = re[second];
            re[second] = save;
        }
        return re;
    }

    public static int getSprayMass() {
        return 13;
    }

    @Override
    public boolean canBeStoredInToolbox(ItemStack itemstack) {
        return true;
    }
}

