/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.IItemHudInfo;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.init.InternalName;
import ic2.core.item.ItemIC2;
import ic2.core.util.StackUtil;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class ItemFluidCell
extends ItemIC2
implements IFluidContainerItem,
IItemHudInfo {
    protected final int capacity = 1000;

    public ItemFluidCell(Configuration config, InternalName internalName) {
        super(config, internalName);
    }

    @Override
    public String getTextureFolder() {
        return "cell";
    }

    @Override
    public String getTextureName(int index) {
        switch (index) {
            case 0: {
                return this.func_77658_a();
            }
            case 1: {
                return this.func_77658_a() + ".window";
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    Icon getWindowIcon() {
        return this.textures[1];
    }

    public boolean isRepairable() {
        return false;
    }

    @Override
    public List<String> getHudInfo(ItemStack itemStack) {
        LinkedList<String> info = new LinkedList<String>();
        FluidStack fs = this.getFluid(itemStack);
        if (fs != null) {
            info.add("Liquid: " + FluidRegistry.getFluidName((FluidStack)fs));
        } else {
            info.add("Liquid: none");
        }
        return info;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        float f9;
        float f6;
        float f8;
        double d3;
        float f5;
        float f = 1.0f;
        float f1 = entityplayer.field_70127_C + (entityplayer.field_70125_A - entityplayer.field_70127_C) * f;
        float f2 = entityplayer.field_70126_B + (entityplayer.field_70177_z - entityplayer.field_70126_B) * f;
        double d = entityplayer.field_70169_q + (entityplayer.field_70165_t - entityplayer.field_70169_q) * (double)f;
        double d1 = entityplayer.field_70167_r + (entityplayer.field_70163_u - entityplayer.field_70167_r) * (double)f + 1.62 - (double)entityplayer.field_70129_M;
        double d2 = entityplayer.field_70166_s + (entityplayer.field_70161_v - entityplayer.field_70166_s) * (double)f;
        Vec3 vec3d = Vec3.func_72443_a((double)d, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * 0.01745329f - 3.141593f));
        float f4 = MathHelper.func_76126_a((float)(-f2 * 0.01745329f - 3.141593f));
        float f7 = f4 * (f5 = -MathHelper.func_76134_b((float)(-f1 * 0.01745329f)));
        Vec3 vec3d1 = vec3d.func_72441_c((double)f7 * (d3 = 5.0), (double)(f8 = (f6 = MathHelper.func_76126_a((float)(-f1 * 0.01745329f)))) * d3, (double)(f9 = f3 * f5) * d3);
        MovingObjectPosition movingobjectposition = world.func_72901_a(vec3d, vec3d1, true);
        if (movingobjectposition == null) {
            return itemstack;
        }
        if (movingobjectposition.field_72313_a == EnumMovingObjectType.TILE) {
            int x = movingobjectposition.field_72311_b;
            int y = movingobjectposition.field_72312_c;
            int z = movingobjectposition.field_72309_d;
            if (!world.func_72962_a(entityplayer, x, y, z)) {
                return itemstack;
            }
            int blockid = world.func_72798_a(x, y, z);
            if (Block.field_71973_m[blockid] instanceof IFluidBlock) {
                IFluidBlock liquid = (IFluidBlock)Block.field_71973_m[blockid];
                if (liquid.canDrain(world, x, y, z)) {
                    ItemStack cell = new ItemStack(Ic2Items.FluidCell.func_77973_b(), 1);
                    this.fill(cell, new FluidStack(liquid.getFluid(), 1000), true);
                    if (this.storeCell(cell, entityplayer)) {
                        world.func_72832_d(x, y, z, 0, 0, 3);
                        --itemstack.field_77994_a;
                    }
                }
            } else if (world.func_72798_a(x, y, z) == Block.field_71943_B.field_71990_ca) {
                ItemStack cell = new ItemStack(Ic2Items.FluidCell.func_77973_b(), 1);
                this.fill(cell, new FluidStack(FluidRegistry.WATER, 1000), true);
                if (this.storeCell(cell, entityplayer)) {
                    world.func_72832_d(x, y, z, 0, 0, 3);
                    --itemstack.field_77994_a;
                }
            } else if (world.func_72798_a(x, y, z) == Block.field_71938_D.field_71990_ca) {
                ItemStack cell = new ItemStack(Ic2Items.FluidCell.func_77973_b(), 1);
                this.fill(cell, new FluidStack(FluidRegistry.LAVA, 1000), true);
                if (this.storeCell(cell, entityplayer)) {
                    world.func_72832_d(x, y, z, 0, 0, 3);
                    --itemstack.field_77994_a;
                }
            }
        }
        return itemstack;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!IC2.platform.isSimulating()) {
            return false;
        }
        TileEntity te = world.func_72796_p(x, y, z);
        if (!(te instanceof IFluidHandler)) {
            return false;
        }
        IFluidHandler handler = (IFluidHandler)te;
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        FluidStack fs = this.getFluid(stack);
        if (fs == null || player.func_70093_af() && fs.amount < 1000) {
            int amount = fs == null ? 1000 : 1000 - fs.amount;
            FluidStack input = handler.drain(dir, amount, false);
            if (input == null || input.amount <= 0) {
                return false;
            }
            boolean separateOutput = false;
            if (stack.field_77994_a > 1) {
                stack = stack.func_77979_a(1);
                separateOutput = true;
            }
            this.fill(stack, input, true);
            if (!separateOutput || this.storeCell(stack, player)) {
                handler.drain(dir, amount, true);
                return true;
            }
        } else {
            int amount = handler.fill(dir, fs, false);
            if (amount <= 0) {
                return false;
            }
            boolean separateOutput = false;
            if (stack.field_77994_a > 1) {
                stack = stack.func_77979_a(1);
                separateOutput = true;
            }
            this.drain(stack, amount, true);
            if (!separateOutput || this.storeCell(stack, player)) {
                handler.fill(dir, fs, true);
                return true;
            }
        }
        return false;
    }

    public boolean storeCell(ItemStack cell, EntityPlayer player) {
        if (player.field_71071_by.func_70441_a(cell)) {
            if (!IC2.platform.isRendering()) {
                player.field_71070_bA.func_75142_b();
            }
            return true;
        }
        return false;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean b) {
        FluidStack fs = this.getFluid(itemStack);
        if (fs != null) {
            info.add("< " + FluidRegistry.getFluidName((FluidStack)fs) + ", " + fs.amount + " mB >");
        } else {
            info.add("< Empty >");
        }
    }

    public FluidStack getFluid(ItemStack stack) {
        NBTTagCompound nbtTagCompound = StackUtil.getOrCreateNbtData(stack);
        NBTTagCompound fluidTag = nbtTagCompound.func_74775_l("Fluid");
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
    }

    public boolean isEmpty(ItemStack stack) {
        return this.getFluid(stack) == null;
    }

    public int getCapacity(ItemStack container) {
        return 1000;
    }

    public int fill(ItemStack stack, FluidStack resource, boolean doFill) {
        if (stack.field_77994_a != 1) {
            return 0;
        }
        if (resource == null) {
            return 0;
        }
        NBTTagCompound nbtTagCompound = StackUtil.getOrCreateNbtData(stack);
        NBTTagCompound fluidTag = nbtTagCompound.func_74775_l("Fluid");
        FluidStack fs = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        if (fs == null) {
            fs = new FluidStack(resource, 0);
        }
        if (!fs.isFluidEqual(resource)) {
            return 0;
        }
        int amount = Math.min(1000 - fs.amount, resource.amount);
        if (doFill && amount > 0) {
            fs.amount += amount;
            fs.writeToNBT(fluidTag);
            nbtTagCompound.func_74782_a("Fluid", (NBTBase)fluidTag);
        }
        return amount;
    }

    public FluidStack drain(ItemStack stack, int maxDrain, boolean doDrain) {
        if (stack.field_77994_a != 1) {
            return null;
        }
        NBTTagCompound nbtTagCompound = StackUtil.getOrCreateNbtData(stack);
        NBTTagCompound fluidTag = nbtTagCompound.func_74775_l("Fluid");
        FluidStack fs = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        if (fs == null) {
            return null;
        }
        maxDrain = Math.min(fs.amount, maxDrain);
        if (doDrain) {
            fs.amount -= maxDrain;
            if (fs.amount <= 0) {
                nbtTagCompound.func_82580_o("Fluid");
            } else {
                fs.writeToNBT(fluidTag);
                nbtTagCompound.func_74782_a("Fluid", (NBTBase)fluidTag);
            }
        }
        return new FluidStack(fs, maxDrain);
    }
}

