/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.init;

import ic2.core.IC2;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class Libraries {
    private static final String srcLibDir = "lib";

    public static void init() {
        URL location = Libraries.class.getProtectionDomain().getCodeSource().getLocation();
        File destination = new File(IC2.platform.getMinecraftDir(), "mods");
        if (location.getProtocol().equals("jar")) {
            try {
                destination = new File(((JarURLConnection)location.openConnection()).getJarFileURL().toURI()).getParentFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!(destination = new File(destination, "ic2")).exists()) {
            destination.mkdir();
        }
        if (!destination.exists() || !destination.isDirectory()) {
            throw new RuntimeException("can't create mods/ic2 dir");
        }
        try {
            Libraries.extractFiles(destination);
        }
        catch (Exception e) {
            throw new RuntimeException("library extraction failed", e);
        }
        try {
            Libraries.loadFiles(destination);
        }
        catch (Exception e) {
            throw new RuntimeException("library loading failed", e);
        }
    }

    private static void extractFiles(File destination) throws IOException, URISyntaxException {
        File dstFile;
        Object source;
        URL location = Libraries.class.getProtectionDomain().getCodeSource().getLocation();
        String protocol = location.getProtocol();
        HashSet<String> validFiles = new HashSet<String>();
        if (protocol.equals("file")) {
            source = new File(location.toURI());
            for (int i = Libraries.class.getPackage().getName().replaceAll("[^\\.]", "").length() + 1; i >= 0; --i) {
                source = ((File)source).getParentFile();
            }
            source = new File((File)source, srcLibDir);
            for (File srcFile : ((File)source).listFiles()) {
                dstFile = new File(destination, srcFile.getName());
                if (!dstFile.exists() || dstFile.length() != srcFile.length()) {
                    FileUtils.copyFile((File)srcFile, (File)dstFile);
                    IC2.log.info("Extracted library " + srcFile.getName());
                }
                validFiles.add(srcFile.getName());
            }
        } else if (protocol.equals("jar")) {
            source = ((JarURLConnection)location.openConnection()).getJarFile();
            Enumeration<JarEntry> e = ((JarFile)source).entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                String name = entry.getName();
                if (entry.isDirectory() || !FilenameUtils.getPathNoEndSeparator((String)name).equals(srcLibDir)) continue;
                String fileName = FilenameUtils.getName((String)name);
                dstFile = new File(destination, fileName);
                if (!dstFile.exists() || dstFile.length() != entry.getSize()) {
                    FileUtils.copyInputStreamToFile((InputStream)((JarFile)source).getInputStream(entry), (File)dstFile);
                    IC2.log.info("Extracted library " + fileName);
                }
                validFiles.add(fileName);
            }
        } else {
            throw new RuntimeException("invalid protocol (" + location + ")");
        }
        for (File file : destination.listFiles()) {
            if (validFiles.contains(file.getName())) continue;
            file.delete();
            IC2.log.info("Removed old library " + file.getName());
        }
    }

    private static void loadFiles(File dir) throws MalformedURLException {
        LaunchClassLoader classLoader = (LaunchClassLoader)Libraries.class.getClassLoader();
        for (File file : dir.listFiles()) {
            classLoader.addURL(file.toURI().toURL());
            IC2.log.info("Loaded library " + file.getName());
        }
    }
}

