/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.energy;

import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.core.IC2;
import ic2.core.energy.CalculationResult;
import ic2.core.energy.EnergyNetLocal;
import ic2.core.energy.GridCalculation;
import ic2.core.energy.Node;
import ic2.core.energy.NodeLink;
import ic2.core.energy.NodeType;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.minecraft.tileentity.TileEntity;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.factory.LinearSolver;
import org.ejml.factory.LinearSolverFactory;

class Grid {
    private static final boolean debugOutput = false;
    private static final boolean debug = false;
    private static final boolean enableCache = true;
    final int uid;
    final EnergyNetLocal energyNet;
    Map<Integer, Node> nodes = new HashMap<Integer, Node>();
    List<Node> activeSources = new ArrayList<Node>();
    List<Node> activeSinks = new ArrayList<Node>();
    Set<Node> prevActiveSinks = new HashSet<Node>();
    Map<Integer, Node> optimizedNodes;
    List<Node> emittingNodes;
    DenseMatrix64F networkMatrix;
    DenseMatrix64F sourceMatrix;
    DenseMatrix64F resultMatrix;
    LinearSolver<DenseMatrix64F> solver;
    Future<CalculationResult> calculation;

    Grid(EnergyNetLocal energyNet) {
        this.uid = EnergyNetLocal.nextGridUid++;
        this.energyNet = energyNet;
        energyNet.grids.add(this);
    }

    public String toString() {
        return "Grid " + this.uid;
    }

    void add(Node node, Collection<Node> neighbors) {
        this.invalidate();
        this.add(node);
        for (Node neighbor : neighbors) {
            double loss = (node.getInnerLoss() + neighbor.getInnerLoss()) / 2.0;
            NodeLink link = new NodeLink(node, neighbor, loss);
            node.links.add(link);
            neighbor.links.add(link);
        }
    }

    void remove(Node node) {
        Node neighbor;
        this.invalidate();
        Iterator<NodeLink> it = node.links.iterator();
        while (it.hasNext()) {
            NodeLink link = it.next();
            neighbor = link.getNeighbor(node);
            Iterator<NodeLink> it2 = neighbor.links.iterator();
            while (it2.hasNext()) {
                if (it2.next() != link) continue;
                it2.remove();
                break;
            }
            if (!neighbor.links.isEmpty() || !neighbor.tile.removeExtraNode(neighbor)) continue;
            it.remove();
            this.nodes.remove(neighbor.uid);
        }
        this.nodes.remove(node.uid);
        if (node.links.isEmpty()) {
            this.energyNet.grids.remove(this);
        } else if (node.links.size() > 1) {
            int i;
            ArrayList nodeTable = new ArrayList();
            for (i = 0; i < node.links.size(); ++i) {
                Node cNode;
                neighbor = node.links.get(i).getNeighbor(node);
                HashSet<Node> connectedNodes = new HashSet<Node>();
                LinkedList<Node> nodesToCheck = new LinkedList<Node>(Arrays.asList(neighbor));
                while ((cNode = (Node)nodesToCheck.poll()) != null) {
                    connectedNodes.add(cNode);
                    for (NodeLink link : cNode.links) {
                        Node nNode = link.getNeighbor(cNode);
                        if (connectedNodes.contains(nNode)) continue;
                        nodesToCheck.add(nNode);
                    }
                }
                nodeTable.add(connectedNodes);
            }
            assert (nodeTable.size() == node.links.size());
            for (i = 1; i < node.links.size(); ++i) {
                Set connectedNodes = (Set)nodeTable.get(i);
                Node neighbor2 = node.links.get(i).getNeighbor(node);
                assert (connectedNodes.contains(neighbor2));
                boolean found = false;
                for (int j = 0; j < i; ++j) {
                    Set cmpList = (Set)nodeTable.get(j);
                    if (!cmpList.contains(neighbor2)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                Grid grid = new Grid(this.energyNet);
                for (Node cNode : connectedNodes) {
                    assert (this.nodes.containsKey(cNode.uid));
                    this.nodes.remove(cNode.uid);
                    grid.add(cNode);
                }
            }
        }
    }

    void merge(Grid grid) {
        assert (this.energyNet.grids.contains(grid));
        this.invalidate();
        for (Node node : grid.nodes.values()) {
            this.add(node);
        }
        this.energyNet.grids.remove(grid);
    }

    void prepareCalculation(Set<IEnergySource> activeSourceTiles) {
        assert (this.calculation == null);
        this.activeSources.clear();
        this.activeSinks.clear();
        for (Node node : this.nodes.values()) {
            assert (node.grid == this);
            switch (node.nodeType) {
                case Source: {
                    node.amount = ((IEnergySource)node.tile.entity).getOfferedEnergy();
                    if (!(node.amount > 0.0)) break;
                    this.activeSources.add(node);
                    break;
                }
                case Sink: {
                    node.amount = ((IEnergySink)node.tile.entity).demandedEnergyUnits();
                    if (!(node.amount > 0.0)) break;
                    this.activeSinks.add(node);
                    break;
                }
                case Conductor: {
                    node.amount = 0.0;
                }
            }
        }
        if (!this.activeSinks.isEmpty()) {
            for (Node node : this.activeSources) {
                activeSourceTiles.add((IEnergySource)node.tile.entity);
            }
        }
    }

    void startCalculation() {
        assert (this.calculation == null);
        if (!this.activeSources.isEmpty() && !this.activeSinks.isEmpty()) {
            this.calculation = IC2.getInstance().threadPool.submit(new GridCalculation(this));
        }
    }

    void finishCalculation() {
        if (this.calculation == null) {
            return;
        }
        try {
            CalculationResult result = this.calculation.get();
            for (Map.Entry<TileEntity, Double> entry : result.changes.entrySet()) {
                this.energyNet.addChange(entry.getKey(), entry.getValue());
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        this.calculation = null;
    }

    void calculate(Map<TileEntity, Double> changes) {
        for (Node node : this.activeSources) {
            int shareCount = 1;
            for (Node shared : node.tile.nodes) {
                if (shared == node || shared.nodeType != NodeType.Source) continue;
                assert (shared.grid.activeSources.contains(shared));
                assert (shared.grid != this);
                ++shareCount;
            }
            node.amount /= (double)shareCount;
        }
        this.calculateDistribution();
        this.calculateEffects(changes);
    }

    private void add(Node node) {
        node.grid = this;
        this.nodes.put(node.uid, node);
    }

    private void invalidate() {
        this.finishCalculation();
        this.optimizedNodes = null;
    }

    private void optimize() {
        int removed;
        this.optimizedNodes = new HashMap<Integer, Node>();
        for (Node node : this.nodes.values()) {
            if (node.nodeType == NodeType.Sink && !(node.amount > 0.0)) continue;
            this.optimizedNodes.put(node.uid, new Node(node));
        }
        for (Node node : this.optimizedNodes.values()) {
            ListIterator<NodeLink> it = node.links.listIterator();
            while (it.hasNext()) {
                NodeLink link = it.next();
                Node neighbor = link.getNeighbor(node.uid);
                if (neighbor.nodeType == NodeType.Sink && this.nodes.get((Object)Integer.valueOf((int)neighbor.uid)).amount <= 0.0) {
                    it.remove();
                    continue;
                }
                if (link.nodeA.uid == node.uid) {
                    link.nodeA = this.optimizedNodes.get(link.nodeA.uid);
                    link.nodeB = this.optimizedNodes.get(link.nodeB.uid);
                    assert (link.nodeA != null && link.nodeB != null);
                    HashSet<Node> newSkippedNodes = new HashSet<Node>();
                    for (Node skippedNode : link.skippedNodes) {
                        newSkippedNodes.add(this.optimizedNodes.get(skippedNode.uid));
                    }
                    link.skippedNodes = newSkippedNodes;
                    continue;
                }
                assert (link.nodeB.uid == node.uid);
                boolean foundReverseLink = false;
                for (NodeLink reverseLink : this.optimizedNodes.get((Object)Integer.valueOf((int)link.nodeA.uid)).links) {
                    assert (reverseLink.nodeA.uid != node.uid);
                    if (reverseLink.nodeB.uid != node.uid) continue;
                    assert (reverseLink.nodeA.uid == link.nodeA.uid);
                    foundReverseLink = true;
                    it.set(reverseLink);
                    break;
                }
                assert (foundReverseLink);
            }
        }
        do {
            removed = 0;
            Iterator<Node> it = this.optimizedNodes.values().iterator();
            while (it.hasNext()) {
                Iterator<NodeLink> it2;
                Node node = it.next();
                if (node.nodeType != NodeType.Conductor) continue;
                if (node.links.size() < 2) {
                    it.remove();
                    ++removed;
                    for (NodeLink link : node.links) {
                        boolean found = false;
                        Iterator<NodeLink> it22 = link.getNeighbor((Node)node).links.iterator();
                        while (it22.hasNext()) {
                            if (it22.next() != link) continue;
                            found = true;
                            it22.remove();
                            break;
                        }
                        assert (found);
                    }
                    continue;
                }
                if (node.links.size() == 2) {
                    it.remove();
                    ++removed;
                    NodeLink linkA = node.links.get(0);
                    NodeLink linkB = node.links.get(1);
                    Node neighborA = linkA.getNeighbor(node);
                    Node neighborB = linkB.getNeighbor(node);
                    linkA.loss += linkB.loss;
                    linkA.skippedNodes.addAll(linkB.skippedNodes);
                    linkA.skippedNodes.add(node);
                    if (linkA.nodeA == node) {
                        linkA.nodeA = neighborB;
                    } else {
                        linkA.nodeB = neighborB;
                    }
                    assert (linkA.nodeA != linkA.nodeB);
                    assert (linkA.nodeA == neighborA || linkA.nodeB == neighborA);
                    assert (linkA.nodeA == neighborB || linkA.nodeB == neighborB);
                    boolean found = false;
                    it2 = neighborB.links.listIterator();
                    while (it2.hasNext()) {
                        if (it2.next() != linkB) continue;
                        found = true;
                        it2.set(linkA);
                        break;
                    }
                    assert (found);
                    continue;
                }
                int neighborSinkCount = 0;
                int neighborConductorCount = 0;
                for (NodeLink link : node.links) {
                    switch (link.getNeighbor((Node)node).nodeType) {
                        case Source: {
                            break;
                        }
                        case Sink: {
                            ++neighborSinkCount;
                            break;
                        }
                        case Conductor: {
                            ++neighborConductorCount;
                        }
                    }
                }
                if (neighborSinkCount != 0 && neighborConductorCount != 0 || neighborSinkCount != 1 && neighborConductorCount != true) continue;
                it.remove();
                ++removed;
                NodeLink outputLink = null;
                for (NodeLink link : node.links) {
                    Node neighbor = link.getNeighbor(node);
                    if (neighbor.nodeType == NodeType.Sink) {
                        outputLink = link;
                        break;
                    }
                    if (neighbor.nodeType != NodeType.Conductor) continue;
                    outputLink = link;
                    break;
                }
                assert (outputLink != null);
                Node outputNode = outputLink.getNeighbor(node);
                boolean found = false;
                it2 = outputNode.links.iterator();
                while (it2.hasNext()) {
                    if (it2.next() != outputLink) continue;
                    found = true;
                    it2.remove();
                    break;
                }
                assert (found);
                for (NodeLink link : node.links) {
                    if (link == outputLink) continue;
                    if (link.nodeA == node) {
                        link.nodeA = outputNode;
                    } else if (link.nodeB == node) {
                        link.nodeB = outputNode;
                    }
                    link.loss += outputLink.loss;
                    link.skippedNodes.addAll(outputLink.skippedNodes);
                    link.skippedNodes.add(node);
                    outputNode.links.add(link);
                }
            }
        } while (removed > 0);
    }

    private void determineEmittingNodes() {
        if (this.emittingNodes == null) {
            this.emittingNodes = new ArrayList<Node>();
        } else {
            this.emittingNodes.clear();
        }
        boolean index = false;
        for (Node node : this.optimizedNodes.values()) {
            switch (node.nodeType) {
                case Source: {
                    this.emittingNodes.add(node);
                    break;
                }
                case Sink: {
                    break;
                }
                case Conductor: {
                    this.emittingNodes.add(node);
                }
            }
        }
    }

    private void populateNetworkMatrix() {
        for (int row = 0; row < this.emittingNodes.size(); ++row) {
            Node node = this.emittingNodes.get(row);
            block1: for (int col = 0; col < this.emittingNodes.size(); ++col) {
                if (row == col) {
                    double sum = 0.0;
                    for (NodeLink link : node.links) {
                        Node neighbor = link.getNeighbor(node);
                        sum += 1.0 / link.loss;
                    }
                    this.networkMatrix.set(row, col, sum);
                    continue;
                }
                this.networkMatrix.set(row, col, 0.0);
                Node possibleNeighbor = this.emittingNodes.get(col);
                for (NodeLink link : node.links) {
                    if (link.getNeighbor(node) != possibleNeighbor) continue;
                    this.networkMatrix.set(row, col, -1.0 / link.loss);
                    continue block1;
                }
            }
        }
    }

    private void populateSourceMatrix() {
        for (int row = 0; row < this.emittingNodes.size(); ++row) {
            Node node = this.emittingNodes.get(row);
            double input = 0.0;
            if (node.nodeType == NodeType.Source) {
                Node realNode = this.nodes.get(node.uid);
                input = realNode.amount;
            }
            this.sourceMatrix.set(row, 0, input);
        }
    }

    private void calculateDistribution() {
        long time = System.nanoTime();
        if (this.optimizedNodes == null || this.prevActiveSinks.size() != this.activeSinks.size() || !this.prevActiveSinks.containsAll(this.activeSinks)) {
            this.prevActiveSinks.clear();
            this.prevActiveSinks.addAll(this.activeSinks);
            this.optimize();
            this.determineEmittingNodes();
            if (this.networkMatrix == null || this.networkMatrix.numCols != this.emittingNodes.size()) {
                this.networkMatrix = new DenseMatrix64F(this.emittingNodes.size(), this.emittingNodes.size());
                this.sourceMatrix = new DenseMatrix64F(this.emittingNodes.size(), 1);
                this.resultMatrix = new DenseMatrix64F(this.emittingNodes.size(), 1);
            }
            this.populateNetworkMatrix();
            this.solver = LinearSolverFactory.symmPosDef((int)this.emittingNodes.size());
            if (!this.solver.setA((Matrix64F)this.networkMatrix)) {
                throw new RuntimeException("incompatible matrix");
            }
        }
        this.populateSourceMatrix();
        this.solver.solve((Matrix64F)this.sourceMatrix, (Matrix64F)this.resultMatrix);
        time = System.nanoTime() - time;
    }

    private void calculateEffects(Map<TileEntity, Double> changes) {
        long time = System.nanoTime();
        for (Node node : this.optimizedNodes.values()) {
            Node realNode = this.nodes.get(node.uid);
            if (node.nodeType == NodeType.Source || node.nodeType != NodeType.Sink) continue;
            double sum = 0.0;
            block1: for (NodeLink link : node.links) {
                Node neighbor = link.getNeighbor(node);
                for (int row = 0; row < this.emittingNodes.size(); ++row) {
                    if (this.emittingNodes.get(row) != neighbor) continue;
                    sum += this.resultMatrix.get(row) / link.loss;
                    continue block1;
                }
            }
            if (changes.containsKey(node.tile.entity)) {
                changes.put(node.tile.entity, changes.get(node.tile.entity) + sum);
                continue;
            }
            changes.put(node.tile.entity, sum);
        }
        time = System.nanoTime() - time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpGraph() {
        this.finishCalculation();
        for (int i = 0; i < 2 && (i != 1 || this.optimizedNodes != null); ++i) {
            OutputStreamWriter out = null;
            try {
                out = new FileWriter("graph_" + this.uid + "_" + (i == 0 ? "raw" : "optimized") + ".txt");
                out.write("graph nodes {\n  overlap=false;\n");
                Collection<Node> nodesToDump = (i == 0 ? this.nodes : this.optimizedNodes).values();
                HashSet<Node> dumpedConnections = new HashSet<Node>();
                for (Node node : nodesToDump) {
                    out.write("  \"" + node + "\";\n");
                    for (NodeLink link : node.links) {
                        Node neighbor = link.getNeighbor(node);
                        if (dumpedConnections.contains(neighbor)) continue;
                        out.write("  \"" + node + "\" -- \"" + neighbor + "\" [label=\"" + link.loss + "\"];\n");
                    }
                    dumpedConnections.add(node);
                }
                out.write("}\n");
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    void dumpMatrix(PrintStream ps) {
        if (this.networkMatrix == null || this.sourceMatrix == null || this.resultMatrix == null) {
            ps.println("matrixes unavailable");
        } else {
            ps.println("emitting node indizes:");
            for (int i = 0; i < this.emittingNodes.size(); ++i) {
                Node node = this.emittingNodes.get(i);
                ps.println(i + " " + node + " (amount=" + this.nodes.get((Object)Integer.valueOf((int)node.uid)).amount + ")");
            }
            ps.println("network matrix:");
            ps.print(this.networkMatrix.toString());
            ps.println("source matrix:");
            ps.print(this.sourceMatrix.toString());
            ps.println("result matrix:");
            ps.print(this.resultMatrix.toString());
        }
    }

    void dumpStats(PrintStream ps) {
        ps.println(this.nodes.size() + " nodes");
        if (this.optimizedNodes != null) {
            ps.println(this.optimizedNodes.size() + " nodes after optimization");
        }
        if (this.emittingNodes != null) {
            ps.println(this.emittingNodes.size() + " emitting nodes");
        }
    }
}

