/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.recipe.IPatternStorage;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import ic2.core.BasicMachineRecipeManager;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.machine.ContainerScanner;
import ic2.core.block.machine.gui.GuiScanner;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.init.ScannerRecipes;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileEntityScanner
extends TileEntityElectricMachine
implements IHasGui,
INetworkClientTileEntityEventListener {
    public ItemStack recordedStack = null;
    public int recordedAmountUU = -1;
    public int recordedAmountEU = -1;
    public int energyusecycle = 256;
    public short mode = 0;
    public short scanningloop = 0;
    public short progress = 0;
    public final InvSlot ScannerSlot = new InvSlot(this, "ScannerSlot", 1, InvSlot.Access.I, 1, InvSlot.InvSide.TOP);
    public float serverChargeLevel;
    private static final Direction[] directions = Direction.values();

    public TileEntityScanner() {
        super(512000, 3, 0);
    }

    public static void init() {
        Recipes.Scanner = new BasicMachineRecipeManager();
        ScannerRecipes.AddScannerRecipes();
    }

    public static void addRecipe(ItemStack output, int recordedAmountUU, int recordedAmountEU) {
        assert (recordedAmountEU <= Integer.MAX_VALUE);
        NBTTagCompound metadata = new NBTTagCompound();
        metadata.func_74768_a("recordedAmountUU", recordedAmountUU);
        metadata.func_74768_a("recordedAmountEU", recordedAmountEU);
        Recipes.Scanner.addRecipe(new RecipeInputItemStack(output), metadata, new ItemStack[0]);
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        boolean needsInvUpdate = false;
        if (this.mode == 3 || this.mode == 4 || this.mode == 5) {
            if (this.getActive()) {
                this.setActive(false);
            }
            if (this.scanningloop != 0) {
                this.scanningloop = 0;
            }
            if (this.progress != 0) {
                this.progress = 0;
            }
        } else if (this.ScannerSlot.isEmpty()) {
            if (this.getMode() != 0) {
                this.setMode((short)0);
            }
            if (this.getActive()) {
                this.setActive(false);
            }
            if (this.scanningloop != 0) {
                this.scanningloop = 0;
            }
            if (this.progress != 0) {
                this.progress = 0;
            }
        } else if (this.energy >= (double)this.energyusecycle) {
            if (this.getActive()) {
                this.setActive(true);
            }
            if (this.getMode() != 1) {
                this.setMode((short)1);
            }
            if (this.scanningloop >= 66) {
                this.scanningloop = 0;
                this.progress = (short)(this.progress + 1);
                if (this.progress >= 100) {
                    needsInvUpdate = this.doScan();
                }
            }
            this.scanningloop = (short)(this.scanningloop + 1);
            this.energy -= (double)this.energyusecycle;
        } else {
            if (this.getActive()) {
                this.setActive(false);
            }
            if (this.getMode() != 2) {
                this.setMode((short)2);
            }
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
    }

    public boolean doScan() {
        RecipeOutput recipe = Recipes.Scanner.getOutputFor(this.ScannerSlot.get(), true);
        if (recipe != null) {
            this.recordedAmountUU = recipe.metadata.func_74762_e("recordedAmountUU");
            this.recordedAmountEU = recipe.metadata.func_74762_e("recordedAmountEU");
            this.recordedStack = this.ScannerSlot.get().func_77946_l();
            this.ScannerSlot.put(null);
            if (this.getMode() != 4) {
                this.setMode((short)4);
            }
            return true;
        }
        if (this.getMode() != 3) {
            this.setMode((short)3);
        }
        return false;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.progress = nbttagcompound.func_74765_d("progress");
        this.mode = nbttagcompound.func_74765_d("mode");
        this.recordedAmountUU = nbttagcompound.func_74762_e("recordedAmountUU");
        this.recordedAmountEU = nbttagcompound.func_74762_e("recordedAmountEU");
        NBTTagCompound contentTag = new NBTTagCompound();
        contentTag = nbttagcompound.func_74775_l("recordedStack");
        this.recordedStack = ItemStack.func_77949_a((NBTTagCompound)contentTag);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74777_a("progress", this.progress);
        nbttagcompound.func_74777_a("mode", this.mode);
        nbttagcompound.func_74768_a("recordedAmountUU", this.recordedAmountUU);
        nbttagcompound.func_74768_a("recordedAmountEU", this.recordedAmountEU);
        if (this.recordedStack != null) {
            NBTTagCompound contentTag = new NBTTagCompound();
            contentTag = nbttagcompound.func_74775_l("recordedStack");
            this.recordedStack.func_77955_b(contentTag);
        }
    }

    public short getMode() {
        return this.mode;
    }

    public void setMode(short mode) {
        this.mode = mode;
    }

    public float getChargeLevel() {
        float ret;
        if (IC2.platform.isSimulating()) {
            ret = (float)this.energy / (float)(this.maxEnergy - this.maxInput + 1);
            if (ret > 1.0f) {
                ret = 1.0f;
            }
        } else {
            ret = this.serverChargeLevel;
        }
        return ret;
    }

    public void setChargeLevel(float chargeLevel) {
        assert (!IC2.platform.isSimulating());
        this.serverChargeLevel = chargeLevel;
    }

    public short getProgress() {
        return this.progress;
    }

    public void setProgress(short i) {
        this.progress = i;
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerScanner(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiScanner(new ContainerScanner(entityPlayer, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public String func_70303_b() {
        return "scanner";
    }

    public IPatternStorage getPatternStorage() {
        for (Direction direction : directions) {
            TileEntity target = direction.applyToTileEntity(this);
            if (!(target instanceof IPatternStorage)) continue;
            return (IPatternStorage)target;
        }
        return null;
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        switch (event) {
            case 0: {
                if (this.getMode() == 0) break;
                this.setMode((short)0);
                break;
            }
            case 1: {
                if (this.getPatternStorage() != null) {
                    if (this.getPatternStorage().transferPattern(this.recordedStack, this.recordedAmountUU, this.recordedAmountEU)) {
                        if (this.getMode() != 0) {
                            this.setMode((short)0);
                        }
                        this.recordedStack = null;
                        this.recordedAmountUU = -1;
                        this.recordedAmountEU = -1;
                        break;
                    }
                    if (this.getMode() == 5) break;
                    this.setMode((short)5);
                    break;
                }
                if (this.getMode() == 5) break;
                this.setMode((short)5);
            }
        }
    }
}

