/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.recipe.IPatternStorage;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.TileEntityLiquidTankElectricMachine;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.machine.ContainerReplicator;
import ic2.core.block.machine.gui.GuiReplicator;
import java.util.List;
import java.util.Vector;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityReplicator
extends TileEntityLiquidTankElectricMachine
implements IHasGui,
INetworkClientTileEntityEventListener {
    public short progressUU = 0;
    public short progressEU = 0;
    public int BufferAmountUU = -1;
    public int BufferAmountEU = -1;
    public int RecipeAmountUU = -1;
    public int RecipeAmountEU = -1;
    public IPatternStorage Storage = null;
    public short index = 0;
    public short mode = 0;
    public ItemStack InfoItem = null;
    public final InvSlotConsumableLiquid fluidSlot = new InvSlotConsumableLiquid((TileEntityInventory)this, "fluid", 0, 1, FluidRegistry.getFluid((String)"uumater"));
    public final InvSlotOutput cellSlot = new InvSlotOutput(this, "cell", 0, 1);
    public final InvSlotOutput Output = new InvSlotOutput(this, "output", 0, 1);
    public float serverChargeLevel;
    private static final Direction[] directions = Direction.values();

    public TileEntityReplicator() {
        super(1048000, 4, 0, 16);
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        boolean needsInvUpdate = false;
        boolean init = true;
        if (this.needsFluid()) {
            this.gainFluid();
        }
        if (this.Storage == null) {
            this.scanforPatternStorage();
        }
        if (init && this.Storage != null) {
            this.refreshPattern();
            init = false;
        }
        if (this.mode == 0) {
            if (this.getActive()) {
                this.setActive(false);
            }
            if (this.progressUU != 0) {
                this.progressUU = 0;
            }
            if (this.progressEU != 0) {
                this.progressEU = 0;
            }
            if (this.BufferAmountUU != 0) {
                this.BufferAmountUU = 0;
            }
            if (this.BufferAmountEU != 0) {
                this.BufferAmountEU = 0;
            }
        } else if ((this.mode == 1 || this.mode == 2) && this.InfoItem != null && this.energy >= 512.0) {
            if (!this.Output.canAdd(new ItemStack(this.InfoItem.func_77973_b(), 1))) {
                this.mode = 0;
            } else if (this.BufferAmountUU >= this.RecipeAmountUU && this.BufferAmountEU >= this.RecipeAmountEU) {
                this.replicateItem();
            } else {
                if (this.BufferAmountUU < this.RecipeAmountUU && this.fluidtank.getFluidAmount() > 0) {
                    this.BufferAmountUU += this.fluidtank.drain((int)1, (boolean)true).amount;
                    this.progressUU = (short)(this.BufferAmountUU * 100 / this.RecipeAmountUU);
                }
                if (this.BufferAmountEU < this.RecipeAmountEU) {
                    this.energy -= 512.0;
                    this.BufferAmountEU += 512;
                    this.progressEU = (short)(this.BufferAmountEU * 100 / this.RecipeAmountEU);
                }
                if (this.BufferAmountEU > this.RecipeAmountEU) {
                    this.energy += (double)(this.BufferAmountEU - this.RecipeAmountEU);
                    this.BufferAmountEU = this.RecipeAmountEU;
                    this.progressEU = (short)(this.BufferAmountEU * 100 / this.RecipeAmountEU);
                }
            }
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
    }

    private void replicateItem() {
        this.Output.add(new ItemStack(this.InfoItem.func_77973_b(), 1));
        this.BufferAmountUU = 0;
        this.BufferAmountEU = 0;
        if (this.mode == 1) {
            this.mode = 0;
        } else {
            if (this.progressUU != 0) {
                this.progressUU = 0;
            }
            if (this.progressEU != 0) {
                this.progressEU = 0;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiReplicator(new ContainerReplicator(entityPlayer, this));
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerReplicator(entityPlayer, this);
    }

    public boolean gainFluid() {
        return this.fluidSlot.transfertoTank((IFluidTank)this.fluidtank, this.cellSlot, false);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.index = nbttagcompound.func_74765_d("index");
        this.mode = nbttagcompound.func_74765_d("mode");
        this.progressUU = nbttagcompound.func_74765_d("progressUU");
        this.progressEU = nbttagcompound.func_74765_d("progressEU");
        this.BufferAmountEU = nbttagcompound.func_74762_e("BufferAmountEU");
        this.BufferAmountUU = nbttagcompound.func_74762_e("BufferAmountUU");
        NBTTagCompound contentTag = new NBTTagCompound();
        contentTag = nbttagcompound.func_74775_l("recordedStack");
        this.InfoItem = ItemStack.func_77949_a((NBTTagCompound)contentTag);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74777_a("index", this.index);
        nbttagcompound.func_74777_a("mode", this.mode);
        nbttagcompound.func_74777_a("progressUU", this.progressUU);
        nbttagcompound.func_74777_a("progressEU", this.progressEU);
        nbttagcompound.func_74768_a("BufferAmountUU", this.BufferAmountUU);
        nbttagcompound.func_74768_a("BufferAmountEU", this.BufferAmountEU);
        if (this.InfoItem != null) {
            NBTTagCompound contentTag = new NBTTagCompound();
            contentTag = nbttagcompound.func_74775_l("recordedStack");
            new ItemStack(this.InfoItem.func_77973_b(), 1).func_77955_b(contentTag);
        }
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        if (this.Storage != null) {
            switch (event) {
                case 0: {
                    if (this.mode != 0) break;
                    this.index = (short)(this.index - 1);
                    if (this.index < 0) {
                        this.index = this.Storage.getPatternCount();
                    }
                    this.refreshPattern();
                    break;
                }
                case 1: {
                    if (this.mode != 0) break;
                    this.index = (short)(this.index + 1);
                    if (this.index > this.Storage.getPatternCount()) {
                        this.index = 0;
                    }
                    this.refreshPattern();
                    break;
                }
                case 3: {
                    if (this.mode == 0) break;
                    this.mode = 0;
                    break;
                }
                case 4: {
                    if (this.mode == 1) break;
                    this.mode = 1;
                    break;
                }
                case 5: {
                    if (this.mode == 2) break;
                    this.mode = (short)2;
                }
            }
        }
    }

    public void refreshPattern() {
        int[] Values2;
        this.InfoItem = this.Storage.getPatternItemstack(this.index);
        IC2.network.updateTileEntityField(this, "InfoItem");
        if (this.InfoItem != null && (Values2 = this.Storage.getPatternvalus(this.InfoItem)) != null) {
            this.RecipeAmountUU = Values2[0];
            this.RecipeAmountEU = Values2[1];
        }
    }

    @Override
    public List<String> getNetworkedFields() {
        Vector<String> ret = new Vector<String>();
        ret.add("InfoItem");
        ret.addAll(super.getNetworkedFields());
        return ret;
    }

    public void scanforPatternStorage() {
        for (Direction direction : directions) {
            TileEntity target = direction.applyToTileEntity(this);
            if (!(target instanceof IPatternStorage)) continue;
            this.Storage = (IPatternStorage)target;
            break;
        }
    }

    @Override
    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return FluidRegistry.getFluid((String)"uumater").getID() == fluid.getID();
    }

    @Override
    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public String func_70303_b() {
        return "Replicator";
    }

    public float getChargeLevel() {
        float ret;
        if (IC2.platform.isSimulating()) {
            ret = (float)this.energy / (float)(this.maxEnergy - this.maxInput + 1);
            if (ret > 1.0f) {
                ret = 1.0f;
            }
        } else {
            ret = this.serverChargeLevel;
        }
        return ret;
    }

    public void setChargeLevel(float chargeLevel) {
        assert (!IC2.platform.isSimulating());
        this.serverChargeLevel = chargeLevel;
    }
}

