/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.TileEntityLiquidTankElectricMachine;
import ic2.core.block.invslot.InvSlotCharge;
import ic2.core.block.invslot.InvSlotEmptyLiquidContainer;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.machine.ContainerPump;
import ic2.core.block.machine.gui.GuiPump;
import ic2.core.block.machine.tileentity.TileEntityMiner;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityPump
extends TileEntityLiquidTankElectricMachine
implements IHasGui {
    private int Fluidid;
    private AudioSource audioSource;
    private int lastX;
    private int lastY;
    private int lastZ;
    private TileEntityMiner miner = null;
    public final InvSlotCharge chargeSlot = new InvSlotCharge(this, 0, 1);
    public final InvSlotEmptyLiquidContainer containerslot = new InvSlotEmptyLiquidContainer(this, "containerslot", 1, 1);
    public final InvSlotOutput output = new InvSlotOutput(this, "output", 2, 1);
    public short progress = 0;
    public int operationLength = 20;
    public float serverChargeLevel;
    public float serverProgress;

    public TileEntityPump() {
        super(4000, 1, 1, 8);
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
        this.miner = null;
        super.onUnloaded();
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (this.canoperate() && this.energy >= 200.0) {
            if (this.progress < this.operationLength) {
                this.progress = (short)(this.progress + 1);
            } else {
                this.progress = 0;
                this.energy -= 200.0;
                this.operate(false);
            }
        }
        this.containerslot.fillLiquidContainerfromTank((IFluidTank)this.fluidtank, this.output);
    }

    @Override
    public String func_70303_b() {
        return "Pump";
    }

    public boolean canoperate() {
        return this.operate(true);
    }

    public boolean operate(boolean sim) {
        if (this.miner == null || this.miner.func_70320_p()) {
            this.miner = null;
            for (Direction dir : Direction.values()) {
                TileEntity te;
                if (dir == Direction.YP || !((te = dir.applyToTileEntity(this)) instanceof TileEntityMiner)) continue;
                this.miner = (TileEntityMiner)te;
                break;
            }
        }
        FluidStack liquid = null;
        if (this.miner != null) {
            if (this.miner.canProvideLiquid) {
                liquid = this.pump(this.miner.liquidX, this.miner.liquidY, this.miner.liquidZ, sim);
            }
        } else {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                liquid = this.pump(this.field_70329_l + dir.offsetX, this.field_70330_m + dir.offsetY, this.field_70327_n + dir.offsetZ, sim);
                if (liquid != null) break;
            }
        }
        if (liquid != null && this.getFluidTank().fill(liquid, false) > 0) {
            if (!sim) {
                this.getFluidTank().fill(liquid, true);
                this.clearLastBlock();
            }
            return true;
        }
        return false;
    }

    public void clearLastBlock() {
        this.field_70331_k.func_94571_i(this.lastX, this.lastY, this.lastZ);
    }

    public FluidStack pump(int x, int y, int z, boolean sim) {
        this.lastX = x;
        this.lastY = y;
        this.lastZ = z;
        int blockId = this.field_70331_k.func_72798_a(x, y, z);
        if (blockId == 0) {
            return null;
        }
        FluidStack ret = null;
        if (Block.field_71973_m[blockId] instanceof IFluidBlock) {
            IFluidBlock liquid = (IFluidBlock)Block.field_71973_m[blockId];
            if (liquid.canDrain(this.field_70331_k, x, y, z)) {
                ret = !sim ? liquid.drain(this.field_70331_k, x, y, z, true) : new FluidStack(liquid.getFluid(), 1000);
            }
        } else if (blockId == Block.field_71943_B.field_71990_ca || blockId == Block.field_71942_A.field_71990_ca) {
            if (this.field_70331_k.func_72805_g(x, y, z) != 0) {
                return null;
            }
            ret = new FluidStack(FluidRegistry.WATER, 1000);
        } else if (blockId == Block.field_71938_D.field_71990_ca || blockId == Block.field_71944_C.field_71990_ca) {
            if (this.field_70331_k.func_72805_g(x, y, z) != 0) {
                return null;
            }
            ret = new FluidStack(FluidRegistry.LAVA, 1000);
        }
        return ret;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.progress = nbttagcompound.func_74765_d("progress");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74777_a("progress", this.progress);
    }

    public float getChargeLevel() {
        float ret;
        if (IC2.platform.isSimulating()) {
            ret = (float)this.energy / (float)(this.maxEnergy - this.maxInput + 1);
            if (ret > 1.0f) {
                ret = 1.0f;
            }
        } else {
            ret = this.serverChargeLevel;
        }
        return ret;
    }

    public float getProgress() {
        float ret;
        if (IC2.platform.isSimulating()) {
            ret = (float)this.progress / (float)this.operationLength;
            if (ret > 1.0f) {
                ret = 1.0f;
            }
        } else {
            ret = this.serverProgress;
        }
        return ret;
    }

    public void setChargeLevel(float chargeLevel) {
        assert (!IC2.platform.isSimulating());
        this.serverChargeLevel = chargeLevel;
    }

    public void setProgress(float progress) {
        assert (!IC2.platform.isSimulating());
        this.serverProgress = progress;
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerPump(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiPump(new ContainerPump(entityPlayer, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.getActive()) {
            if (this.audioSource == null) {
                this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Machines/PumpOp.ogg", true, false, IC2.audioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }

    @Override
    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    @Override
    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public int getFluidid() {
        return this.Fluidid;
    }

    public void setFluidid(int fluidid) {
        this.Fluidid = fluidid;
    }
}

