/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.Ic2Player;
import ic2.core.InvSlotConsumableBlock;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableId;
import ic2.core.block.machine.ContainerMiner;
import ic2.core.block.machine.gui.GuiMiner;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.block.machine.tileentity.TileEntityPump;
import ic2.core.item.tool.ItemScanner;
import ic2.core.util.Liquid;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.IFluidBlock;

public class TileEntityMiner
extends TileEntityElectricMachine
implements IHasGui {
    private Mode lastMode = Mode.None;
    public int progress = 0;
    private int scannedLevel = -1;
    private int scanRange = 0;
    private int lastX;
    private int lastZ;
    public boolean pumpMode = false;
    public boolean canProvideLiquid = false;
    public int liquidX;
    public int liquidY;
    public int liquidZ;
    private AudioSource audioSource;
    public final InvSlotConsumableId drillSlot;
    public final InvSlotConsumableBlock pipeSlot;
    public final InvSlotConsumableId scannerSlot;

    public TileEntityMiner() {
        super(1000, IC2.enableMinerLapotron ? 3 : 1, 0);
        this.drillSlot = new InvSlotConsumableId((TileEntityInventory)this, "drill", 3, InvSlot.Access.IO, 1, InvSlot.InvSide.TOP, Ic2Items.miningDrill.field_77993_c, Ic2Items.diamondDrill.field_77993_c);
        this.pipeSlot = new InvSlotConsumableBlock(this, "pipe", 2, InvSlot.Access.IO, 1, InvSlot.InvSide.SIDE);
        this.scannerSlot = new InvSlotConsumableId((TileEntityInventory)this, "scanner", 1, InvSlot.Access.IO, 1, InvSlot.InvSide.BOTTOM, Ic2Items.odScanner.field_77993_c, Ic2Items.ovScanner.field_77993_c);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.scannedLevel = -1;
        this.lastX = this.field_70329_l;
        this.lastZ = this.field_70327_n;
        this.canProvideLiquid = false;
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTagCompound) {
        super.func_70307_a(nbtTagCompound);
        this.lastMode = Mode.values()[nbtTagCompound.func_74762_e("lastMode")];
        this.progress = nbtTagCompound.func_74762_e("progress");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTagCompound) {
        super.func_70310_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("lastMode", this.lastMode.ordinal());
        nbtTagCompound.func_74768_a("progress", this.progress);
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        this.chargeTools();
        if (this.work()) {
            this.func_70296_d();
            this.setActive(true);
        } else {
            this.setActive(false);
        }
    }

    private void chargeTools() {
        if (!this.scannerSlot.isEmpty()) {
            this.energy -= (double)ElectricItem.manager.charge(this.scannerSlot.get(), (int)this.energy, 2, false, false);
        }
        if (!this.drillSlot.isEmpty()) {
            this.energy -= (double)ElectricItem.manager.charge(this.drillSlot.get(), (int)this.energy, 1, false, false);
        }
    }

    private boolean work() {
        int operationHeight = this.getOperationHeight();
        if (this.drillSlot.isEmpty()) {
            return this.withDrawPipe(operationHeight);
        }
        if (operationHeight >= 0) {
            int blockId = this.field_70331_k.func_72798_a(this.field_70329_l, operationHeight, this.field_70327_n);
            if (blockId != Ic2Items.miningPipeTip.field_77993_c) {
                if (operationHeight > 0) {
                    return this.digDown(operationHeight, false);
                }
                return false;
            }
            MineResult result = this.mineLevel(operationHeight);
            if (result == MineResult.Done) {
                return this.digDown(operationHeight - 1, true);
            }
            return result == MineResult.Working;
        }
        return false;
    }

    private int getOperationHeight() {
        for (int y = this.field_70330_m - 1; y >= 0; --y) {
            int blockId = this.field_70331_k.func_72798_a(this.field_70329_l, y, this.field_70327_n);
            if (blockId == Ic2Items.miningPipe.field_77993_c) continue;
            return y;
        }
        return -1;
    }

    private boolean withDrawPipe(int y) {
        if (this.lastMode != Mode.Withdraw) {
            this.lastMode = Mode.Withdraw;
            this.progress = 0;
        }
        if (y < 0 || this.field_70331_k.func_72798_a(this.field_70329_l, y, this.field_70327_n) != Ic2Items.miningPipeTip.field_77993_c) {
            ++y;
        }
        if (y != this.field_70330_m && this.energy >= 3.0) {
            if (this.progress < 20) {
                this.energy -= 3.0;
                ++this.progress;
            } else {
                this.progress = 0;
                this.removePipe(y);
            }
            return true;
        }
        return false;
    }

    private void removePipe(int y) {
        ItemStack filler;
        Item fillerItem;
        this.field_70331_k.func_94571_i(this.field_70329_l, y, this.field_70327_n);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(Ic2Items.miningPipe.func_77946_l());
        StackUtil.distributeDrop(this, drops);
        if (!this.pipeSlot.isEmpty() && this.pipeSlot.get().field_77993_c != Ic2Items.miningPipe.field_77993_c && (fillerItem = (filler = this.pipeSlot.consume(1)).func_77973_b()) instanceof ItemBlock) {
            ((ItemBlock)fillerItem).func_77648_a(filler, (EntityPlayer)new Ic2Player(this.field_70331_k), this.field_70331_k, this.field_70329_l, y + 1, this.field_70327_n, 0, 0.0f, 0.0f, 0.0f);
        }
    }

    private boolean digDown(int y, boolean removeTipAbove) {
        if (this.pipeSlot.isEmpty() || this.pipeSlot.get().field_77993_c != Ic2Items.miningPipe.field_77993_c) {
            return false;
        }
        if (y < 0) {
            if (removeTipAbove) {
                this.field_70331_k.func_94575_c(this.field_70329_l, y + 1, this.field_70327_n, Ic2Items.miningPipe.field_77993_c);
            }
            return false;
        }
        MineResult result = this.mineBlock(this.field_70329_l, y, this.field_70327_n);
        if (result == MineResult.Failed_Temp || result == MineResult.Failed_Perm) {
            if (removeTipAbove) {
                this.field_70331_k.func_94575_c(this.field_70329_l, y + 1, this.field_70327_n, Ic2Items.miningPipe.field_77993_c);
            }
            return false;
        }
        if (result == MineResult.Done) {
            if (removeTipAbove) {
                this.field_70331_k.func_94575_c(this.field_70329_l, y + 1, this.field_70327_n, Ic2Items.miningPipe.field_77993_c);
            }
            this.pipeSlot.consume(1);
            this.field_70331_k.func_94575_c(this.field_70329_l, y, this.field_70327_n, Ic2Items.miningPipeTip.field_77993_c);
        }
        return true;
    }

    private MineResult mineLevel(int y) {
        if (this.scannerSlot.isEmpty()) {
            return MineResult.Done;
        }
        if (this.scannedLevel != y) {
            this.scanRange = ((ItemScanner)this.scannerSlot.get().func_77973_b()).startLayerScan(this.scannerSlot.get());
        }
        if (this.scanRange > 0) {
            this.scannedLevel = y;
            for (int x = this.field_70329_l - this.scanRange; x <= this.field_70329_l + this.scanRange; ++x) {
                for (int z = this.field_70327_n - this.scanRange; z <= this.field_70327_n + this.scanRange; ++z) {
                    Liquid.LiquidData liquid;
                    int blockId = this.field_70331_k.func_72798_a(x, y, z);
                    int meta = this.field_70331_k.func_72805_g(x, y, z);
                    boolean isValidTarget = false;
                    if (ItemScanner.isValuable(blockId, meta) && this.canMine(x, y, z)) {
                        isValidTarget = true;
                    } else if (this.pumpMode && (liquid = Liquid.getLiquid(this.field_70331_k, x, y, z)) != null && this.canPump(x, y, z)) {
                        isValidTarget = true;
                    }
                    if (!isValidTarget) continue;
                    MineResult result = this.mineTowards(x, y, z);
                    if (result == MineResult.Done) {
                        return MineResult.Working;
                    }
                    if (result == MineResult.Failed_Perm) continue;
                    return result;
                }
            }
            return MineResult.Done;
        }
        return MineResult.Failed_Temp;
    }

    private MineResult mineTowards(int x, int y, int z) {
        int dx = Math.abs(x - this.field_70329_l);
        int sx = this.field_70329_l < x ? 1 : -1;
        int dz = -Math.abs(z - this.field_70327_n);
        int sz = this.field_70327_n < z ? 1 : -1;
        int err = dx + dz;
        int cx = this.field_70329_l;
        int cz = this.field_70327_n;
        while (cx != x || cz != z) {
            boolean isCurrentPos = cx == this.lastX && cz == this.lastZ;
            int e2 = 2 * err;
            if (e2 > dz) {
                err += dz;
                cx += sx;
            } else if (e2 < dx) {
                err += dx;
                cz += sz;
            }
            boolean isBlocking = false;
            if (isCurrentPos) {
                isBlocking = true;
            } else {
                Liquid.LiquidData liquid;
                int blockId = this.field_70331_k.func_72798_a(cx, y, cz);
                if (blockId != 0 && !Block.field_71973_m[blockId].isAirBlock(this.field_70331_k, cx, y, cz) && ((liquid = Liquid.getLiquid(this.field_70331_k, cx, y, cz)) == null || liquid.isSource || this.pumpMode && this.canPump(x, y, z))) {
                    isBlocking = true;
                }
            }
            if (!isBlocking) continue;
            MineResult result = this.mineBlock(cx, y, cz);
            if (result == MineResult.Done) {
                this.lastX = cx;
                this.lastZ = cz;
            }
            return result;
        }
        this.lastX = this.field_70329_l;
        this.lastZ = this.field_70327_n;
        return MineResult.Done;
    }

    private MineResult mineBlock(int x, int y, int z) {
        int duration;
        int energyPerTick;
        Mode mode;
        int blockId = this.field_70331_k.func_72798_a(x, y, z);
        boolean isAirBlock = true;
        if (blockId != 0 && !Block.field_71973_m[blockId].isAirBlock(this.field_70331_k, x, y, z)) {
            isAirBlock = false;
            Liquid.LiquidData liquidData = Liquid.getLiquid(this.field_70331_k, x, y, z);
            if (liquidData != null) {
                if (liquidData.isSource || this.pumpMode && this.canPump(x, y, z)) {
                    this.liquidX = x;
                    this.liquidY = y;
                    this.liquidZ = z;
                    this.canProvideLiquid = true;
                    return this.pumpMode ? MineResult.Failed_Temp : MineResult.Failed_Perm;
                }
            } else if (!this.canMine(x, y, z)) {
                return MineResult.Failed_Perm;
            }
        }
        this.canProvideLiquid = false;
        if (isAirBlock) {
            mode = Mode.MineAir;
            energyPerTick = 3;
            duration = 20;
        } else if (this.drillSlot.get().field_77993_c == Ic2Items.miningDrill.field_77993_c) {
            mode = Mode.MineDrill;
            energyPerTick = 6;
            duration = 200;
        } else if (this.drillSlot.get().field_77993_c == Ic2Items.diamondDrill.field_77993_c) {
            mode = Mode.MineDDrill;
            energyPerTick = 20;
            duration = 50;
        } else {
            throw new IllegalStateException("invalid drill: " + this.drillSlot.get());
        }
        if (this.lastMode != mode) {
            this.lastMode = mode;
            this.progress = 0;
        }
        if (this.progress < duration) {
            if (this.energy >= (double)energyPerTick) {
                this.energy -= (double)energyPerTick;
                ++this.progress;
                return MineResult.Working;
            }
        } else if (isAirBlock || this.harvestBlock(x, y, z, blockId)) {
            this.progress = 0;
            return MineResult.Done;
        }
        return MineResult.Failed_Temp;
    }

    private boolean harvestBlock(int x, int y, int z, int blockId) {
        int energyCost = 2 * (this.field_70330_m - y);
        if (this.energy >= (double)energyCost) {
            if (this.drillSlot.get().field_77993_c == Ic2Items.miningDrill.field_77993_c) {
                if (!ElectricItem.manager.use(this.drillSlot.get(), 50, null)) {
                    return false;
                }
            } else if (this.drillSlot.get().field_77993_c == Ic2Items.diamondDrill.field_77993_c) {
                if (!ElectricItem.manager.use(this.drillSlot.get(), 80, null)) {
                    return false;
                }
            } else {
                throw new IllegalStateException("invalid drill: " + this.drillSlot.get());
            }
            this.energy -= (double)energyCost;
            StackUtil.distributeDrop(this, Block.field_71973_m[blockId].getBlockDropped(this.field_70331_k, x, y, z, this.field_70331_k.func_72805_g(x, y, z), 0));
            this.field_70331_k.func_94571_i(x, y, z);
            return true;
        }
        return false;
    }

    private boolean canPump(int x, int y, int z) {
        return false;
    }

    public boolean canMine(int x, int y, int z) {
        int id = this.field_70331_k.func_72798_a(x, y, z);
        int meta = this.field_70331_k.func_72805_g(x, y, z);
        if (id == 0) {
            return true;
        }
        if (id == Ic2Items.miningPipe.field_77993_c || id == Ic2Items.miningPipeTip.field_77993_c || id == Block.field_72077_au.field_71990_ca) {
            return false;
        }
        if (Block.field_71973_m[id] instanceof IFluidBlock && this.isPumpConnected(x, y, z)) {
            return true;
        }
        if ((id == Block.field_71942_A.field_71990_ca || id == Block.field_71943_B.field_71990_ca || id == Block.field_71944_C.field_71990_ca || id == Block.field_71938_D.field_71990_ca) && this.isPumpConnected(x, y, z)) {
            return true;
        }
        Block block = Block.field_71973_m[id];
        if (block.func_71934_m(this.field_70331_k, x, y, z) < 0.0f) {
            return false;
        }
        if (block.func_71913_a(meta, false) && block.field_72018_cp.func_76229_l()) {
            return true;
        }
        if (id == Block.field_71955_W.field_71990_ca) {
            return true;
        }
        if (!this.drillSlot.isEmpty()) {
            try {
                HashMap toolClasses = (HashMap)ReflectionHelper.getPrivateValue(ForgeHooks.class, null, (String[])new String[]{"toolClasses"});
                List tc = (List)toolClasses.get(this.drillSlot.get().field_77993_c);
                if (tc == null) {
                    return this.drillSlot.get().func_77987_b(block);
                }
                Object[] ta = tc.toArray();
                String cls = (String)ta[0];
                int hvl = (Integer)ta[1];
                HashMap toolHarvestLevels = (HashMap)ReflectionHelper.getPrivateValue(ForgeHooks.class, null, (String[])new String[]{"toolHarvestLevels"});
                Integer bhl = (Integer)toolHarvestLevels.get(Arrays.asList(block.field_71990_ca, meta, cls));
                if (bhl == null) {
                    return this.drillSlot.get().func_77987_b(block);
                }
                if (bhl > hvl) {
                    return false;
                }
                return this.drillSlot.get().func_77987_b(block);
            }
            catch (Throwable e) {
                return false;
            }
        }
        return false;
    }

    public boolean isPumpConnected(int x, int y, int z) {
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n) instanceof TileEntityPump && ((TileEntityPump)this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n)).pump(x, y, z, true) != null) {
            return true;
        }
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n) instanceof TileEntityPump && ((TileEntityPump)this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n)).pump(x, y, z, true) != null) {
            return true;
        }
        if (this.field_70331_k.func_72796_p(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n) instanceof TileEntityPump && ((TileEntityPump)this.field_70331_k.func_72796_p(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n)).pump(x, y, z, true) != null) {
            return true;
        }
        if (this.field_70331_k.func_72796_p(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n) instanceof TileEntityPump && ((TileEntityPump)this.field_70331_k.func_72796_p(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n)).pump(x, y, z, true) != null) {
            return true;
        }
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1) instanceof TileEntityPump && ((TileEntityPump)this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1)).pump(x, y, z, true) != null) {
            return true;
        }
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1) instanceof TileEntityPump && ((TileEntityPump)this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1)).pump(x, y, z, true) != null;
    }

    public boolean isAnyPumpConnected() {
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n) instanceof TileEntityPump) {
            return true;
        }
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n) instanceof TileEntityPump) {
            return true;
        }
        if (this.field_70331_k.func_72796_p(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n) instanceof TileEntityPump) {
            return true;
        }
        if (this.field_70331_k.func_72796_p(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n) instanceof TileEntityPump) {
            return true;
        }
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1) instanceof TileEntityPump) {
            return true;
        }
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1) instanceof TileEntityPump;
    }

    @Override
    public String func_70303_b() {
        return "Miner";
    }

    public int gaugeEnergyScaled(int i) {
        if (this.energy <= 0.0) {
            return 0;
        }
        int r = (int)(this.energy * (double)i / 1000.0);
        if (r > i) {
            r = i;
        }
        return r;
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerMiner(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiMiner(new ContainerMiner(entityPlayer, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.getActive()) {
            if (this.audioSource == null) {
                this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Machines/MinerOp.ogg", true, false, IC2.audioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }

    static enum MineResult {
        Working,
        Done,
        Failed_Temp,
        Failed_Perm;

    }

    static enum Mode {
        None,
        Withdraw,
        MineAir,
        MineDrill,
        MineDDrill;

    }
}

