/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.block.TileEntityCrop;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotConsumable;
import ic2.core.block.invslot.InvSlotConsumableId;
import ic2.core.block.machine.ContainerCropmatron;
import ic2.core.block.machine.gui.GuiCropmatron;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileEntityCropmatron
extends TileEntityInventory
implements IEnergySink,
IHasGui {
    public double energy = 0.0;
    public int ticker = 0;
    public int maxEnergy = 1000;
    public int scanX = -4;
    public int scanY = -1;
    public int scanZ = -4;
    public boolean addedToEnergyNet = false;
    public static int maxInput = 32;
    public final InvSlotConsumable fertilizerSlot;
    public final InvSlotConsumable hydrationSlot;
    public final InvSlotConsumable weedExSlot;

    public TileEntityCropmatron() {
        this.fertilizerSlot = new InvSlotConsumableId((TileEntityInventory)this, "fertilizer", 0, 3, Ic2Items.fertilizer.field_77993_c);
        this.hydrationSlot = new InvSlotConsumableId((TileEntityInventory)this, "hydration", 3, 3, Ic2Items.hydratingCell.field_77993_c);
        this.weedExSlot = new InvSlotConsumableId((TileEntityInventory)this, "weedEx", 6, 3, Ic2Items.weedEx.field_77993_c);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        try {
            this.energy = nbttagcompound.func_74769_h("energy");
        }
        catch (Exception e) {
            this.energy = nbttagcompound.func_74765_d("energy");
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy", (double)((short)this.energy));
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void func_70316_g() {
        super.func_70316_g();
        this.fertilizerSlot.organize();
        this.hydrationSlot.organize();
        this.weedExSlot.organize();
        if (this.energy >= 31.0) {
            this.scan();
        }
    }

    public void scan() {
        ++this.scanX;
        if (this.scanX > 4) {
            this.scanX = -4;
            ++this.scanZ;
            if (this.scanZ > 4) {
                this.scanZ = -4;
                ++this.scanY;
                if (this.scanY > 1) {
                    this.scanY = -1;
                }
            }
        }
        this.energy -= 1.0;
        TileEntity te = this.field_70331_k.func_72796_p(this.field_70329_l + this.scanX, this.field_70330_m + this.scanY, this.field_70327_n + this.scanZ);
        if (te instanceof TileEntityCrop) {
            TileEntityCrop crop = (TileEntityCrop)te;
            if (!this.fertilizerSlot.isEmpty() && crop.applyFertilizer(false)) {
                this.energy -= 10.0;
                this.fertilizerSlot.consume(1);
            }
            if (!this.hydrationSlot.isEmpty() && crop.applyHydration(false, this.hydrationSlot)) {
                this.energy -= 10.0;
            }
            if (!this.weedExSlot.isEmpty() && crop.applyWeedEx(false)) {
                this.energy -= 10.0;
                this.weedExSlot.damage(1);
            }
        }
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    @Override
    public double demandedEnergyUnits() {
        return (double)this.maxEnergy - this.energy;
    }

    public int gaugeEnergyScaled(int i) {
        if (this.energy <= 0.0) {
            return 0;
        }
        int r = (int)(this.energy * (double)i / (double)this.maxEnergy);
        if (r > i) {
            r = i;
        }
        return r;
    }

    @Override
    public double injectEnergyUnits(ForgeDirection directionFrom, double amount) {
        if (amount > (double)maxInput) {
            IC2.explodeMachineAt(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            return 0.0;
        }
        if (this.energy >= (double)this.maxEnergy) {
            return amount;
        }
        this.energy += amount;
        return 0.0;
    }

    @Override
    public int getMaxSafeInput() {
        return maxInput;
    }

    @Override
    public String func_70303_b() {
        return "Crop-Matron";
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerCropmatron(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiCropmatron(new ContainerCropmatron(entityPlayer, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }
}

