/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.audio.AudioSource;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumable;
import ic2.core.block.invslot.InvSlotConsumableId;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.machine.ContainerCanner;
import ic2.core.block.machine.gui.GuiCanner;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.util.StackUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;

public class TileEntityCanner
extends TileEntityElectricMachine
implements IHasGui {
    public static final Map<ChunkCoordIntPair, Integer> specialFood = new HashMap<ChunkCoordIntPair, Integer>();
    public short progress = 0;
    public int energyconsume = 1;
    public int operationLength = 600;
    private int fuelQuality = 0;
    public AudioSource audioSource;
    public final InvSlot resInputSlot = new InvSlot(this, "input", 0, InvSlot.Access.I, 1);
    public final InvSlotConsumable inputSlot;
    public final InvSlotOutput outputSlot;

    public TileEntityCanner() {
        super(600, 1, 1);
        this.inputSlot = new InvSlotConsumableId((TileEntityInventory)this, "canInput", 3, 1, Ic2Items.tinCan.field_77993_c, Ic2Items.fuelCan.field_77993_c, Ic2Items.jetpack.field_77993_c, Ic2Items.cfPack.field_77993_c, Ic2Items.fuelrod.field_77993_c);
        this.outputSlot = new InvSlotOutput(this, "output", 2, 1);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        try {
            this.fuelQuality = nbttagcompound.func_74762_e("fuelQuality");
        }
        catch (Throwable e) {
            this.fuelQuality = nbttagcompound.func_74765_d("fuelQuality");
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("fuelQuality", this.fuelQuality);
    }

    public int gaugeProgressScaled(int i) {
        int food;
        int l = this.operationLength;
        if (this.getMode() == 1 && this.resInputSlot.get() != null && (food = this.getFoodValue(this.resInputSlot.get())) > 0) {
            l = 50 * food;
        }
        if (this.getMode() == 3) {
            l = 50;
        }
        return this.progress * i / l;
    }

    public int gaugeFuelScaled(int i) {
        if (this.energy <= 0.0) {
            return 0;
        }
        int r = (int)(this.energy * (double)i / (double)(this.operationLength * this.energyconsume));
        if (r > i) {
            return i;
        }
        return r;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        boolean needsInvUpdate = false;
        boolean canOperate = this.canOperate();
        boolean newActive = this.getActive();
        if (canOperate && (this.getMode() == 1 && this.progress >= this.getFoodValue(this.resInputSlot.get()) * 50 || this.getMode() == 2 && this.progress > 0 && this.progress % 100 == 0 || this.getMode() == 3 && this.progress >= 50 || this.getMode() == 4 && this.progress >= 600)) {
            if (this.getMode() == 1 || this.getMode() == 3 || this.progress >= 600) {
                this.operate(false);
                this.fuelQuality = 0;
                this.progress = 0;
                newActive = false;
            } else {
                this.operate(true);
            }
            needsInvUpdate = true;
        }
        if (!newActive || this.progress == 0) {
            if (canOperate) {
                if (this.energy >= (double)this.energyconsume) {
                    newActive = true;
                }
            } else if (this.getMode() != 2) {
                this.fuelQuality = 0;
                this.progress = 0;
            }
        } else if (!canOperate || this.energy < (double)this.energyconsume) {
            if (!canOperate && this.getMode() != 2) {
                this.fuelQuality = 0;
                this.progress = 0;
            }
            newActive = false;
        }
        if (newActive) {
            this.progress = (short)(this.progress + 1);
            this.energy -= (double)this.energyconsume;
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
        if (newActive != this.getActive()) {
            this.setActive(newActive);
        }
    }

    public void operate(boolean incremental) {
        switch (this.getMode()) {
            case 1: {
                int food = this.getFoodValue(this.resInputSlot.get());
                int meta = this.getFoodMeta(this.resInputSlot.get());
                --this.resInputSlot.get().field_77994_a;
                if (this.resInputSlot.get().func_77973_b() == Item.field_77671_F && this.resInputSlot.get().field_77994_a <= 0) {
                    this.resInputSlot.put(new ItemStack(Item.field_77670_E));
                }
                if (this.resInputSlot.get().field_77994_a <= 0) {
                    this.resInputSlot.clear();
                }
                this.inputSlot.consume(food);
                this.outputSlot.add(new ItemStack(Ic2Items.filledTinCan.func_77973_b(), food, meta));
                break;
            }
            case 2: {
                int fuel = this.getFuelValue(this.resInputSlot.get().field_77993_c);
                --this.resInputSlot.get().field_77994_a;
                if (this.resInputSlot.get().field_77994_a <= 0) {
                    this.resInputSlot.clear();
                }
                this.fuelQuality += fuel;
                if (incremental) break;
                if (this.inputSlot.get().field_77993_c == Ic2Items.fuelCan.field_77993_c) {
                    this.inputSlot.consume(1);
                    ItemStack result = Ic2Items.filledFuelCan.func_77946_l();
                    NBTTagCompound data = StackUtil.getOrCreateNbtData(result);
                    data.func_74768_a("value", this.fuelQuality);
                    this.outputSlot.add(result);
                    break;
                }
                int damage = this.inputSlot.get().func_77960_j();
                if ((damage -= this.fuelQuality) < 1) {
                    damage = 1;
                }
                this.inputSlot.clear();
                this.outputSlot.add(new ItemStack(Ic2Items.jetpack.field_77993_c, 1, damage));
                break;
            }
            case 3: {
                --this.resInputSlot.get().field_77994_a;
                if (this.resInputSlot.get().field_77994_a <= 0) {
                    this.resInputSlot.clear();
                }
                this.inputSlot.get().func_77964_b(this.inputSlot.get().func_77960_j() - 2);
                if (!this.resInputSlot.isEmpty() && this.inputSlot.get().func_77960_j() > 1) break;
                this.outputSlot.add(this.inputSlot.get());
                this.inputSlot.clear();
                break;
            }
            case 4: {
                if (this.resInputSlot.get().field_77993_c == Ic2Items.UranFuel.field_77993_c) {
                    this.outputSlot.add(Ic2Items.reactorUraniumSimple.func_77946_l());
                }
                if (this.resInputSlot.get().field_77993_c == Ic2Items.MOXFuel.field_77993_c) {
                    this.outputSlot.add(Ic2Items.reactorMOXSimple.func_77946_l());
                }
                --this.resInputSlot.get().field_77994_a;
                if (this.resInputSlot.get().field_77994_a <= 0) {
                    this.resInputSlot.put(null);
                }
                --this.inputSlot.get().field_77994_a;
                if (this.inputSlot.get().field_77994_a > 0) break;
                this.inputSlot.put(null);
            }
        }
    }

    @Override
    public void onUnloaded() {
        if (this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    public boolean canOperate() {
        if (this.resInputSlot.isEmpty()) {
            return false;
        }
        switch (this.getMode()) {
            case 1: {
                int food = this.getFoodValue(this.resInputSlot.get());
                return food > 0 && food <= this.inputSlot.get().field_77994_a && this.outputSlot.canAdd(new ItemStack(Ic2Items.filledTinCan.field_77993_c, food, this.getFoodMeta(this.resInputSlot.get())));
            }
            case 2: {
                int fuel = this.getFuelValue(this.resInputSlot.get().field_77993_c);
                return fuel > 0 && this.outputSlot.canAdd(Ic2Items.jetpack);
            }
            case 3: {
                return this.inputSlot.get().func_77960_j() > 2 && this.getPelletValue(this.resInputSlot.get()) > 0 && this.outputSlot.canAdd(this.resInputSlot.get());
            }
            case 4: {
                if (this.resInputSlot.get() == null || this.inputSlot.get() == null || this.inputSlot.get().field_77993_c != Ic2Items.fuelrod.field_77993_c) break;
                return this.resInputSlot.get().field_77993_c == Ic2Items.UranFuel.field_77993_c && this.outputSlot.canAdd(Ic2Items.reactorUraniumSimple) || this.resInputSlot.get().field_77993_c == Ic2Items.MOXFuel.field_77993_c && this.outputSlot.canAdd(Ic2Items.reactorMOXSimple);
            }
        }
        return false;
    }

    public int getMode() {
        if (this.inputSlot.isEmpty()) {
            return 0;
        }
        if (this.inputSlot.get().field_77993_c == Ic2Items.tinCan.field_77993_c) {
            return 1;
        }
        if (this.inputSlot.get().field_77993_c == Ic2Items.fuelCan.field_77993_c || this.inputSlot.get().field_77993_c == Ic2Items.jetpack.field_77993_c) {
            return 2;
        }
        if (this.inputSlot.get().field_77993_c == Ic2Items.cfPack.field_77993_c) {
            return 3;
        }
        if (this.inputSlot.get().field_77993_c == Ic2Items.fuelrod.field_77993_c) {
            return 4;
        }
        return 0;
    }

    @Override
    public String func_70303_b() {
        return "Canning Machine";
    }

    private int getFoodValue(ItemStack item) {
        if (item.field_77993_c == Ic2Items.filledTinCan.field_77993_c) {
            return 0;
        }
        if (item.func_77973_b() instanceof ItemFood) {
            ItemFood food = (ItemFood)item.func_77973_b();
            return (int)Math.ceil((double)food.func_77847_f() / 2.0);
        }
        if (item.field_77993_c == Item.field_77746_aZ.field_77779_bT || item.field_77993_c == Block.field_72009_bg.field_71990_ca) {
            return 6;
        }
        return 0;
    }

    public int getFuelValue(int id) {
        if (id == Ic2Items.coalfuelCell.field_77993_c) {
            return 2548;
        }
        if (id == Ic2Items.biofuelCell.field_77993_c) {
            return 868;
        }
        if (id == Item.field_77767_aC.field_77779_bT && this.fuelQuality > 0) {
            return (int)((double)this.fuelQuality * 0.2);
        }
        if (id == Item.field_77751_aT.field_77779_bT && this.fuelQuality > 0) {
            return (int)((double)this.fuelQuality * 0.3);
        }
        if (id == Item.field_77677_M.field_77779_bT && this.fuelQuality > 0) {
            return (int)((double)this.fuelQuality * 0.4);
        }
        return 0;
    }

    public int getPelletValue(ItemStack item) {
        if (item == null) {
            return 0;
        }
        if (item.field_77993_c != Ic2Items.constructionFoamPellet.field_77993_c) {
            return 0;
        }
        return item.field_77994_a;
    }

    private int getFoodMeta(ItemStack item) {
        if (item == null) {
            return 0;
        }
        ChunkCoordIntPair ccip = new ChunkCoordIntPair(item.field_77993_c, item.func_77960_j());
        return specialFood.containsKey(ccip) ? specialFood.get(ccip) : 0;
    }

    public String getStartSoundFile() {
        return null;
    }

    public String getInterruptSoundFile() {
        return null;
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerCanner(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiCanner(new ContainerCanner(entityPlayer, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public float getWrenchDropRate() {
        return 0.85f;
    }

    static {
        specialFood.put(new ChunkCoordIntPair(Item.field_77737_bm.field_77779_bT, 0), 1);
        specialFood.put(new ChunkCoordIntPair(Item.field_77728_bu.field_77779_bT, 0), 2);
        specialFood.put(new ChunkCoordIntPair(Item.field_82800_bN.field_77779_bT, 0), 2);
        specialFood.put(new ChunkCoordIntPair(Item.field_77735_bk.field_77779_bT, 0), 3);
        specialFood.put(new ChunkCoordIntPair(Item.field_77778_at.field_77779_bT, 0), 4);
        specialFood.put(new ChunkCoordIntPair(Item.field_77778_at.field_77779_bT, 1), 5);
    }
}

