/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.generator.container.ContainerWindGenerator;
import ic2.core.block.generator.gui.GuiWindGenerator;
import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import ic2.core.util.StackUtil;
import java.util.Random;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class TileEntityWindGenerator
extends TileEntityBaseGenerator {
    public static Random randomizer = new Random();
    public double subproduction = 0.0;
    public double substorage = 0.0;
    public int ticker = randomizer.nextInt(this.tickRate());
    public int obscuratedBlockCount;

    public TileEntityWindGenerator() {
        super(4, 5);
    }

    @Override
    public int gaugeFuelScaled(int i) {
        double prod = this.subproduction / 3.0;
        int re = (int)(prod * (double)i);
        if (re < 0) {
            return 0;
        }
        if (re > i) {
            return i;
        }
        return re;
    }

    public int getOverheatScaled(int i) {
        double prod = (this.subproduction - 5.0) / 5.0;
        if (this.subproduction <= 5.0) {
            return 0;
        }
        if (this.subproduction >= 10.0) {
            return i;
        }
        return (int)(prod * (double)i);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.updateObscuratedBlockCount();
    }

    @Override
    public boolean gainEnergy() {
        ++this.ticker;
        if (this.ticker % this.tickRate() == 0) {
            if (this.ticker % (8 * this.tickRate()) == 0) {
                this.updateObscuratedBlockCount();
            }
            this.subproduction = (double)(IC2.windStrength * (this.field_70330_m - 64 - this.obscuratedBlockCount)) / 750.0;
            if (this.subproduction <= 0.0) {
                return false;
            }
            if (this.field_70331_k.func_72911_I()) {
                this.subproduction *= 1.5;
            } else if (this.field_70331_k.func_72896_J()) {
                this.subproduction *= 1.2;
            }
            if (this.subproduction > 5.0 && (double)this.field_70331_k.field_73012_v.nextInt(5000) <= this.subproduction - 5.0) {
                this.subproduction = 0.0;
                this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, Ic2Items.generator.field_77993_c, Ic2Items.generator.func_77960_j(), 7);
                for (int i = this.field_70331_k.field_73012_v.nextInt(5); i > 0; --i) {
                    StackUtil.dropAsEntity(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, new ItemStack(Item.field_77703_o));
                }
                return false;
            }
            this.subproduction *= (double)IC2.energyGeneratorWind;
            this.subproduction /= 100.0;
        }
        this.substorage += this.subproduction;
        this.production = (short)this.substorage;
        if (this.storage + (double)this.production >= (double)this.maxStorage) {
            this.substorage = 0.0;
            return false;
        }
        this.storage += (double)this.production;
        this.substorage -= (double)this.production;
        return true;
    }

    @Override
    public boolean gainFuel() {
        return false;
    }

    public void updateObscuratedBlockCount() {
        this.obscuratedBlockCount = -1;
        for (int x = -4; x < 5; ++x) {
            for (int y = -2; y < 5; ++y) {
                for (int z = -4; z < 5; ++z) {
                    if (this.field_70331_k.func_72798_a(x + this.field_70329_l, y + this.field_70330_m, z + this.field_70327_n) == 0) continue;
                    ++this.obscuratedBlockCount;
                }
            }
        }
    }

    @Override
    public boolean needsFuel() {
        return true;
    }

    @Override
    public String func_70303_b() {
        return "Wind Mill";
    }

    public int tickRate() {
        return 128;
    }

    @Override
    public String getOperationSoundFile() {
        return "Generators/WindGenLoop.ogg";
    }

    @Override
    public boolean delayActiveUpdate() {
        return true;
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerWindGenerator(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiWindGenerator(new ContainerWindGenerator(entityPlayer, this));
    }
}

