/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.item.ElectricItem;
import ic2.api.recipe.ISemiFluidEuOutputManager;
import ic2.api.recipe.Recipes;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.SemiFluidEuOutputManager;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.TileEntityLiquidTankInventory;
import ic2.core.block.generator.container.ContainerSemifluidGenerator;
import ic2.core.block.generator.gui.GuiSemifluidGenerator;
import ic2.core.block.invslot.InvSlotCharge;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotOutput;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntitySemifluidGenerator
extends TileEntityLiquidTankInventory
implements IEnergySource,
IHasGui {
    public final InvSlotCharge chargeSlot = new InvSlotCharge(this, 0, 1);
    public final InvSlotConsumableLiquid fluidSlot = new InvSlotConsumableLiquid((TileEntityInventory)this, "fluidSlot", 1, 1, new Fluid[0]);
    public final InvSlotOutput output = new InvSlotOutput(this, "output", 2, 1);
    private int Fluidid;
    private short ticker = 0;
    public int burnamount = 0;
    public short maxStorage = (short)32000;
    private int FluidBlockid;
    public double storage = 0.0;
    public int production = 0;
    public boolean addedToEnergyNet = false;
    public AudioSource audioSource;

    public TileEntitySemifluidGenerator() {
        super(10);
    }

    public static void init() {
        Recipes.semifluidGenerator = new SemiFluidEuOutputManager();
    }

    public ISemiFluidEuOutputManager getManager() {
        return Recipes.semifluidGenerator;
    }

    public static void addRecipe(Fluid fluid, int amount, int eu) {
        Recipes.semifluidGenerator.addFluid(fluid, amount, eu);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.storage = nbttagcompound.func_74769_h("storage");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74780_a("storage", this.storage);
    }

    public void func_70316_g() {
        super.func_70316_g();
        boolean needsInvUpdate = false;
        if (this.needsFluid()) {
            needsInvUpdate = this.gainFuel();
        }
        boolean newActive = this.gainEnergy();
        if (this.storage > (double)this.maxStorage) {
            this.storage = this.maxStorage;
        }
        if (this.storage >= 1.0 && this.chargeSlot.getItem() != null) {
            int used = ElectricItem.manager.charge(this.chargeSlot.get(), (int)this.storage, 1, false, false);
            this.storage -= (double)used;
            if (used > 0) {
                needsInvUpdate = true;
            }
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
        if (this.getActive() != newActive) {
            this.setActive(newActive);
        }
    }

    public boolean gainEnergy() {
        if (this.isConverting()) {
            this.storage += (double)this.production;
            if (this.ticker >= 20) {
                this.getFluidTank().drain(this.burnamount, true);
                this.ticker = 0;
            } else {
                this.ticker = (short)(this.ticker + 1);
            }
            return true;
        }
        return false;
    }

    public boolean isConverting() {
        return this.getTankAmount() > 0 && this.storage + (double)this.production <= (double)this.maxStorage;
    }

    public void calcproduction() {
        int[] values;
        if (this.getFluidfromTank() != null && (values = Recipes.semifluidGenerator.getconsumption(this.getFluidfromTank())) != null) {
            this.production = values[1];
            return;
        }
        if (this.production != 0) {
            this.production = 0;
        }
    }

    public void calcburnamount() {
        int[] values;
        if (this.getFluidfromTank() != null && (values = Recipes.semifluidGenerator.getconsumption(this.getFluidfromTank())) != null) {
            this.burnamount = values[0];
            return;
        }
        if (this.burnamount != 0) {
            this.burnamount = 0;
        }
    }

    @Override
    public boolean canFill(ForgeDirection from, Fluid fluid) {
        for (Fluid acceptsfluid : Recipes.semifluidGenerator.getacceptsFluids()) {
            if (acceptsfluid.getID() != fluid.getID()) continue;
            if (this.getFluidTank().getFluid() == null) {
                return true;
            }
            if (this.getFluidTank().getFluid().getFluid().getID() != fluid.getID() || this.getTankAmount() >= this.getFluidTank().getCapacity()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean gainFuel() {
        if (this.fluidtank.getFluid() != null) {
            this.calcproduction();
            this.calcburnamount();
        }
        return this.fluidSlot.transfertoTank((IFluidTank)this.fluidtank, this.output, false);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    public String getOperationSoundFile() {
        return "Generators/GeothermalLoop.ogg";
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.getActive()) {
            if (this.audioSource == null && this.getOperationSoundFile() != null) {
                this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, this.getOperationSoundFile(), true, false, IC2.audioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }

    @Override
    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public int getFluidBlockid() {
        return this.FluidBlockid;
    }

    public void setFluidBlockid(int fluidBlockid) {
        this.FluidBlockid = fluidBlockid;
    }

    public int gaugeStorageScaled(int i) {
        return (int)(this.storage * (double)i / (double)this.maxStorage);
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerSemifluidGenerator(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiSemifluidGenerator(new ContainerSemifluidGenerator(entityPlayer, this));
    }

    public int getFluidid() {
        return this.Fluidid;
    }

    public void setFluidid(int fluidid) {
        this.Fluidid = fluidid;
    }

    @Override
    public String func_70303_b() {
        if (IC2.platform.isRendering()) {
            return "Semifluid Generator";
        }
        return "SemifluidGenerator";
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return true;
    }

    @Override
    public double getOfferedEnergy() {
        return Math.min((double)this.production, this.storage);
    }

    @Override
    public void drawEnergy(double amount) {
        this.storage -= amount;
    }
}

