/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tileentity;

import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IMetaDelegate;
import ic2.core.IC2;
import ic2.core.block.generator.tileentity.TileEntityNuclearReactor;
import ic2.core.block.generator.tileentity.TileEntityReactorChamberElectric;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileEntityNuclearReactorElectric
extends TileEntityNuclearReactor
implements IEnergySource,
IMetaDelegate {
    public boolean addedToEnergyNet = false;
    private List<TileEntity> subTiles;

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public float sendEnergy(float send) {
        return 0.0f;
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return true;
    }

    @Override
    public double getOfferedEnergy() {
        return this.getReactorEnergyOutput();
    }

    @Override
    public void drawEnergy(double amount) {
    }

    @Override
    public List<TileEntity> getSubTiles() {
        if (this.subTiles == null) {
            this.subTiles = new ArrayList<TileEntity>();
            this.subTiles.add(this);
            for (Direction dir : Direction.directions) {
                TileEntity te = dir.applyToTileEntity(this);
                if (!(te instanceof TileEntityReactorChamberElectric) || te.func_70320_p()) continue;
                this.subTiles.add(te);
            }
        }
        return this.subTiles;
    }

    public void refreshChambers() {
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        this.subTiles = null;
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        }
    }
}

