/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import ic2.core.ContainerBase;
import ic2.core.ExplosionIC2;
import ic2.core.IC2;
import ic2.core.IC2DamageSource;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.generator.container.ContainerNuclearReactor;
import ic2.core.block.generator.gui.GuiNuclearReactor;
import ic2.core.block.generator.tileentity.TileEntityReactorChamber;
import ic2.core.block.invslot.InvSlotReactor;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public abstract class TileEntityNuclearReactor
extends TileEntityInventory
implements IHasGui,
IReactor {
    public static Random randomizer = new Random();
    private static final Direction[] directions = Direction.values();
    public float output = 0.0f;
    public int updateTicker = randomizer.nextInt(this.getTickRate());
    public int heat = 0;
    public int maxHeat = 10000;
    public float hem = 1.0f;
    public AudioSource audioSourceMain;
    public AudioSource audioSourceGeiger;
    private float lastOutput = 0.0f;
    public final InvSlotReactor reactorSlot = new InvSlotReactor(this, "reactor", 0, 54);

    @Override
    public void onUnloaded() {
        if (IC2.platform.isRendering()) {
            IC2.audioManager.removeSources(this);
            this.audioSourceMain = null;
            this.audioSourceGeiger = null;
        }
        super.onUnloaded();
    }

    @Override
    public String func_70303_b() {
        return "Nuclear Reactor";
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        try {
            this.heat = nbttagcompound.func_74762_e("heat");
        }
        catch (Exception e) {
            this.heat = nbttagcompound.func_74765_d("heat");
        }
        this.output = nbttagcompound.func_74765_d("output");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("heat", this.heat);
        nbttagcompound.func_74777_a("output", (short)this.getReactorEnergyOutput());
    }

    @Override
    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void func_70316_g() {
        super.func_70316_g();
        this.sendEnergyToChambers(this.getReactorEnergyOutput());
        if (this.updateTicker++ % this.getTickRate() != 0) {
            return;
        }
        if (!this.field_70331_k.func_72873_a(this.field_70329_l, this.field_70330_m, this.field_70327_n, 2)) {
            this.output = 0.0f;
        } else {
            this.dropAllUnfittingStuff();
            this.output = 0.0f;
            this.maxHeat = 10000;
            this.hem = 1.0f;
            this.processChambers();
            if (this.calculateHeatEffects()) {
                return;
            }
            this.setActive(this.heat >= 1000 || this.output > 0.0f);
            this.func_70296_d();
        }
        IC2.network.updateTileEntityField(this, "output");
    }

    public void dropAllUnfittingStuff() {
        short size = this.getReactorSize();
        for (short x = 0; x < 9; ++x) {
            for (int y = 0; y < 6; ++y) {
                ItemStack stack = this.getMatrixCoord(x, y);
                if (stack == null) continue;
                if (stack.field_77994_a <= 0) {
                    this.setMatrixCoord(x, y, null);
                    continue;
                }
                if (x < size && TileEntityNuclearReactor.isUsefulItem(stack)) continue;
                this.eject(stack);
                this.setMatrixCoord(x, y, null);
            }
        }
    }

    public static boolean isUsefulItem(ItemStack item) {
        if (item == null) {
            return false;
        }
        if (item.func_77973_b() instanceof IReactorComponent) {
            return true;
        }
        int id = item.field_77993_c;
        return id == Ic2Items.reactorLithiumCell.field_77993_c || id == Ic2Items.TritiumCell.field_77993_c;
    }

    public void eject(ItemStack drop) {
        if (!IC2.platform.isSimulating() || drop == null) {
            return;
        }
        float f = 0.7f;
        double d = (double)(this.field_70331_k.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d1 = (double)(this.field_70331_k.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d2 = (double)(this.field_70331_k.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        EntityItem entityitem = new EntityItem(this.field_70331_k, (double)this.field_70329_l + d, (double)this.field_70330_m + d1, (double)this.field_70327_n + d2, drop);
        entityitem.field_70293_c = 10;
        this.field_70331_k.func_72838_d((Entity)entityitem);
    }

    public boolean calculateHeatEffects() {
        Material mat;
        int id;
        int[] coord;
        if (this.heat < 4000 || !IC2.platform.isSimulating() || IC2.explosionPowerReactorMax <= 0.0f) {
            return false;
        }
        float power = (float)this.heat / (float)this.maxHeat;
        if (power >= 1.0f) {
            this.explode();
            return true;
        }
        if (power >= 0.85f && this.field_70331_k.field_73012_v.nextFloat() <= 0.2f * this.hem && (coord = this.getRandCoord(2)) != null) {
            id = this.field_70331_k.func_72798_a(coord[0], coord[1], coord[2]);
            if (id == 0) {
                this.field_70331_k.func_72832_d(coord[0], coord[1], coord[2], Block.field_72067_ar.field_71990_ca, 0, 7);
            } else if (Block.field_71973_m[id] != null && Block.field_71973_m[id].func_71934_m(this.field_70331_k, coord[0], coord[1], coord[2]) <= -1.0f) {
                mat = Block.field_71973_m[id].field_72018_cp;
                if (mat == Material.field_76246_e || mat == Material.field_76243_f || mat == Material.field_76256_h || mat == Material.field_76248_c || mat == Material.field_76267_y) {
                    this.field_70331_k.func_72832_d(coord[0], coord[1], coord[2], Block.field_71944_C.field_71990_ca, 15, 7);
                } else {
                    this.field_70331_k.func_72832_d(coord[0], coord[1], coord[2], Block.field_72067_ar.field_71990_ca, 0, 7);
                }
            }
        }
        if (power >= 0.7f) {
            List list1 = this.field_70331_k.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(this.field_70329_l - 3), (double)(this.field_70330_m - 3), (double)(this.field_70327_n - 3), (double)(this.field_70329_l + 4), (double)(this.field_70330_m + 4), (double)(this.field_70327_n + 4)));
            for (int l = 0; l < list1.size(); ++l) {
                Entity ent = (Entity)list1.get(l);
                ent.func_70097_a((DamageSource)IC2DamageSource.radiation, (float)((int)((float)this.field_70331_k.field_73012_v.nextInt(4) * this.hem)));
            }
        }
        if (power >= 0.5f && this.field_70331_k.field_73012_v.nextFloat() <= this.hem && (coord = this.getRandCoord(2)) != null && (id = this.field_70331_k.func_72798_a(coord[0], coord[1], coord[2])) > 0 && Block.field_71973_m[id].field_72018_cp == Material.field_76244_g) {
            this.field_70331_k.func_72832_d(coord[0], coord[1], coord[2], 0, 0, 7);
        }
        if (power >= 0.4f && this.field_70331_k.field_73012_v.nextFloat() <= this.hem && (coord = this.getRandCoord(2)) != null && (id = this.field_70331_k.func_72798_a(coord[0], coord[1], coord[2])) > 0 && ((mat = Block.field_71973_m[id].field_72018_cp) == Material.field_76245_d || mat == Material.field_76257_i || mat == Material.field_76253_m)) {
            this.field_70331_k.func_72832_d(coord[0], coord[1], coord[2], Block.field_72067_ar.field_71990_ca, 0, 7);
        }
        return false;
    }

    public int[] getRandCoord(int radius) {
        if (radius <= 0) {
            return null;
        }
        int[] c = new int[]{this.field_70329_l + this.field_70331_k.field_73012_v.nextInt(2 * radius + 1) - radius, this.field_70330_m + this.field_70331_k.field_73012_v.nextInt(2 * radius + 1) - radius, this.field_70327_n + this.field_70331_k.field_73012_v.nextInt(2 * radius + 1) - radius};
        if (c[0] == this.field_70329_l && c[1] == this.field_70330_m && c[2] == this.field_70327_n) {
            return null;
        }
        return c;
    }

    public void processChambers() {
        int size = this.getReactorSize();
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < size; ++x) {
                ItemStack thing = this.getMatrixCoord(x, y);
                if (thing == null || !(thing.func_77973_b() instanceof IReactorComponent)) continue;
                IReactorComponent comp = (IReactorComponent)thing.func_77973_b();
                comp.processChamber(this, thing, x, y);
            }
        }
    }

    @Override
    public boolean produceEnergy() {
        return this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n) && IC2.energyGeneratorNuclear != 0;
    }

    public ItemStack getMatrixCoord(int x, int y) {
        if (x < 0 || x >= 9 || y < 0 || y >= 6) {
            return null;
        }
        return super.func_70301_a(x + y * 9);
    }

    @Override
    public ItemStack func_70301_a(int i) {
        int x = i % 9;
        short size = this.getReactorSize();
        if (x >= size) {
            return this.getMatrixCoord(size - 1, i / 9);
        }
        return super.func_70301_a(i);
    }

    public void setMatrixCoord(int x, int y, ItemStack stack) {
        if (x < 0 || x >= 9 || y < 0 || y >= 6) {
            return;
        }
        super.func_70299_a(x + y * 9, stack);
    }

    @Override
    public void func_70299_a(int i, ItemStack itemstack) {
        int x = i % 9;
        short size = this.getReactorSize();
        if (x >= size) {
            this.setMatrixCoord(size - 1, i / 9, itemstack);
        } else {
            super.func_70299_a(i, itemstack);
        }
    }

    public short getReactorSize() {
        if (this.field_70331_k == null) {
            return 9;
        }
        short rows = 3;
        for (Direction direction : directions) {
            TileEntity target = direction.applyToTileEntity(this);
            if (!(target instanceof TileEntityReactorChamber)) continue;
            rows = (short)(rows + 1);
        }
        return rows;
    }

    public float sendEnergyToChambers(float send) {
        send = this.sendEnergy(send);
        for (Direction value : directions) {
            TileEntity te = value.applyToTileEntity(this);
            if (!(te instanceof TileEntityReactorChamber)) continue;
            send = ((TileEntityReactorChamber)te).sendEnergy(send);
        }
        return send;
    }

    @Override
    public int getTickRate() {
        return 20;
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerNuclearReactor(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiNuclearReactor(new ContainerNuclearReactor(entityPlayer, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("output")) {
            if (this.output > 0.0f) {
                if (this.lastOutput <= 0.0f) {
                    if (this.audioSourceMain == null) {
                        this.audioSourceMain = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/NuclearReactor/NuclearReactorLoop.ogg", true, false, IC2.audioManager.defaultVolume);
                    }
                    if (this.audioSourceMain != null) {
                        this.audioSourceMain.play();
                    }
                }
                if (this.output < 40.0f) {
                    if (this.lastOutput <= 0.0f || this.lastOutput >= 40.0f) {
                        if (this.audioSourceGeiger != null) {
                            this.audioSourceGeiger.remove();
                        }
                        this.audioSourceGeiger = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/NuclearReactor/GeigerLowEU.ogg", true, false, IC2.audioManager.defaultVolume);
                        if (this.audioSourceGeiger != null) {
                            this.audioSourceGeiger.play();
                        }
                    }
                } else if (this.output < 80.0f) {
                    if (this.lastOutput < 40.0f || this.lastOutput >= 80.0f) {
                        if (this.audioSourceGeiger != null) {
                            this.audioSourceGeiger.remove();
                        }
                        this.audioSourceGeiger = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/NuclearReactor/GeigerMedEU.ogg", true, false, IC2.audioManager.defaultVolume);
                        if (this.audioSourceGeiger != null) {
                            this.audioSourceGeiger.play();
                        }
                    }
                } else if (this.output >= 80.0f && this.lastOutput < 80.0f) {
                    if (this.audioSourceGeiger != null) {
                        this.audioSourceGeiger.remove();
                    }
                    this.audioSourceGeiger = IC2.audioManager.createSource(this, PositionSpec.Center, "Generators/NuclearReactor/GeigerHighEU.ogg", true, false, IC2.audioManager.defaultVolume);
                    if (this.audioSourceGeiger != null) {
                        this.audioSourceGeiger.play();
                    }
                }
            } else if (this.lastOutput > 0.0f) {
                if (this.audioSourceMain != null) {
                    this.audioSourceMain.stop();
                }
                if (this.audioSourceGeiger != null) {
                    this.audioSourceGeiger.stop();
                }
            }
            this.lastOutput = this.output;
        }
        super.onNetworkUpdate(field);
    }

    @Override
    public float getWrenchDropRate() {
        return 0.8f;
    }

    @Override
    public ChunkCoordinates getPosition() {
        return new ChunkCoordinates(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public World getWorld() {
        return this.field_70331_k;
    }

    @Override
    public int getHeat() {
        return this.heat;
    }

    @Override
    public void setHeat(int heat) {
        this.heat = heat;
    }

    @Override
    public int addHeat(int amount) {
        this.heat += amount;
        return this.heat;
    }

    @Override
    public ItemStack getItemAt(int x, int y) {
        return this.getMatrixCoord(x, y);
    }

    @Override
    public void setItemAt(int x, int y, ItemStack item) {
        this.setMatrixCoord(x, y, item);
    }

    @Override
    public void explode() {
        float boomPower = 10.0f;
        float boomMod = 1.0f;
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < this.getReactorSize(); ++x) {
                ItemStack stack = this.getMatrixCoord(x, y);
                if (stack != null && stack.func_77973_b() instanceof IReactorComponent) {
                    float f = ((IReactorComponent)stack.func_77973_b()).influenceExplosion(this, stack);
                    if (f > 0.0f && f < 1.0f) {
                        boomMod *= f;
                    } else {
                        boomPower += f;
                    }
                }
                this.setMatrixCoord(x, y, null);
            }
        }
        IC2.log.log(Level.INFO, "Nuclear Reactor at " + this.field_70331_k.field_73011_w.field_76574_g + ":(" + this.field_70329_l + "," + this.field_70330_m + "," + this.field_70327_n + ") melted (explosion power " + (boomPower *= this.hem * boomMod) + ")");
        if (boomPower > IC2.explosionPowerReactorMax) {
            boomPower = IC2.explosionPowerReactorMax;
        }
        for (Direction direction : directions) {
            TileEntity target = direction.applyToTileEntity(this);
            if (!(target instanceof TileEntityReactorChamber)) continue;
            this.field_70331_k.func_72832_d(target.field_70329_l, target.field_70330_m, target.field_70327_n, 0, 0, 7);
        }
        this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, 0, 7);
        ExplosionIC2 explosion = new ExplosionIC2(this.field_70331_k, null, this.field_70329_l, this.field_70330_m, this.field_70327_n, boomPower, 0.01f, 1.5f, true);
        explosion.doExplosion();
    }

    @Override
    public int getMaxHeat() {
        return this.maxHeat;
    }

    @Override
    public void setMaxHeat(int newMaxHeat) {
        this.maxHeat = newMaxHeat;
    }

    @Override
    public float getHeatEffectModifier() {
        return this.hem;
    }

    @Override
    public void setHeatEffectModifier(float newHEM) {
        this.hem = newHEM;
    }

    @Override
    public float getReactorEnergyOutput() {
        return this.output;
    }

    @Override
    public float addOutput(float energy) {
        return this.output += energy;
    }

    public abstract float sendEnergy(float var1);
}

