/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.BlockMultiID;
import ic2.core.block.generator.tileentity.TileEntityNuclearReactor;
import ic2.core.block.generator.tileentity.TileEntityReactorChamber;
import ic2.core.block.generator.tileentity.TileEntityReactorChamberElectric;
import ic2.core.init.InternalName;
import ic2.core.item.block.ItemBlockIC2;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;

public class BlockReactorChamber
extends BlockMultiID {
    public static Class<? extends TileEntityReactorChamber> tileEntityReactorChamberClass = TileEntityReactorChamberElectric.class;

    public BlockReactorChamber(Configuration config, InternalName internalName) {
        super(config, internalName, Material.field_76243_f, ItemBlockIC2.class);
        this.func_71848_c(2.0f);
        this.func_71884_a(field_71977_i);
        Ic2Items.reactorChamber = new ItemStack((Block)this);
    }

    @Override
    public String getTextureFolder(int id) {
        return "generator";
    }

    public void func_71863_a(World world, int i, int j, int k, int l) {
        if (!this.func_71930_b(world, i, j, k)) {
            this.func_71929_a(world, i, j, k, new ItemStack(world.func_72798_a(i, j, k), 1, 0));
            world.func_72832_d(i, j, k, 0, 0, 7);
        }
    }

    public boolean func_71930_b(World world, int i, int j, int k) {
        int count = 0;
        if (this.isReactorAt(world, i + 1, j, k)) {
            ++count;
        }
        if (this.isReactorAt(world, i - 1, j, k)) {
            ++count;
        }
        if (this.isReactorAt(world, i, j + 1, k)) {
            ++count;
        }
        if (this.isReactorAt(world, i, j - 1, k)) {
            ++count;
        }
        if (this.isReactorAt(world, i, j, k + 1)) {
            ++count;
        }
        if (this.isReactorAt(world, i, j, k - 1)) {
            ++count;
        }
        return count == 1;
    }

    public void func_71862_a(World world, int i, int j, int k, Random random) {
        int n;
        TileEntityNuclearReactor reactor = this.getReactorEntity(world, i, j, k);
        if (reactor == null) {
            this.func_71863_a(world, i, j, k, this.field_71990_ca);
            return;
        }
        int puffs = reactor.heat / 1000;
        if (puffs <= 0) {
            return;
        }
        puffs = world.field_73012_v.nextInt(puffs);
        for (n = 0; n < puffs; ++n) {
            world.func_72869_a("smoke", (double)((float)i + random.nextFloat()), (double)((float)j + 0.95f), (double)((float)k + random.nextFloat()), 0.0, 0.0, 0.0);
        }
        puffs -= world.field_73012_v.nextInt(4) + 3;
        for (n = 0; n < puffs; ++n) {
            world.func_72869_a("flame", (double)((float)i + random.nextFloat()), (double)((float)j + 1.0f), (double)((float)k + random.nextFloat()), 0.0, 0.0, 0.0);
        }
    }

    public boolean isReactorAt(World world, int x, int y, int z) {
        return world.func_72796_p(x, y, z) instanceof TileEntityNuclearReactor && world.func_72798_a(x, y, z) == Ic2Items.nuclearReactor.field_77993_c && world.func_72805_g(x, y, z) == Ic2Items.nuclearReactor.func_77960_j();
    }

    public TileEntityNuclearReactor getReactorEntity(World world, int i, int j, int k) {
        if (this.isReactorAt(world, i + 1, j, k)) {
            return (TileEntityNuclearReactor)world.func_72796_p(i + 1, j, k);
        }
        if (this.isReactorAt(world, i - 1, j, k)) {
            return (TileEntityNuclearReactor)world.func_72796_p(i - 1, j, k);
        }
        if (this.isReactorAt(world, i, j + 1, k)) {
            return (TileEntityNuclearReactor)world.func_72796_p(i, j + 1, k);
        }
        if (this.isReactorAt(world, i, j - 1, k)) {
            return (TileEntityNuclearReactor)world.func_72796_p(i, j - 1, k);
        }
        if (this.isReactorAt(world, i, j, k + 1)) {
            return (TileEntityNuclearReactor)world.func_72796_p(i, j, k + 1);
        }
        if (this.isReactorAt(world, i, j, k - 1)) {
            return (TileEntityNuclearReactor)world.func_72796_p(i, j, k - 1);
        }
        this.func_71863_a(world, i, j, k, world.func_72798_a(i, j, k));
        return null;
    }

    @Override
    public boolean func_71903_a(World world, int i, int j, int k, EntityPlayer entityplayer, int side, float a, float b, float c) {
        if (entityplayer.func_70093_af()) {
            return false;
        }
        TileEntityNuclearReactor reactor = this.getReactorEntity(world, i, j, k);
        if (reactor == null) {
            this.func_71863_a(world, i, j, k, this.field_71990_ca);
            return false;
        }
        if (!IC2.platform.isSimulating()) {
            return true;
        }
        return IC2.platform.launchGui(entityplayer, reactor);
    }

    @Override
    public TileEntity createTileEntity(World world, int meta) {
        try {
            return tileEntityReactorChamberClass.newInstance();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public int func_71885_a(int meta, Random random, int j) {
        return Ic2Items.machine.field_77993_c;
    }

    public int func_71899_b(int meta) {
        return Ic2Items.machine.func_77960_j();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.uncommon;
    }
}

