/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkUpdateListener;
import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.ITickCallback;
import ic2.core.Ic2Items;
import ic2.core.block.BlockTextureStitched;
import ic2.core.block.BlockTileEntity;
import ic2.core.migration.BlockMigrate;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class TileEntityBlock
extends TileEntity
implements INetworkDataProvider,
INetworkUpdateListener,
IWrenchable {
    public int tileEntityId;
    private boolean active = false;
    private short facing = 0;
    public boolean prevActive = false;
    public short prevFacing = 0;
    public boolean loaded = false;
    @SideOnly(value=Side.CLIENT)
    private Icon[] lastRenderIcons;
    private int tesrMask;
    public int tesrTtl;
    private static final int defaultTesrTtl = 500;

    public void func_70312_q() {
        super.func_70312_q();
        IC2.addSingleTickCallback(this.field_70331_k, new ITickCallback(){

            @Override
            public void tickCallback(World world) {
                if (TileEntityBlock.this.func_70320_p() || !world.func_72899_e(TileEntityBlock.this.field_70329_l, TileEntityBlock.this.field_70330_m, TileEntityBlock.this.field_70327_n)) {
                    return;
                }
                TileEntityBlock.this.onLoaded();
                if (!TileEntityBlock.this.func_70320_p() && TileEntityBlock.this.enableUpdateEntity()) {
                    world.field_73009_h.add(TileEntityBlock.this);
                }
            }
        });
    }

    public void func_70313_j() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.func_70313_j();
    }

    public void onChunkUnload() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.onChunkUnload();
    }

    public void onLoaded() {
        this.loaded = true;
        Block block = this.func_70311_o();
        if (block instanceof BlockMigrate) {
            ((BlockMigrate)block).migrate(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    public void onUnloaded() {
        this.loaded = false;
    }

    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.tileEntityId = nbttagcompound.func_74762_e("tileEntityId");
        this.prevFacing = this.facing = nbttagcompound.func_74765_d("facing");
    }

    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("tileEntityId", this.tileEntityId);
        nbttagcompound.func_74777_a("facing", this.facing);
    }

    public final boolean canUpdate() {
        return false;
    }

    public boolean enableUpdateEntity() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void onRender() {
        Block block = this.func_70311_o();
        if (this.lastRenderIcons == null) {
            this.lastRenderIcons = new Icon[6];
        }
        for (int side = 0; side < 6; ++side) {
            this.lastRenderIcons[side] = block.func_71895_b((IBlockAccess)this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, side);
        }
        this.tesrMask = 0;
    }

    public boolean shouldRefresh(int oldID, int newID, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return !(Block.field_71973_m[oldID] instanceof BlockMigrate) || !(Block.field_71973_m[newID] instanceof BlockTileEntity);
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        if (this.prevActive != active) {
            IC2.network.updateTileEntityField(this, "active");
        }
        this.prevActive = active;
    }

    public void setActiveWithoutNotify(boolean active) {
        this.active = active;
        this.prevActive = active;
    }

    @Override
    public short getFacing() {
        return this.facing;
    }

    @Override
    public List<String> getNetworkedFields() {
        Vector<String> ret = new Vector<String>(2);
        ret.add("tileEntityId");
        ret.add("active");
        ret.add("facing");
        return ret;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.active || field.equals("facing") && this.prevFacing != this.facing) {
            int reRenderMask = 0;
            Block block = this.func_70311_o();
            if (this.lastRenderIcons == null) {
                reRenderMask = -1;
            } else {
                for (int side = 0; side < 6; ++side) {
                    Icon newIcon;
                    Icon oldIcon = this.lastRenderIcons[side];
                    if (oldIcon instanceof BlockTextureStitched) {
                        oldIcon = ((BlockTextureStitched)oldIcon).getRealTexture();
                    }
                    if ((newIcon = block.func_71895_b((IBlockAccess)this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, side)) instanceof BlockTextureStitched) {
                        newIcon = ((BlockTextureStitched)newIcon).getRealTexture();
                    }
                    if (oldIcon == newIcon) continue;
                    reRenderMask |= 1 << side;
                }
            }
            if (reRenderMask != 0) {
                if (reRenderMask < 0 || this.prevFacing != this.facing || block.func_71857_b() != IC2.platform.getRenderId("default")) {
                    this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                } else {
                    this.tesrMask = reRenderMask;
                    this.tesrTtl = 500;
                }
            }
            this.prevActive = this.active;
            this.prevFacing = this.facing;
        }
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    @Override
    public void setFacing(short facing) {
        this.facing = facing;
        if (this.prevFacing != facing) {
            IC2.network.updateTileEntityField(this, "facing");
        }
        this.prevFacing = facing;
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n), 1, this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n));
    }

    public int getTesrMask() {
        return this.tesrMask;
    }

    public void onBlockBreak(int id, int meta) {
    }

    public String getTextureFolder() {
        return null;
    }

    public boolean onBlockActivated(EntityPlayer player, float xOffset, float yOffset, float zOffset, MutableBoolean result) {
        return false;
    }

    public void randomDisplayTick(Random random) {
    }

    public void adjustDrops(List<ItemStack> drops, int fortune) {
        drops.set(0, new ItemStack(Ic2Items.teBlock.field_77993_c, 1, this.tileEntityId));
    }
}

