/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.world;

import codechicken.lib.world.ChunkExtension;
import java.util.HashMap;

public abstract class WorldExtension {
    public final abv world;
    public HashMap<adq, ChunkExtension> chunkMap = new HashMap();

    public WorldExtension(abv world) {
        this.world = world;
    }

    public void load() {
    }

    public void unload() {
    }

    public void save() {
    }

    public void preTick() {
    }

    public void postTick() {
    }

    protected final void addChunk(ChunkExtension extension) {
        this.chunkMap.put(extension.chunk, extension);
    }

    protected final void loadChunk(adq chunk) {
        this.chunkMap.get(chunk).load();
    }

    protected final void unloadChunk(adq chunk) {
        this.chunkMap.get(chunk).unload();
    }

    protected final void loadChunkData(adq chunk, bx tag) {
        this.chunkMap.get(chunk).loadData(tag);
    }

    protected final void saveChunkData(adq chunk, bx tag) {
        this.chunkMap.get(chunk).saveData(tag);
    }

    protected final void remChunk(adq chunk) {
        this.chunkMap.remove(chunk);
    }

    protected final void watchChunk(adq chunk, ju player) {
        this.chunkMap.get(chunk).watchPlayer(player);
    }

    protected final void unwatchChunk(adq chunk, ju player) {
        ChunkExtension extension = this.chunkMap.get(chunk);
        if (extension != null) {
            extension.unwatchPlayer(player);
        }
    }

    protected final void sendChunkUpdates(adq chunk) {
        this.chunkMap.get(chunk).sendUpdatePackets();
    }

    public boolean containsChunk(adq chunk) {
        return this.chunkMap.containsKey(chunk);
    }

    public ChunkExtension getChunkExtension(int chunkXPos, int chunkZPos) {
        if (!this.world.f(chunkXPos << 4, 128, chunkZPos << 4)) {
            return null;
        }
        return this.chunkMap.get(this.world.e(chunkXPos, chunkZPos));
    }
}

