/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.vec;

import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;

public class TransformationList
extends Transformation {
    private ArrayList<Transformation> transformations = new ArrayList();
    private Matrix4 mat;

    public TransformationList(Transformation ... transforms) {
        for (Transformation t : transforms) {
            this.with(t);
        }
    }

    public Matrix4 compile() {
        if (this.mat == null) {
            this.mat = new Matrix4();
            for (int i = this.transformations.size() - 1; i >= 0; --i) {
                this.transformations.get(i).apply(this.mat);
            }
        }
        return this.mat;
    }

    public Matrix4 reverseCompile() {
        Matrix4 mat = new Matrix4();
        for (Transformation t : this.transformations) {
            t.apply(mat);
        }
        return mat;
    }

    @Override
    public void apply(Vector3 vec) {
        if (this.mat != null) {
            this.mat.apply(vec);
        } else {
            for (Transformation t : this.transformations) {
                t.apply(vec);
            }
        }
    }

    @Override
    public void applyN(Vector3 normal) {
        if (this.mat != null) {
            this.mat.applyN(normal);
        } else {
            for (Transformation t : this.transformations) {
                t.applyN(normal);
            }
        }
    }

    @Override
    public void apply(Matrix4 mat) {
        mat.multiply(this.compile());
    }

    @Override
    public TransformationList with(Transformation t) {
        this.mat = null;
        if (t instanceof TransformationList) {
            this.transformations.addAll(((TransformationList)t).transformations);
        } else {
            this.transformations.add(t);
        }
        return this;
    }

    public TransformationList prepend(Transformation t) {
        this.mat = null;
        if (t instanceof TransformationList) {
            this.transformations.addAll(0, ((TransformationList)t).transformations);
        } else {
            this.transformations.add(0, t);
        }
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void glApply() {
        for (int i = this.transformations.size() - 1; i >= 0; --i) {
            this.transformations.get(i).glApply();
        }
    }

    @Override
    public Transformation inverse() {
        TransformationList rev = new TransformationList(new Transformation[0]);
        for (int i = this.transformations.size() - 1; i >= 0; --i) {
            rev.with(this.transformations.get(i).inverse());
        }
        return rev;
    }

    public String toString() {
        String s = "";
        for (Transformation t : this.transformations) {
            s = s + "\n" + t.toString();
        }
        return s.trim();
    }
}

