/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourARGB;
import codechicken.lib.render.PlaceholderTexture;
import codechicken.lib.render.TextureDataHolder;
import codechicken.lib.render.TextureSpecial;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import org.lwjgl.opengl.GL11;

public class TextureUtils {
    private static ArrayList<IIconRegister> iconRegistrars;

    public static void addIconRegistrar(IIconRegister registrar) {
        iconRegistrars.add(registrar);
    }

    @ForgeSubscribe
    public void textureLoad(TextureStitchEvent.Pre event) {
        for (IIconRegister reg : iconRegistrars) {
            if (reg.atlasIndex() != event.map.g) continue;
            reg.registerIcons((ms)event.map);
        }
    }

    public static int[] loadTextureData(bjl resource) {
        return TextureUtils.loadTexture((bjl)resource).data;
    }

    public static Colour[] loadTextureColours(bjl resource) {
        int[] idata = TextureUtils.loadTextureData(resource);
        Colour[] data = new Colour[idata.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = new ColourARGB(idata[i]);
        }
        return data;
    }

    public static InputStream getTextureResource(bjl textureFile) throws IOException {
        return ats.w().K().a(textureFile).b();
    }

    public static BufferedImage loadBufferedImage(bjl textureFile) {
        try {
            return TextureUtils.loadBufferedImage(TextureUtils.getTextureResource(textureFile));
        }
        catch (Exception e) {
            System.err.println("Failed to load texture file: " + textureFile);
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage loadBufferedImage(InputStream in) throws IOException {
        BufferedImage img = ImageIO.read(in);
        in.close();
        return img;
    }

    public static bij engine() {
        return ats.w().N;
    }

    public static void copySubImg(int[] fromTex, int fromWidth, int fromX, int fromY, int width, int height, int[] toTex, int toWidth, int toX, int toY) {
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int fp = (y + fromY) * fromWidth + x + fromX;
                int tp = (y + toX) * toWidth + x + toX;
                toTex[tp] = fromTex[fp];
            }
        }
    }

    public static void bindAtlas(int atlasIndex) {
        TextureUtils.engine().a(atlasIndex == 0 ? bih.b : bih.c);
    }

    public static mr getBlankIcon(int size, ms iconRegister) {
        bih textureMap = (bih)iconRegister;
        String s = "blank_" + size;
        if (textureMap.getTextureExtry(s) == null) {
            TextureSpecial icon = new TextureSpecial(s).blank(size);
            textureMap.setTextureEntry(s, (bii)icon);
        }
        return iconRegister.a(s);
    }

    public static TextureSpecial getTextureSpecial(ms iconRegister, String name) {
        bih textureMap = (bih)iconRegister;
        bii entry = textureMap.getTextureExtry(name);
        if (entry != null) {
            throw new IllegalStateException("Texture: " + name + " is already registered");
        }
        TextureSpecial icon = new TextureSpecial(name);
        textureMap.setTextureEntry(name, (bii)icon);
        return icon;
    }

    public static void prepareTexture(int target, int texture, int min_mag_filter, int wrap) {
        GL11.glBindTexture((int)target, (int)texture);
        GL11.glTexParameteri((int)target, (int)10241, (int)min_mag_filter);
        GL11.glTexParameteri((int)target, (int)10240, (int)min_mag_filter);
        switch (target) {
            case 32879: {
                GL11.glTexParameteri((int)target, (int)32882, (int)wrap);
            }
            case 3553: {
                GL11.glTexParameteri((int)target, (int)10243, (int)wrap);
            }
            case 3552: {
                GL11.glTexParameteri((int)target, (int)10242, (int)wrap);
            }
        }
    }

    public static TextureDataHolder loadTexture(bjl resource) {
        BufferedImage img = TextureUtils.loadBufferedImage(resource);
        if (img == null) {
            throw new RuntimeException("Texture not found: " + resource);
        }
        return new TextureDataHolder(img);
    }

    public static boolean refreshTexture(bih map, String name) {
        if (map.getTextureExtry(name) == null) {
            map.setTextureEntry(name, (bii)new PlaceholderTexture(name));
            return true;
        }
        return false;
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)new TextureUtils());
        iconRegistrars = new ArrayList();
    }

    public static interface IIconRegister {
        public void registerIcons(ms var1);

        public int atlasIndex();
    }
}

