/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.render.TextureDataHolder;
import codechicken.lib.render.TextureFX;
import codechicken.lib.render.TextureSpecial;
import codechicken.lib.render.TextureUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;

public class SpriteSheetManager {
    private static HashMap<String, SpriteSheet> spriteSheets = new HashMap();

    public static SpriteSheet getSheet(bjl resource) {
        return SpriteSheetManager.getSheet(16, 16, resource);
    }

    public static SpriteSheet getSheet(int tilesX, int tilesY, bjl resource) {
        SpriteSheet sheet = spriteSheets.get(resource.toString());
        if (sheet == null) {
            sheet = new SpriteSheet(tilesX, tilesY, resource);
            spriteSheets.put(resource.toString(), sheet);
        }
        return sheet;
    }

    @SideOnly(value=Side.CLIENT)
    public static class SpriteSheet
    implements TextureUtils.IIconRegister {
        private int tilesX;
        private int tilesY;
        private ArrayList<Integer> newSprites = new ArrayList();
        private TextureSpecial[] sprites;
        private bjl resource;
        private TextureDataHolder texture;
        private int spriteWidth;
        private int spriteHeight;
        public int atlasIndex;

        private SpriteSheet(int tilesX, int tilesY, bjl textureFile) {
            this.tilesX = tilesX;
            this.tilesY = tilesY;
            this.resource = textureFile;
            this.sprites = new TextureSpecial[tilesX * tilesY];
        }

        public void requestIndicies(int ... indicies) {
            for (int i : indicies) {
                this.setupSprite(i);
            }
        }

        @Override
        public void registerIcons(ms register) {
            bih textureMap = (bih)register;
            if (TextureUtils.refreshTexture(textureMap, this.resource.a())) {
                this.reloadTexture();
                for (int i = 0; i < this.sprites.length; ++i) {
                    if (this.sprites[i] == null) continue;
                    textureMap.setTextureEntry(this.sprites[i].g(), (bii)this.sprites[i]);
                }
            } else {
                for (int i : this.newSprites) {
                    textureMap.setTextureEntry(this.sprites[i].g(), (bii)this.sprites[i]);
                }
            }
            this.newSprites.clear();
        }

        public TextureSpecial setupSprite(int i) {
            if (this.sprites[i] == null) {
                String name = this.resource + "_" + i;
                this.sprites[i] = new TextureSpecial(name).baseFromSheet(this, i);
                this.newSprites.add(i);
            }
            return this.sprites[i];
        }

        private void reloadTexture() {
            this.texture = TextureUtils.loadTexture(this.resource);
            this.spriteWidth = this.texture.width / this.tilesX;
            this.spriteHeight = this.texture.height / this.tilesY;
        }

        public mr getSprite(int index) {
            TextureSpecial i = this.sprites[index];
            if (i == null) {
                throw new IllegalArgumentException("Sprite at index: " + index + " from texture file " + this.resource + " was not preloaded.");
            }
            return i;
        }

        public TextureDataHolder createSprite(int spriteIndex) {
            int sx = spriteIndex % this.tilesX;
            int sy = spriteIndex / this.tilesX;
            TextureDataHolder sprite = new TextureDataHolder(this.spriteWidth, this.spriteHeight);
            TextureUtils.copySubImg(this.texture.data, this.texture.width, sx * this.spriteWidth, sy * this.spriteHeight, this.spriteWidth, this.spriteHeight, sprite.data, this.spriteWidth, 0, 0);
            return sprite;
        }

        public int spriteWidth() {
            return this.spriteWidth;
        }

        public int spriteHeight() {
            return this.spriteHeight;
        }

        public TextureSpecial func_110577_aFX(int i, TextureFX textureFX) {
            return this.setupSprite(i).addTextureFX(textureFX);
        }

        public SpriteSheet selfRegister(int atlas) {
            TextureUtils.addIconRegistrar(this);
            return this;
        }

        @Override
        public int atlasIndex() {
            return this.atlasIndex;
        }
    }
}

