/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.IFaceRenderer;
import codechicken.lib.render.IUVTransformation;
import codechicken.lib.render.IVertexModifier;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.render.UV;
import codechicken.lib.render.Vertex5;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rectangle4i;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    static Vector3[] vectors = new Vector3[8];
    static bgt uniformRenderItem = new bgt(){

        public boolean shouldBob() {
            return false;
        }
    };
    static sr entityItem;
    private static Vertex5[] face;

    @Deprecated
    public static void renderLiquidQuad(Vector3 point1, Vector3 point2, Vector3 point3, Vector3 point4, mr icon, double res) {
        RenderUtils.renderFluidQuad(point1, point2, point3, point4, icon, res);
    }

    public static void renderFluidQuad(Vector3 point1, Vector3 point2, Vector3 point3, Vector3 point4, mr icon, double res) {
        double rx;
        double u1 = icon.c();
        double du = icon.d() - icon.c();
        double v2 = icon.f();
        double dv = icon.f() - icon.e();
        Vector3 wide = vectors[0].set(point4).subtract(point1);
        Vector3 high = vectors[1].set(point1).subtract(point2);
        bfn t = bfn.a;
        double wlen = wide.mag();
        double hlen = high.mag();
        for (double x = 0.0; x < wlen; x += rx) {
            double ry;
            rx = wlen - x;
            if (rx > res) {
                rx = res;
            }
            for (double y = 0.0; y < hlen; y += ry) {
                ry = hlen - y;
                if (ry > res) {
                    ry = res;
                }
                Vector3 dx1 = vectors[2].set(wide).multiply(x / wlen);
                Vector3 dx2 = vectors[3].set(wide).multiply((x + rx) / wlen);
                Vector3 dy1 = vectors[4].set(high).multiply(y / hlen);
                Vector3 dy2 = vectors[5].set(high).multiply((y + ry) / hlen);
                t.a(point2.x + dx1.x + dy2.x, point2.y + dx1.y + dy2.y, point2.z + dx1.z + dy2.z, u1, v2 - ry / res * dv);
                t.a(point2.x + dx1.x + dy1.x, point2.y + dx1.y + dy1.y, point2.z + dx1.z + dy1.z, u1, v2);
                t.a(point2.x + dx2.x + dy1.x, point2.y + dx2.y + dy1.y, point2.z + dx2.z + dy1.z, u1 + rx / res * du, v2);
                t.a(point2.x + dx2.x + dy2.x, point2.y + dx2.y + dy2.y, point2.z + dx2.z + dy2.z, u1 + rx / res * du, v2 - ry / res * dv);
            }
        }
    }

    public static void translateToWorldCoords(nm entity, float frame) {
        double interpPosX = entity.U + (entity.u - entity.U) * (double)frame;
        double interpPosY = entity.V + (entity.v - entity.V) * (double)frame;
        double interpPosZ = entity.W + (entity.w - entity.W) * (double)frame;
        GL11.glTranslated((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
    }

    @Deprecated
    public static void drawOutlinedBoundingBox(asu aabb) {
        RenderUtils.drawCuboidOutline(new Cuboid6(aabb));
    }

    public static void drawCuboidOutline(Cuboid6 c) {
        bfn var2 = bfn.a;
        var2.b(3);
        var2.a(c.min.x, c.min.y, c.min.z);
        var2.a(c.max.x, c.min.y, c.min.z);
        var2.a(c.max.x, c.min.y, c.max.z);
        var2.a(c.min.x, c.min.y, c.max.z);
        var2.a(c.min.x, c.min.y, c.min.z);
        var2.a();
        var2.b(3);
        var2.a(c.min.x, c.max.y, c.min.z);
        var2.a(c.max.x, c.max.y, c.min.z);
        var2.a(c.max.x, c.max.y, c.max.z);
        var2.a(c.min.x, c.max.y, c.max.z);
        var2.a(c.min.x, c.max.y, c.min.z);
        var2.a();
        var2.b(1);
        var2.a(c.min.x, c.min.y, c.min.z);
        var2.a(c.min.x, c.max.y, c.min.z);
        var2.a(c.max.x, c.min.y, c.min.z);
        var2.a(c.max.x, c.max.y, c.min.z);
        var2.a(c.max.x, c.min.y, c.max.z);
        var2.a(c.max.x, c.max.y, c.max.z);
        var2.a(c.min.x, c.min.y, c.max.z);
        var2.a(c.min.x, c.max.y, c.max.z);
        var2.a();
    }

    @Deprecated
    public static void renderLiquidCuboid(Cuboid6 bound, mr tex, double res) {
        RenderUtils.renderFluidCuboid(bound, tex, res);
    }

    public static void renderFluidCuboid(Cuboid6 bound, mr tex, double res) {
        RenderUtils.renderFluidQuad(new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), tex, res);
        RenderUtils.renderFluidQuad(new Vector3(bound.min.x, bound.max.y, bound.min.z), new Vector3(bound.min.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.renderFluidQuad(new Vector3(bound.min.x, bound.max.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), new Vector3(bound.min.x, bound.max.y, bound.max.z), tex, res);
        RenderUtils.renderFluidQuad(new Vector3(bound.max.x, bound.max.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.max.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.renderFluidQuad(new Vector3(bound.max.x, bound.max.y, bound.min.z), new Vector3(bound.max.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.min.y, bound.min.z), new Vector3(bound.min.x, bound.max.y, bound.min.z), tex, res);
        RenderUtils.renderFluidQuad(new Vector3(bound.min.x, bound.max.y, bound.max.z), new Vector3(bound.min.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.min.y, bound.max.z), new Vector3(bound.max.x, bound.max.y, bound.max.z), tex, res);
    }

    public static void renderBlockOverlaySide(int x, int y, int z, int side, double tx1, double tx2, double ty1, double ty2) {
        double[] points = new double[]{(double)x - 0.009, (double)x + 1.009, (double)y - 0.009, (double)y + 1.009, (double)z - 0.009, (double)z + 1.009};
        bfn tessellator = bfn.a;
        switch (side) {
            case 0: {
                tessellator.a(points[0], points[2], points[4], tx1, ty1);
                tessellator.a(points[1], points[2], points[4], tx2, ty1);
                tessellator.a(points[1], points[2], points[5], tx2, ty2);
                tessellator.a(points[0], points[2], points[5], tx1, ty2);
                break;
            }
            case 1: {
                tessellator.a(points[1], points[3], points[4], tx2, ty1);
                tessellator.a(points[0], points[3], points[4], tx1, ty1);
                tessellator.a(points[0], points[3], points[5], tx1, ty2);
                tessellator.a(points[1], points[3], points[5], tx2, ty2);
                break;
            }
            case 2: {
                tessellator.a(points[0], points[3], points[4], tx2, ty1);
                tessellator.a(points[1], points[3], points[4], tx1, ty1);
                tessellator.a(points[1], points[2], points[4], tx1, ty2);
                tessellator.a(points[0], points[2], points[4], tx2, ty2);
                break;
            }
            case 3: {
                tessellator.a(points[1], points[3], points[5], tx2, ty1);
                tessellator.a(points[0], points[3], points[5], tx1, ty1);
                tessellator.a(points[0], points[2], points[5], tx1, ty2);
                tessellator.a(points[1], points[2], points[5], tx2, ty2);
                break;
            }
            case 4: {
                tessellator.a(points[0], points[3], points[5], tx2, ty1);
                tessellator.a(points[0], points[3], points[4], tx1, ty1);
                tessellator.a(points[0], points[2], points[4], tx1, ty2);
                tessellator.a(points[0], points[2], points[5], tx2, ty2);
                break;
            }
            case 5: {
                tessellator.a(points[1], points[3], points[4], tx2, ty1);
                tessellator.a(points[1], points[3], points[5], tx1, ty1);
                tessellator.a(points[1], points[2], points[5], tx1, ty2);
                tessellator.a(points[1], points[2], points[4], tx2, ty2);
            }
        }
    }

    @Deprecated
    public static boolean shouldRenderLiquid(FluidStack stack) {
        return RenderUtils.shouldRenderFluid(stack);
    }

    public static boolean shouldRenderFluid(FluidStack stack) {
        return stack.amount > 0 && stack.getFluid() != null;
    }

    public static mr prepareFluidRender(FluidStack stack, int alpha) {
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Fluid fluid = stack.getFluid();
        CCRenderState.setColour(fluid.getColor(stack) << 8 | alpha);
        TextureUtils.bindAtlas(fluid.getSpriteNumber());
        return fluid.getIcon(stack);
    }

    public static void postFluidRender() {
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
    }

    @Deprecated
    public static void renderLiquidCuboid(FluidStack stack, Cuboid6 bound, double density, double res) {
        RenderUtils.renderFluidCuboid(stack, bound, density, res);
    }

    public static double fluidDensityToAlpha(double density) {
        return Math.pow(density, 0.4);
    }

    public static void renderFluidCuboid(FluidStack stack, Cuboid6 bound, double density, double res) {
        if (!RenderUtils.shouldRenderLiquid(stack)) {
            return;
        }
        int alpha = 255;
        if (stack.getFluid().isGaseous()) {
            alpha = (int)(RenderUtils.fluidDensityToAlpha(density) * 255.0);
        } else {
            bound.max.y = bound.min.y + (bound.max.y - bound.min.y) * density;
        }
        mr tex = RenderUtils.prepareFluidRender(stack, alpha);
        CCRenderState.startDrawing(7);
        RenderUtils.renderLiquidCuboid(bound, tex, res);
        CCRenderState.draw();
        RenderUtils.postFluidRender();
    }

    public static void renderFluidGauge(FluidStack stack, Rectangle4i rect, double density, double res) {
        if (!RenderUtils.shouldRenderLiquid(stack)) {
            return;
        }
        int alpha = 255;
        if (stack.getFluid().isGaseous()) {
            alpha = (int)(RenderUtils.fluidDensityToAlpha(density) * 255.0);
        } else {
            int height = (int)((double)rect.h * density);
            rect.y += rect.h - height;
            rect.h = height;
        }
        mr tex = RenderUtils.prepareFluidRender(stack, alpha);
        CCRenderState.startDrawing(7);
        RenderUtils.renderLiquidQuad(new Vector3(rect.x, rect.y, 0.0), new Vector3(rect.x, rect.y + rect.h, 0.0), new Vector3(rect.x + rect.w, rect.y + rect.h, 0.0), new Vector3(rect.x + rect.w, rect.y, 0.0), tex, res);
        CCRenderState.draw();
        RenderUtils.postFluidRender();
    }

    public static void renderItemUniform(yd item) {
        IItemRenderer customRenderer = MinecraftForgeClient.getItemRenderer((yd)item, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.ENTITY);
        boolean is3D = customRenderer != null && customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.ENTITY, item, IItemRenderer.ItemRendererHelper.BLOCK_3D);
        boolean larger = false;
        if (item.b() instanceof zg && bfo.a((int)aqw.s[item.d].d())) {
            int renderType = aqw.s[item.d].d();
            larger = renderType != 1 && renderType != 19 && renderType != 12 && renderType != 2;
        } else if (is3D) {
            larger = true;
        }
        double d = 2.0;
        double d1 = 1.0 / d;
        if (larger) {
            GL11.glScaled((double)d, (double)d, (double)d);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        entityItem.a(item);
        uniformRenderItem.a(entityItem, 0.0, larger ? 0.09 : 0.06, 0.0, 0.0f, 0.0f);
        if (larger) {
            GL11.glScaled((double)d1, (double)d1, (double)d1);
        }
    }

    public static void renderBlock(Cuboid6 c, int sideMask, IFaceRenderer r) {
        double x1 = c.min.x;
        double x2 = c.max.x;
        double y1 = c.min.y;
        double y2 = c.max.y;
        double z1 = c.min.z;
        double z2 = c.max.z;
        double u1 = 0.0;
        double u2 = 0.0;
        double v1 = 0.0;
        double v2 = 0.0;
        if ((sideMask & 1) == 0) {
            u1 = x1;
            v1 = z1;
            u2 = x2;
            v2 = z2;
            face[0].set(x1, y1, z2, u1, v2);
            face[1].set(x1, y1, z1, u1, v1);
            face[2].set(x2, y1, z1, u2, v1);
            face[3].set(x2, y1, z2, u2, v2);
            r.renderFace(face, c.min.y > 0.0 ? 6 : 0);
        }
        if ((sideMask & 2) == 0) {
            u1 = x1 + 2.0;
            v1 = z1;
            u2 = x2 + 2.0;
            v2 = z2;
            face[0].set(x2, y2, z2, u2, v2);
            face[1].set(x2, y2, z1, u2, v1);
            face[2].set(x1, y2, z1, u1, v1);
            face[3].set(x1, y2, z2, u1, v2);
            r.renderFace(face, c.max.y < 1.0 ? 7 : 1);
        }
        if ((sideMask & 4) == 0) {
            u1 = 1.0 - x1 + 4.0;
            v1 = 1.0 - y2;
            u2 = 1.0 - x2 + 4.0;
            v2 = 1.0 - y1;
            face[0].set(x1, y1, z1, u1, v2);
            face[1].set(x1, y2, z1, u1, v1);
            face[2].set(x2, y2, z1, u2, v1);
            face[3].set(x2, y1, z1, u2, v2);
            r.renderFace(face, c.min.z > 0.0 ? 8 : 2);
        }
        if ((sideMask & 8) == 0) {
            u1 = x1 + 6.0;
            v1 = 1.0 - y2;
            u2 = x2 + 6.0;
            v2 = 1.0 - y1;
            face[0].set(x2, y1, z2, u2, v2);
            face[1].set(x2, y2, z2, u2, v1);
            face[2].set(x1, y2, z2, u1, v1);
            face[3].set(x1, y1, z2, u1, v2);
            r.renderFace(face, c.max.z < 1.0 ? 9 : 3);
        }
        if ((sideMask & 0x10) == 0) {
            u1 = z1 + 8.0;
            v1 = 1.0 - y2;
            u2 = z2 + 8.0;
            v2 = 1.0 - y1;
            face[0].set(x1, y1, z2, u2, v2);
            face[1].set(x1, y2, z2, u2, v1);
            face[2].set(x1, y2, z1, u1, v1);
            face[3].set(x1, y1, z1, u1, v2);
            r.renderFace(face, c.min.x > 0.0 ? 10 : 4);
        }
        if ((sideMask & 0x20) == 0) {
            u1 = 1.0 - z1 + 10.0;
            v1 = 1.0 - y2;
            u2 = 1.0 - z2 + 10.0;
            v2 = 1.0 - y1;
            face[0].set(x2, y1, z1, u1, v2);
            face[1].set(x2, y2, z1, u1, v1);
            face[2].set(x2, y2, z2, u2, v1);
            face[3].set(x2, y1, z2, u2, v2);
            r.renderFace(face, c.max.x < 1.0 ? 11 : 5);
        }
    }

    public static void renderBlock(Cuboid6 bounds, int sideMask, final Transformation t, final IUVTransformation u, final IVertexModifier m) {
        RenderUtils.renderBlock(bounds, sideMask, new IFaceRenderer(){
            boolean drawNormal = CCRenderState.useNormals();
            boolean computeNormal = this.drawNormal || m != null && m.needsNormals();
            Vector3 normal = new Vector3();
            Vertex5 vert;
            Vector3 vec = new Vector3();
            UV uv = new UV();

            @Override
            public void renderFace(Vertex5[] face, int side) {
                bfn tess = bfn.a;
                for (int i = 0; i < face.length; ++i) {
                    if (this.computeNormal) {
                        if (t != null) {
                            t.applyN(this.normal.set(Rotation.axes[side % 6]));
                        } else {
                            this.normal = Rotation.axes[side % 6];
                        }
                        if (this.drawNormal) {
                            tess.b((float)this.normal.x, (float)this.normal.y, (float)this.normal.z);
                        }
                    }
                    this.vert = face[i];
                    if (t != null) {
                        t.apply(this.vec.set(this.vert.vec));
                    } else {
                        this.vec = this.vert.vec;
                    }
                    if (u != null) {
                        u.transform(this.uv.set(this.vert.uv));
                    } else {
                        this.uv = this.vert.uv;
                    }
                    if (m != null) {
                        m.applyModifiers(null, tess, this.vec, this.uv, this.normal, i);
                    }
                    tess.a(this.vec.x, this.vec.y, this.vec.z, this.uv.u, this.uv.v);
                }
            }
        });
    }

    static {
        for (int i = 0; i < vectors.length; ++i) {
            RenderUtils.vectors[i] = new Vector3();
        }
        uniformRenderItem.a(bgi.a);
        entityItem = new sr(null);
        RenderUtils.entityItem.c = 0.0f;
        face = new Vertex5[]{new Vertex5(), new Vertex5(), new Vertex5(), new Vertex5()};
    }
}

