/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.colour.ColourRGBA;

public class CCRenderState {
    private static boolean useNormals;
    private static boolean hasBrightness;
    private static int brightness;
    private static boolean useModelColours;
    private static int colour;
    private static boolean hasColour;
    private static int alpha;
    private static boolean alphaOverride;

    public static void useNormals(boolean b) {
        useNormals = b;
    }

    public static boolean useNormals() {
        return useNormals;
    }

    public static void useModelColours(boolean b) {
        useModelColours = b;
    }

    public static boolean useModelColours() {
        return useModelColours;
    }

    public static void setAlpha(int a) {
        alpha = a;
        alphaOverride = true;
    }

    public static void clearAlphaOverride() {
        alphaOverride = false;
    }

    public static void vertexColour(int c) {
        if (alphaOverride) {
            CCRenderState.setColour(c & 0xFFFFFF00 | alpha);
        } else {
            CCRenderState.setColour(c);
        }
    }

    public static void vertexColour(int r, int g, int b, int a) {
        if (alphaOverride) {
            bfn.a.a(r, g, b, alpha);
        } else {
            bfn.a.a(r, g, b, a);
        }
    }

    public static void setBrightness(ace world, int x, int y, int z) {
        aqw block = aqw.s[world.a(x, y, z)];
        CCRenderState.setBrightness(block == null ? world.h(x, y, z, 0) : block.e(world, x, y, z));
        CCRenderState.setColour(-1);
    }

    public static void setBrightness(int b) {
        hasBrightness = true;
        brightness = b;
        bfn.a.c(brightness);
    }

    public static void setColourOpaque(int c) {
        CCRenderState.setColour(c << 8 | 0xFF);
    }

    public static void setColour(int c) {
        hasColour = true;
        colour = c;
        bfn.a.a(colour >> 24 & 0xFF, colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF);
    }

    public static void changeTexture(String texture) {
        CCRenderState.changeTexture(new bjl(texture));
    }

    public static void changeTexture(bjl texture) {
        ats.w().N.a(texture);
    }

    public static void apply() {
        if (hasBrightness) {
            bfn.a.c(brightness);
        }
        if (hasColour) {
            bfn.a.a(colour >> 24 & 0xFF, colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF);
        }
    }

    public static void reset() {
        hasBrightness = false;
        useModelColours = false;
        hasColour = false;
        alphaOverride = false;
    }

    public static void startDrawing(int i) {
        bfn.a.b(i);
        CCRenderState.apply();
    }

    public static void draw() {
        bfn.a.a();
    }

    public static void pullLightmap() {
        CCRenderState.setBrightness((int)blx.lastBrightnessY << 16 | (int)blx.lastBrightnessX);
    }

    public static void applyBrightnessTexCoords() {
        blx.a((int)blx.b, (float)(brightness & 0xFFFF), (float)(brightness >>> 16));
    }

    public static void glColour() {
        new ColourRGBA(colour).glColour();
    }
}

