/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.raytracer;

import codechicken.lib.math.MathHelper;
import codechicken.lib.raytracer.ExtendedMOP;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;

public class RayTracer {
    private Vector3 vec = new Vector3();
    private Vector3 vec2 = new Vector3();
    private Vector3 s_vec = new Vector3();
    private double s_dist;
    private int s_side;
    private IndexedCuboid6 c_cuboid;
    public static RayTracer instance = new RayTracer();

    private void traceSide(int side, Vector3 start, Vector3 end, Cuboid6 cuboid) {
        this.vec.set(start);
        Vector3 hit = null;
        switch (side) {
            case 0: {
                hit = this.vec.XZintercept(end, cuboid.min.y);
                break;
            }
            case 1: {
                hit = this.vec.XZintercept(end, cuboid.max.y);
                break;
            }
            case 2: {
                hit = this.vec.XYintercept(end, cuboid.min.z);
                break;
            }
            case 3: {
                hit = this.vec.XYintercept(end, cuboid.max.z);
                break;
            }
            case 4: {
                hit = this.vec.YZintercept(end, cuboid.min.x);
                break;
            }
            case 5: {
                hit = this.vec.YZintercept(end, cuboid.max.x);
            }
        }
        if (hit == null) {
            return;
        }
        switch (side) {
            case 0: 
            case 1: {
                if (MathHelper.between(cuboid.min.x, hit.x, cuboid.max.x) && MathHelper.between(cuboid.min.z, hit.z, cuboid.max.z)) break;
                return;
            }
            case 2: 
            case 3: {
                if (MathHelper.between(cuboid.min.x, hit.x, cuboid.max.x) && MathHelper.between(cuboid.min.y, hit.y, cuboid.max.y)) break;
                return;
            }
            case 4: 
            case 5: {
                if (MathHelper.between(cuboid.min.y, hit.y, cuboid.max.y) && MathHelper.between(cuboid.min.z, hit.z, cuboid.max.z)) break;
                return;
            }
        }
        double dist = this.vec2.set(hit).subtract(start).magSquared();
        if (dist < this.s_dist) {
            this.s_side = side;
            this.s_dist = dist;
            this.s_vec.set(this.vec);
        }
    }

    public asx rayTraceCuboid(Vector3 start, Vector3 end, Cuboid6 cuboid) {
        this.s_dist = Double.MAX_VALUE;
        this.s_side = -1;
        for (int i = 0; i < 6; ++i) {
            this.traceSide(i, start, end, cuboid);
        }
        if (this.s_side < 0) {
            return null;
        }
        asx mop = new asx(0, 0, 0, this.s_side, this.s_vec.toVec3D());
        mop.a = null;
        return mop;
    }

    public asx rayTraceCuboid(Vector3 start, Vector3 end, Cuboid6 cuboid, BlockCoord pos) {
        asx mop = this.rayTraceCuboid(start, end, cuboid);
        if (mop != null) {
            mop.a = asy.a;
            mop.b = pos.x;
            mop.c = pos.y;
            mop.d = pos.z;
        }
        return mop;
    }

    public asx rayTraceCuboid(Vector3 start, Vector3 end, Cuboid6 cuboid, nm e) {
        asx mop = this.rayTraceCuboid(start, end, cuboid);
        if (mop != null) {
            mop.a = asy.b;
            mop.g = e;
        }
        return mop;
    }

    public asx rayTraceCuboids(Vector3 start, Vector3 end, List<IndexedCuboid6> cuboids) {
        double c_dist = Double.MAX_VALUE;
        asx c_hit = null;
        for (IndexedCuboid6 cuboid : cuboids) {
            asx mop = this.rayTraceCuboid(start, end, cuboid);
            if (mop == null || !(this.s_dist < c_dist)) continue;
            mop = new ExtendedMOP(mop, cuboid.data);
            c_dist = this.s_dist;
            c_hit = mop;
            this.c_cuboid = cuboid;
        }
        return c_hit;
    }

    public asx rayTraceCuboids(Vector3 start, Vector3 end, List<IndexedCuboid6> cuboids, BlockCoord pos, aqw block) {
        asx mop = this.rayTraceCuboids(start, end, cuboids);
        if (mop != null) {
            mop.a = asy.a;
            mop.b = pos.x;
            mop.c = pos.y;
            mop.d = pos.z;
            if (block != null) {
                this.c_cuboid.add(new Vector3(-pos.x, -pos.y, -pos.z)).setBlockBounds(block);
            }
        }
        return mop;
    }

    public static asx retraceBlock(abv world, ue player, int x, int y, int z) {
        aqw block = aqw.s[world.a(x, y, z)];
        if (block == null) {
            return null;
        }
        asz headVec = asz.a((double)player.u, (double)(player.v + 1.62 - (double)player.N), (double)player.w);
        asz lookVec = player.j(1.0f);
        double reach = world.I ? RayTracer.getBlockReachDistance_client() : RayTracer.getBlockReachDistance_server((ju)player);
        asz endVec = headVec.c(lookVec.c * reach, lookVec.d * reach, lookVec.e * reach);
        return block.a(world, x, y, z, headVec, endVec);
    }

    private static double getBlockReachDistance_server(ju player) {
        return player.c.getBlockReachDistance();
    }

    @SideOnly(value=Side.CLIENT)
    private static double getBlockReachDistance_client() {
        return ats.w().c.d();
    }

    public static asx reTrace(abv world, ue player) {
        return RayTracer.reTrace(world, player, world.I ? RayTracer.getBlockReachDistance_client() : RayTracer.getBlockReachDistance_server((ju)player));
    }

    public static asx reTrace(abv world, ue player, double reach) {
        asz headVec = asz.a((double)player.u, (double)(player.v + 1.62 - (double)player.N), (double)player.w);
        asz lookVec = player.j(1.0f);
        asz endVec = headVec.c(lookVec.c * reach, lookVec.d * reach, lookVec.e * reach);
        return world.a(headVec, endVec, true, false);
    }
}

