/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.lang;

import cpw.mods.fml.common.registry.LanguageRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class LangUtil {
    public static LangUtil instance = new LangUtil(null);
    public String prefix;

    public LangUtil(String prefix) {
        this.prefix = prefix;
    }

    public static String translateG(String s, Object ... format) {
        return instance.translate(s, format);
    }

    public String translate(String s, Object ... format) {
        String ret;
        if (this.prefix != null && !s.startsWith(this.prefix + ".")) {
            s = this.prefix + "." + s;
        }
        if ((ret = LanguageRegistry.instance().getStringLocalization(s)).length() == 0) {
            ret = LanguageRegistry.instance().getStringLocalization(s, "en_US");
        }
        if (ret.length() == 0) {
            ret = bt.a((String)s);
        }
        if (ret.length() == 0) {
            return s;
        }
        if (format.length > 0) {
            ret = String.format(ret, format);
        }
        return ret;
    }

    public void addLangFile(InputStream resource, String lang) throws IOException {
        String read;
        LanguageRegistry reg = LanguageRegistry.instance();
        BufferedReader reader = new BufferedReader(new InputStreamReader(resource, "UTF-8"));
        while ((read = reader.readLine()) != null) {
            int equalIndex = read.indexOf(61);
            if (equalIndex == -1) continue;
            String key = read.substring(0, equalIndex);
            String value = read.substring(equalIndex + 1);
            if (this.prefix != null) {
                key = this.prefix + "." + key;
            }
            reg.addStringLocalization(key, lang, value);
        }
    }

    public static LangUtil loadLangDir(String domain) {
        return new LangUtil(domain).addLangDir(new bjl(domain, "lang"));
    }

    public LangUtil addLangDir(bjl dir) {
        bjm resManager = ats.w().K();
        for (bjz lang : ats.w().M().d()) {
            bjk langRes;
            String langID = lang.a();
            try {
                langRes = resManager.a(new bjl(dir.b(), dir.a() + '/' + langID + ".lang"));
            }
            catch (Exception e) {
                continue;
            }
            try {
                this.addLangFile(langRes.b(), langID);
            }
            catch (IOException e) {
                System.err.println("Failed to load lang resource. domain=" + this.prefix + ", resource=" + langRes);
                e.printStackTrace();
            }
        }
        return this;
    }

    public static void loadBaseLangDir(bjl dir) {
        instance.addLangDir(dir);
    }
}

