/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.data;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.BlockCoord;
import net.minecraftforge.fluids.FluidStack;

public class NBTDataWrapper
implements MCDataInput,
MCDataOutput {
    private cf readList;
    private int readTag = 0;
    private cf writeList;

    public NBTDataWrapper(cf input) {
        this.readList = input;
    }

    public NBTDataWrapper() {
        this.writeList = new cf();
    }

    public cf toTag() {
        return this.writeList;
    }

    @Override
    public NBTDataWrapper writeLong(long l) {
        this.writeList.a((ck)new cg(null, l));
        return this;
    }

    @Override
    public NBTDataWrapper writeInt(int i) {
        this.writeList.a((ck)new ce(null, i));
        return this;
    }

    @Override
    public NBTDataWrapper writeShort(int s) {
        this.writeList.a((ck)new ci(null, (short)s));
        return this;
    }

    @Override
    public NBTDataWrapper writeByte(int b) {
        this.writeList.a((ck)new bw(null, (byte)b));
        return this;
    }

    @Override
    public NBTDataWrapper writeDouble(double d) {
        this.writeList.a((ck)new ca(null, d));
        return this;
    }

    @Override
    public NBTDataWrapper writeFloat(float f) {
        this.writeList.a((ck)new cc(null, f));
        return this;
    }

    @Override
    public NBTDataWrapper writeBoolean(boolean b) {
        this.writeList.a((ck)new bw(null, (byte)(b ? 1 : 0)));
        return this;
    }

    @Override
    public NBTDataWrapper writeChar(char c) {
        this.writeList.a((ck)new ci(null, (short)c));
        return this;
    }

    @Override
    public NBTDataWrapper writeByteArray(byte[] array) {
        this.writeList.a((ck)new bv(null, array));
        return this;
    }

    @Override
    public NBTDataWrapper writeString(String s) {
        this.writeList.a((ck)new cj(null, s));
        return this;
    }

    @Override
    public NBTDataWrapper writeCoord(int x, int y, int z) {
        this.writeInt(x);
        this.writeInt(y);
        this.writeInt(z);
        return this;
    }

    @Override
    public NBTDataWrapper writeCoord(BlockCoord coord) {
        this.writeCoord(coord.x, coord.y, coord.z);
        return this;
    }

    @Override
    public NBTDataWrapper writeNBTTagCompound(bx tag) {
        this.writeList.a((ck)tag);
        return this;
    }

    @Override
    public NBTDataWrapper writeItemStack(yd stack) {
        this.writeList.a((ck)stack.b(new bx()));
        return this;
    }

    @Override
    public NBTDataWrapper writeFluidStack(FluidStack liquid) {
        this.writeList.a((ck)liquid.writeToNBT(new bx()));
        return this;
    }

    @Override
    public long readLong() {
        return ((cg)this.readTag()).a;
    }

    @Override
    public int readInt() {
        return ((ce)this.readTag()).a;
    }

    @Override
    public short readShort() {
        return ((ci)this.readTag()).a;
    }

    @Override
    public int readUShort() {
        return ((ci)this.readTag()).a & 0xFFFF;
    }

    @Override
    public byte readByte() {
        return ((bw)this.readTag()).a;
    }

    @Override
    public int readUByte() {
        return ((bw)this.readTag()).a & 0xFF;
    }

    @Override
    public double readDouble() {
        return ((ca)this.readTag()).a;
    }

    @Override
    public float readFloat() {
        return ((cc)this.readTag()).a;
    }

    @Override
    public boolean readBoolean() {
        return ((bw)this.readTag()).a != 0;
    }

    @Override
    public char readChar() {
        return (char)((ci)this.readTag()).a;
    }

    @Override
    public byte[] readByteArray(int length) {
        return ((bv)this.readTag()).a;
    }

    @Override
    public String readString() {
        return ((cj)this.readTag()).a;
    }

    @Override
    public BlockCoord readCoord() {
        return new BlockCoord(this.readInt(), this.readInt(), this.readInt());
    }

    @Override
    public bx readNBTTagCompound() {
        return (bx)this.readTag();
    }

    @Override
    public yd readItemStack() {
        return yd.a((bx)this.readNBTTagCompound());
    }

    @Override
    public FluidStack readFluidStack() {
        return FluidStack.loadFluidStackFromNBT((bx)this.readNBTTagCompound());
    }

    private ck readTag() {
        return this.readList.b(this.readTag++);
    }
}

