/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.data;

import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.BlockCoord;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraftforge.fluids.FluidStack;

public class MCOutputStreamWrapper
implements MCDataOutput {
    public DataOutputStream dataout;

    public MCOutputStreamWrapper(DataOutputStream out) {
        this.dataout = out;
    }

    @Override
    public MCOutputStreamWrapper writeBoolean(boolean b) {
        try {
            this.dataout.writeBoolean(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeByte(int b) {
        try {
            this.dataout.writeByte(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeShort(int s) {
        try {
            this.dataout.writeShort(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeInt(int i) {
        try {
            this.dataout.writeInt(i);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeFloat(float f) {
        try {
            this.dataout.writeFloat(f);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeDouble(double d) {
        try {
            this.dataout.writeDouble(d);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeLong(long l) {
        try {
            this.dataout.writeLong(l);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeChar(char c) {
        try {
            this.dataout.writeChar(c);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeByteArray(byte[] barray) {
        try {
            this.dataout.write(barray);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeCoord(int x, int y, int z) {
        this.writeInt(x);
        this.writeInt(y);
        this.writeInt(z);
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeCoord(BlockCoord coord) {
        this.writeInt(coord.x);
        this.writeInt(coord.y);
        this.writeInt(coord.z);
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeString(String s) {
        try {
            if (s.length() > 65535) {
                throw new IOException("String length: " + s.length() + "too long.");
            }
            this.dataout.writeShort(s.length());
            this.dataout.writeChars(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeItemStack(yd stack) {
        this.writeItemStack(stack, false);
        return this;
    }

    public MCOutputStreamWrapper writeItemStack(yd stack, boolean large) {
        if (stack == null) {
            this.writeShort(-1);
        } else {
            this.writeShort(stack.d);
            if (large) {
                this.writeInt(stack.b);
            } else {
                this.writeByte(stack.b);
            }
            this.writeShort(stack.k());
            this.writeNBTTagCompound(stack.e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeNBTTagCompound(bx compound) {
        try {
            if (compound == null) {
                this.writeShort(-1);
            } else {
                byte[] bytes = ch.a((bx)compound);
                this.writeShort((short)bytes.length);
                this.writeByteArray(bytes);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public MCOutputStreamWrapper writeFluidStack(FluidStack fluid) {
        if (fluid == null) {
            this.writeShort(-1);
        } else {
            this.writeShort(fluid.fluidID);
            this.writeInt(fluid.amount);
            this.writeNBTTagCompound(fluid.tag);
        }
        return this;
    }
}

