/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.triggers;

import buildcraft.api.gates.ITriggerParameter;
import buildcraft.core.triggers.BCTrigger;
import buildcraft.transport.ITriggerPipe;
import buildcraft.transport.Pipe;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.util.Icon;

public class TriggerRedstoneInput
extends BCTrigger
implements ITriggerPipe {
    boolean active;
    @SideOnly(value=Side.CLIENT)
    private Icon iconActive;
    @SideOnly(value=Side.CLIENT)
    private Icon iconInactive;

    public TriggerRedstoneInput(int legacyId, boolean active) {
        super(legacyId, active ? "buildcraft.redtone.input.active" : "buildcraft.redtone.input.inactive");
        this.active = active;
    }

    @Override
    public String getDescription() {
        if (this.active) {
            return "Redstone Signal On";
        }
        return "Redstone Signal Off";
    }

    @Override
    public boolean isTriggerActive(Pipe pipe, ITriggerParameter parameter) {
        if (this.active) {
            return this.isBeingPowered(pipe);
        }
        return !this.isBeingPowered(pipe);
    }

    private boolean isBeingPowered(Pipe pipe) {
        return pipe.container.field_70331_k.func_72864_z(pipe.container.field_70329_l, pipe.container.field_70330_m, pipe.container.field_70327_n);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIcon() {
        if (this.active) {
            return this.iconActive;
        }
        return this.iconInactive;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IconRegister iconRegister) {
        this.iconActive = iconRegister.func_94245_a("buildcraft:triggers/trigger_redstoneinput_active");
        this.iconInactive = iconRegister.func_94245_a("buildcraft:triggers/trigger_redstoneinput_inactive");
    }
}

