/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.triggers;

import buildcraft.api.gates.ITriggerParameter;
import buildcraft.core.triggers.BCTrigger;
import buildcraft.core.utils.StringUtils;
import buildcraft.transport.ITriggerPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.pipes.PipePowerWood;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class TriggerPipeContents
extends BCTrigger
implements ITriggerPipe {
    Kind kind;

    public TriggerPipeContents(int id, Kind kind) {
        super(id, kind.tag);
        this.kind = kind;
    }

    @Override
    public boolean hasParameter() {
        switch (this.kind) {
            case ContainsItems: 
            case ContainsFluids: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        switch (this.kind) {
            case Empty: {
                return StringUtils.localize("gate.pipe.empty");
            }
            case ContainsItems: {
                return StringUtils.localize("gate.pipe.containsItems");
            }
            case ContainsFluids: {
                return StringUtils.localize("gate.pipe.containsFluids");
            }
            case ContainsEnergy: {
                return StringUtils.localize("gate.pipe.containsEnergy");
            }
            case RequestsEnergy: {
                return StringUtils.localize("gate.pipe.requestsEnergy");
            }
            case TooMuchEnergy: {
                return StringUtils.localize("gate.pipe.tooMuchEnergy");
            }
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isTriggerActive(Pipe pipe, ITriggerParameter parameter) {
        if (pipe.transport instanceof PipeTransportItems) {
            PipeTransportItems transportItems = (PipeTransportItems)pipe.transport;
            if (this.kind == Kind.Empty) {
                return transportItems.items.isEmpty();
            }
            if (this.kind != Kind.ContainsItems) return false;
            if (parameter != null && parameter.getItem() != null) {
                TravelingItem item;
                Iterator i$ = transportItems.items.iterator();
                do {
                    if (!i$.hasNext()) return false;
                    item = (TravelingItem)i$.next();
                } while (item.getItemStack().field_77993_c != parameter.getItem().field_77993_c || item.getItemStack().func_77960_j() != parameter.getItem().func_77960_j());
                return true;
            }
            if (transportItems.items.isEmpty()) return false;
            return true;
        }
        if (pipe.transport instanceof PipeTransportFluids) {
            PipeTransportFluids transportFluids = (PipeTransportFluids)pipe.transport;
            FluidStack searchedFluid = null;
            if (parameter != null && parameter.getItem() != null) {
                searchedFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)parameter.getItem());
            }
            if (this.kind == Kind.Empty) {
                FluidTankInfo[] arr$ = transportFluids.getTankInfo(ForgeDirection.UNKNOWN);
                int len$ = arr$.length;
                int i$ = 0;
                while (i$ < len$) {
                    FluidTankInfo b = arr$[i$];
                    if (b.fluid != null && b.fluid.amount != 0) {
                        return false;
                    }
                    ++i$;
                }
                return true;
            }
            FluidTankInfo[] arr$ = transportFluids.getTankInfo(ForgeDirection.UNKNOWN);
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                FluidTankInfo b = arr$[i$];
                if (b.fluid != null && b.fluid.amount != 0) {
                    if (searchedFluid == null) return true;
                    if (searchedFluid.isFluidEqual(b.fluid)) {
                        return true;
                    }
                }
                ++i$;
            }
            return false;
        }
        if (!(pipe.transport instanceof PipeTransportPower)) return false;
        PipeTransportPower transportPower = (PipeTransportPower)pipe.transport;
        switch (this.kind) {
            case Empty: {
                float[] arr$ = transportPower.displayPower;
                int len$ = arr$.length;
                int i$ = 0;
                while (i$ < len$) {
                    double s = arr$[i$];
                    if (s > 0.0) {
                        return false;
                    }
                    ++i$;
                }
                return true;
            }
            case ContainsEnergy: {
                float[] arr$ = transportPower.displayPower;
                int len$ = arr$.length;
                int i$ = 0;
                while (i$ < len$) {
                    double s = arr$[i$];
                    if (s > 0.0) {
                        return true;
                    }
                    ++i$;
                }
                return false;
            }
            case RequestsEnergy: {
                PipePowerWood wood = (PipePowerWood)pipe;
                return wood.requestsPower();
            }
        }
        return transportPower.isOverloaded();
    }

    @Override
    public Icon getIcon() {
        return this.kind.icon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IconRegister iconRegister) {
        Kind.Empty.icon = iconRegister.func_94245_a("buildcraft:triggers/trigger_pipecontents_empty");
        Kind.ContainsItems.icon = iconRegister.func_94245_a("buildcraft:triggers/trigger_pipecontents_containsitems");
        Kind.ContainsFluids.icon = iconRegister.func_94245_a("buildcraft:triggers/trigger_pipecontents_containsliquid");
        Kind.ContainsEnergy.icon = iconRegister.func_94245_a("buildcraft:triggers/trigger_pipecontents_containsenergy");
        Kind.RequestsEnergy.icon = iconRegister.func_94245_a("buildcraft:triggers/trigger_pipecontents_requestsenergy");
        Kind.TooMuchEnergy.icon = iconRegister.func_94245_a("buildcraft:triggers/trigger_pipecontents_toomuchenergy");
    }

    public static enum Kind {
        Empty("buildcraft.pipe.contents.empty"),
        ContainsItems("buildcraft.pipe.contents.containsItems"),
        ContainsFluids("buildcraft.pipe.contents.containsFluids"),
        ContainsEnergy("buildcraft.pipe.contents.containsEnergy"),
        RequestsEnergy("buildcraft.pipe.contents.requestsEnergy"),
        TooMuchEnergy("buildcraft.pipe.contents.tooMuchEnergy");

        private Icon icon;
        public final String tag;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private Kind() {
            void tag;
            this.tag = tag;
        }
    }
}

