/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.triggers;

import buildcraft.api.gates.ITriggerParameter;
import buildcraft.core.triggers.BCTrigger;
import buildcraft.transport.TileFilteredBuffer;
import java.util.Locale;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class TriggerFilteredBufferInventoryLevel
extends BCTrigger {
    public State state;

    public TriggerFilteredBufferInventoryLevel(int legacyId, State state) {
        super(legacyId, "buildcraft.filteredBuffer." + state.name().toLowerCase(Locale.ENGLISH));
        this.state = state;
    }

    @Override
    public boolean hasParameter() {
        return true;
    }

    @Override
    public String getDescription() {
        switch (this.state) {
            case Below25: {
                return "Contains < 25%";
            }
            case Below50: {
                return "Contains < 50%";
            }
        }
        return "Contains < 75%";
    }

    @Override
    public boolean isTriggerActive(ForgeDirection side, TileEntity tile, ITriggerParameter parameter) {
        if (tile instanceof TileFilteredBuffer) {
            if (parameter == null) {
                return false;
            }
            TileFilteredBuffer filteredBuffer = (TileFilteredBuffer)tile;
            ItemStack searchStack = parameter.getItem();
            int foundStackCount = 0;
            int foundItemCount = 0;
            IInventory filters = filteredBuffer.getFilters();
            for (int i = 0; i < filters.func_70302_i_(); ++i) {
                ItemStack filterStack = filters.func_70301_a(i);
                if (filterStack == null || !filterStack.func_77969_a(searchStack)) continue;
                ItemStack foundStack = filteredBuffer.func_70301_a(i);
                if (foundStack != null) {
                    foundItemCount += foundStack.field_77994_a;
                }
                ++foundStackCount;
            }
            if (foundStackCount > 0) {
                float percentage = (float)foundItemCount / ((float)foundStackCount * (float)searchStack.func_77976_d());
                switch (this.state) {
                    case Below25: {
                        return percentage < 0.25f;
                    }
                    case Below50: {
                        return percentage < 0.5f;
                    }
                }
                return percentage < 0.75f;
            }
        }
        return false;
    }

    @Override
    public int getIconIndex() {
        switch (this.state) {
            case Below25: {
                return 33;
            }
            case Below50: {
                return 34;
            }
        }
        return 35;
    }

    public static enum State {
        Below25,
        Below50,
        Below75;

    }
}

