/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.core.render.FluidRenderer;
import buildcraft.core.render.RenderEntityBlock;
import buildcraft.core.utils.EnumColor;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TravelingItem;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class RenderPipe
extends TileEntitySpecialRenderer {
    private static final int LIQUID_STAGES = 40;
    private static final int MAX_ITEMS_TO_RENDER = 10;
    private final EntityItem dummyEntityItem = new EntityItem(null);
    private final RenderItem customRenderItem;
    private final HashMap displayFluidLists = Maps.newHashMap();
    private final int[] angleY = new int[]{0, 0, 270, 90, 0, 180};
    private final int[] angleZ = new int[]{90, 270, 0, 0, 0, 0};
    private static final int POWER_STAGES = 100;
    public int[] displayPowerList = new int[100];
    public int[] displayPowerListOverload = new int[100];
    boolean initialized = false;

    public RenderPipe() {
        this.customRenderItem = new RenderItem(){

            public boolean shouldBob() {
                return false;
            }

            public boolean shouldSpreadItems() {
                return false;
            }
        };
        this.customRenderItem.func_76976_a(RenderManager.field_78727_a);
    }

    private DisplayFluidList getDisplayFluidLists(int liquidId, World world) {
        if (this.displayFluidLists.containsKey(liquidId)) {
            return (DisplayFluidList)this.displayFluidLists.get(liquidId);
        }
        DisplayFluidList d = new DisplayFluidList();
        this.displayFluidLists.put(liquidId, d);
        RenderEntityBlock.BlockInterface block = new RenderEntityBlock.BlockInterface();
        Fluid fluid = FluidRegistry.getFluid((int)liquidId);
        block.baseBlock = fluid.getBlockID() > 0 ? Block.field_71973_m[fluid.getBlockID()] : Block.field_71943_B;
        block.texture = fluid.getStillIcon();
        float size = 0.5f;
        for (int s = 0; s < 40; ++s) {
            float ratio = (float)s / 40.0f;
            d.sideHorizontal[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.sideHorizontal[s], (int)4864);
            block.minX = 0.0;
            block.minZ = 0.26f;
            block.maxX = block.minX + (double)(size / 2.0f) + (double)0.01f;
            block.maxZ = block.minZ + (double)size - (double)0.02f;
            block.minY = 0.26f;
            block.maxY = block.minY + (double)((size - 0.02f) * ratio);
            RenderEntityBlock.INSTANCE.renderBlock(block, (IBlockAccess)world, 0, 0, 0, false, true);
            GL11.glEndList();
            d.sideVertical[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.sideVertical[s], (int)4864);
            block.minY = 0.74;
            block.maxY = 1.0;
            block.minX = 0.5 - ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.maxX = 0.5 + ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.minZ = 0.5 - ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.maxZ = 0.5 + ((double)(size / 2.0f) - 0.01) * (double)ratio;
            RenderEntityBlock.INSTANCE.renderBlock(block, (IBlockAccess)world, 0, 0, 0, false, true);
            GL11.glEndList();
            d.centerHorizontal[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.centerHorizontal[s], (int)4864);
            block.minX = 0.26;
            block.minZ = 0.26;
            block.maxX = block.minX + (double)size - 0.02;
            block.maxZ = block.minZ + (double)size - 0.02;
            block.minY = 0.26;
            block.maxY = block.minY + (double)((size - 0.02f) * ratio);
            RenderEntityBlock.INSTANCE.renderBlock(block, (IBlockAccess)world, 0, 0, 0, false, true);
            GL11.glEndList();
            d.centerVertical[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.centerVertical[s], (int)4864);
            block.minY = 0.26;
            block.maxY = 0.74;
            block.minX = 0.5 - ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.maxX = 0.5 + ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.minZ = 0.5 - ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.maxZ = 0.5 + ((double)(size / 2.0f) - 0.02) * (double)ratio;
            RenderEntityBlock.INSTANCE.renderBlock(block, (IBlockAccess)world, 0, 0, 0, false, true);
            GL11.glEndList();
        }
        return d;
    }

    private void initializeDisplayPowerList(World world) {
        float unit;
        float minSize;
        int s;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        RenderEntityBlock.BlockInterface block = new RenderEntityBlock.BlockInterface();
        block.texture = BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.Power_Normal.ordinal());
        float size = 0.5f;
        for (s = 0; s < 100; ++s) {
            this.displayPowerList[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)this.displayPowerList[s], (int)4864);
            minSize = 0.005f;
            unit = (size - minSize) / 2.0f / 100.0f;
            block.minY = 0.5 - (double)(minSize / 2.0f) - (double)(unit * (float)s);
            block.maxY = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            block.minZ = 0.5 - (double)(minSize / 2.0f) - (double)(unit * (float)s);
            block.maxZ = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            block.minX = 0.0;
            block.maxX = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            RenderEntityBlock.INSTANCE.renderBlock(block, (IBlockAccess)world, 0, 0, 0, false, true);
            GL11.glEndList();
        }
        block.texture = BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.Power_Overload.ordinal());
        size = 0.5f;
        for (s = 0; s < 100; ++s) {
            this.displayPowerListOverload[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)this.displayPowerListOverload[s], (int)4864);
            minSize = 0.005f;
            unit = (size - minSize) / 2.0f / 100.0f;
            block.minY = 0.5 - (double)(minSize / 2.0f) - (double)(unit * (float)s);
            block.maxY = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            block.minZ = 0.5 - (double)(minSize / 2.0f) - (double)(unit * (float)s);
            block.maxZ = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            block.minX = 0.0;
            block.maxX = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            RenderEntityBlock.INSTANCE.renderBlock(block, (IBlockAccess)world, 0, 0, 0, false, true);
            GL11.glEndList();
        }
    }

    public void func_76894_a(TileEntity tileentity, double x, double y, double z, float f) {
        if (BuildCraftCore.render == BuildCraftCore.RenderMode.NoDynamic) {
            return;
        }
        TileGenericPipe pipe = (TileGenericPipe)tileentity;
        if (pipe.pipe == null) {
            return;
        }
        switch (pipe.getPipeType()) {
            case ITEM: {
                this.renderSolids(pipe.pipe, x, y, z);
                break;
            }
            case FLUID: {
                this.renderFluids(pipe.pipe, x, y, z);
                break;
            }
            case POWER: {
                this.renderPower(pipe.pipe, x, y, z);
            }
        }
    }

    private void renderPower(Pipe pipe, double x, double y, double z) {
        this.initializeDisplayPowerList(pipe.container.field_70331_k);
        PipeTransportPower pow = (PipeTransportPower)pipe.transport;
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        this.func_110628_a(TextureMap.field_110575_b);
        int[] displayList = pow.overload > 0 ? this.displayPowerListOverload : this.displayPowerList;
        for (int i = 0; i < 6; ++i) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            GL11.glRotatef((float)this.angleY[i], (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.angleZ[i], (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            if ((double)pow.clientDisplayPower[i] >= 1.0) {
                short stage = pow.clientDisplayPower[i];
                if (stage < displayList.length) {
                    GL11.glCallList((int)displayList[stage]);
                } else {
                    GL11.glCallList((int)displayList[displayList.length - 1]);
                }
            }
            GL11.glPopMatrix();
        }
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    private void renderFluids(Pipe pipe, double x, double y, double z) {
        DisplayFluidList d;
        PipeTransportFluids trans = (PipeTransportFluids)pipe.transport;
        boolean needsRender = false;
        for (int i = 0; i < 7; ++i) {
            FluidStack fluidStack = trans.renderCache[i];
            if (fluidStack == null || fluidStack.amount <= 0) continue;
            needsRender = true;
            break;
        }
        if (!needsRender) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        boolean sides = false;
        boolean above = false;
        for (int i = 0; i < 6; ++i) {
            DisplayFluidList d2;
            FluidStack fluidStack = trans.renderCache[i];
            if (fluidStack == null || fluidStack.amount <= 0 || (d2 = this.getListFromBuffer(fluidStack, pipe.container.field_70331_k)) == null) continue;
            int stage = (int)((float)fluidStack.amount / (float)trans.getCapacity() * 39.0f);
            GL11.glPushMatrix();
            int list = 0;
            switch (ForgeDirection.VALID_DIRECTIONS[i]) {
                case UP: {
                    above = true;
                    list = d2.sideVertical[stage];
                    break;
                }
                case DOWN: {
                    GL11.glTranslatef((float)0.0f, (float)-0.75f, (float)0.0f);
                    list = d2.sideVertical[stage];
                    break;
                }
                case EAST: 
                case WEST: 
                case SOUTH: 
                case NORTH: {
                    sides = true;
                    GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
                    GL11.glRotatef((float)this.angleY[i], (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)this.angleZ[i], (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-0.5f);
                    list = d2.sideHorizontal[stage];
                    break;
                }
            }
            this.func_110628_a(TextureMap.field_110575_b);
            FluidRenderer.setColorForFluidStack(fluidStack);
            GL11.glCallList((int)list);
            GL11.glPopMatrix();
        }
        FluidStack fluidStack = trans.renderCache[ForgeDirection.UNKNOWN.ordinal()];
        if (fluidStack != null && fluidStack.amount > 0 && (d = this.getListFromBuffer(fluidStack, pipe.container.field_70331_k)) != null) {
            int stage = (int)((float)fluidStack.amount / (float)trans.getCapacity() * 39.0f);
            this.func_110628_a(TextureMap.field_110575_b);
            FluidRenderer.setColorForFluidStack(fluidStack);
            if (above) {
                GL11.glCallList((int)d.centerVertical[stage]);
            }
            if (!above || sides) {
                GL11.glCallList((int)d.centerHorizontal[stage]);
            }
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private DisplayFluidList getListFromBuffer(FluidStack stack, World world) {
        int liquidId = stack.fluidID;
        if (liquidId == 0) {
            return null;
        }
        return this.getDisplayFluidLists(liquidId, world);
    }

    private void renderSolids(Pipe pipe, double x, double y, double z) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        float light = pipe.container.field_70331_k.func_72801_o(pipe.container.field_70329_l, pipe.container.field_70330_m, pipe.container.field_70327_n);
        int count = 0;
        Iterator i$ = ((PipeTransportItems)pipe.transport).items.iterator();
        while (i$.hasNext()) {
            TravelingItem item = (TravelingItem)i$.next();
            if (count >= 10) break;
            this.doRenderItem(item, x + item.xCoord - (double)pipe.container.field_70329_l, y + item.yCoord - (double)pipe.container.field_70330_m, z + item.zCoord - (double)pipe.container.field_70327_n, light, item.color);
            ++count;
        }
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    public void doRenderItem(TravelingItem travellingItem, double x, double y, double z, float light, EnumColor color) {
        if (travellingItem == null || travellingItem.getItemStack() == null) {
            return;
        }
        float renderScale = 0.7f;
        ItemStack itemstack = travellingItem.getItemStack();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.0f);
        GL11.glScalef((float)renderScale, (float)renderScale, (float)renderScale);
        this.dummyEntityItem.func_92058_a(itemstack);
        this.customRenderItem.func_77014_a(this.dummyEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        if (color != null) {
            this.func_110628_a(TextureMap.field_110575_b);
            RenderEntityBlock.BlockInterface block = new RenderEntityBlock.BlockInterface();
            block.texture = PipeIconProvider.TYPE.ItemBox.getIcon();
            float pix = 0.0625f;
            float min = -4.0f * pix;
            float max = 4.0f * pix;
            block.minY = min;
            block.maxY = max;
            block.minZ = min;
            block.maxZ = max;
            block.minX = min;
            block.maxX = max;
            int cHex = color.getLightHex();
            float r = (float)(cHex >> 16 & 0xFF) / 255.0f;
            float g = (float)(cHex >> 8 & 0xFF) / 255.0f;
            float b = (float)(cHex & 0xFF) / 255.0f;
            GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
            RenderEntityBlock.INSTANCE.renderBlock(block, null, 0, 0, 0, false, true);
        }
        GL11.glPopMatrix();
    }

    private class DisplayFluidList {
        public int[] sideHorizontal = new int[40];
        public int[] sideVertical = new int[40];
        public int[] centerHorizontal = new int[40];
        public int[] centerVertical = new int[40];

        private DisplayFluidList() {
        }
    }
}

