/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.transport.IPipe;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.IPipeRenderState;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeRenderState;
import buildcraft.transport.TransportProxy;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public class PipeWorldRenderer
implements ISimpleBlockRenderingHandler {
    public static final float facadeThickness = 0.0625f;

    private void mirrorY(float[][] targetArray) {
        float temp = targetArray[1][0];
        targetArray[1][0] = (targetArray[1][1] - 0.5f) * -1.0f + 0.5f;
        targetArray[1][1] = (temp - 0.5f) * -1.0f + 0.5f;
    }

    private void rotate(float[][] targetArray) {
        for (int i = 0; i < 2; ++i) {
            float temp = targetArray[2][i];
            targetArray[2][i] = targetArray[1][i];
            targetArray[1][i] = targetArray[0][i];
            targetArray[0][i] = temp;
        }
    }

    private void transform(float[][] targetArray, ForgeDirection direction) {
        if ((direction.ordinal() & 1) == 1) {
            this.mirrorY(targetArray);
        }
        for (int i = 0; i < direction.ordinal() >> 1; ++i) {
            this.rotate(targetArray);
        }
    }

    private float[][] deepClone(float[][] source) {
        float[][] target = (float[][])source.clone();
        for (int i = 0; i < target.length; ++i) {
            target[i] = (float[])source[i].clone();
        }
        return target;
    }

    private void renderAllFaceExeptAxe(RenderBlocks renderblocks, BlockGenericPipe block, Icon icon, int x, int y, int z, char axe) {
        float minX = (float)renderblocks.field_83021_g;
        float minY = (float)renderblocks.field_83027_i;
        float minZ = (float)renderblocks.field_83025_k;
        float maxX = (float)renderblocks.field_83026_h;
        float maxY = (float)renderblocks.field_83024_j;
        float maxZ = (float)renderblocks.field_83022_l;
        if (axe != 'x') {
            this.renderTwoWayXFace(renderblocks, block, icon, x, y, z, minY, minZ, maxY, maxZ, minX);
            this.renderTwoWayXFace(renderblocks, block, icon, x, y, z, minY, minZ, maxY, maxZ, maxX);
        }
        if (axe != 'y') {
            this.renderTwoWayYFace(renderblocks, block, icon, x, y, z, minX, minZ, maxX, maxZ, minY);
            this.renderTwoWayYFace(renderblocks, block, icon, x, y, z, minX, minZ, maxX, maxZ, maxY);
        }
        if (axe != 'z') {
            this.renderTwoWayZFace(renderblocks, block, icon, x, y, z, minX, minY, maxX, maxY, minZ);
            this.renderTwoWayZFace(renderblocks, block, icon, x, y, z, minX, minY, maxX, maxY, maxZ);
        }
    }

    private void renderTwoWayXFace(RenderBlocks renderblocks, BlockGenericPipe block, Icon icon, int xCoord, int yCoord, int zCoord, float minY, float minZ, float maxY, float maxZ, float x) {
        renderblocks.func_83020_a((double)x, (double)minY, (double)minZ, (double)x, (double)maxY, (double)maxZ);
        block.setRenderAxis('x');
        renderblocks.func_78570_q((Block)block, xCoord, yCoord, zCoord);
        block.setRenderAxis('a');
    }

    private void renderTwoWayYFace(RenderBlocks renderblocks, BlockGenericPipe block, Icon icon, int xCoord, int yCoord, int zCoord, float minX, float minZ, float maxX, float maxZ, float y) {
        renderblocks.func_83020_a((double)minX, (double)y, (double)minZ, (double)maxX, (double)y, (double)maxZ);
        block.setRenderAxis('y');
        renderblocks.func_78570_q((Block)block, xCoord, yCoord, zCoord);
        block.setRenderAxis('a');
    }

    private void renderTwoWayZFace(RenderBlocks renderblocks, BlockGenericPipe block, Icon icon, int xCoord, int yCoord, int zCoord, float minX, float minY, float maxX, float maxY, float z) {
        renderblocks.func_83020_a((double)minX, (double)minY, (double)z, (double)maxX, (double)maxY, (double)z);
        block.setRenderAxis('z');
        renderblocks.func_78570_q((Block)block, xCoord, yCoord, zCoord);
        block.setRenderAxis('a');
    }

    public void renderPipe(RenderBlocks renderblocks, IBlockAccess iblockaccess, BlockGenericPipe block, IPipeRenderState renderState, int x, int y, int z) {
        float minSize = 0.25f;
        float maxSize = 0.75f;
        PipeRenderState state = renderState.getRenderState();
        IIconProvider icons = renderState.getPipeIcons();
        if (icons == null) {
            return;
        }
        boolean west = false;
        boolean east = false;
        boolean down = false;
        boolean up = false;
        boolean north = false;
        boolean south = false;
        if (state.pipeConnectionMatrix.isConnected(ForgeDirection.WEST)) {
            state.currentTexture = icons.getIcon(state.textureMatrix.getTextureIndex(ForgeDirection.WEST));
            renderblocks.func_83020_a(0.0, (double)minSize, (double)minSize, (double)minSize, (double)maxSize, (double)maxSize);
            this.renderAllFaceExeptAxe(renderblocks, block, state.currentTexture, x, y, z, 'x');
            west = true;
        }
        if (state.pipeConnectionMatrix.isConnected(ForgeDirection.EAST)) {
            state.currentTexture = icons.getIcon(state.textureMatrix.getTextureIndex(ForgeDirection.EAST));
            renderblocks.func_83020_a((double)maxSize, (double)minSize, (double)minSize, 1.0, (double)maxSize, (double)maxSize);
            this.renderAllFaceExeptAxe(renderblocks, block, state.currentTexture, x, y, z, 'x');
            east = true;
        }
        if (state.pipeConnectionMatrix.isConnected(ForgeDirection.DOWN)) {
            state.currentTexture = icons.getIcon(state.textureMatrix.getTextureIndex(ForgeDirection.DOWN));
            renderblocks.func_83020_a((double)minSize, 0.0, (double)minSize, (double)maxSize, (double)minSize, (double)maxSize);
            this.renderAllFaceExeptAxe(renderblocks, block, state.currentTexture, x, y, z, 'y');
            down = true;
        }
        if (state.pipeConnectionMatrix.isConnected(ForgeDirection.UP)) {
            state.currentTexture = icons.getIcon(state.textureMatrix.getTextureIndex(ForgeDirection.UP));
            renderblocks.func_83020_a((double)minSize, (double)maxSize, (double)minSize, (double)maxSize, 1.0, (double)maxSize);
            this.renderAllFaceExeptAxe(renderblocks, block, state.currentTexture, x, y, z, 'y');
            up = true;
        }
        if (state.pipeConnectionMatrix.isConnected(ForgeDirection.NORTH)) {
            state.currentTexture = icons.getIcon(state.textureMatrix.getTextureIndex(ForgeDirection.NORTH));
            renderblocks.func_83020_a((double)minSize, (double)minSize, 0.0, (double)maxSize, (double)maxSize, (double)minSize);
            this.renderAllFaceExeptAxe(renderblocks, block, state.currentTexture, x, y, z, 'z');
            north = true;
        }
        if (state.pipeConnectionMatrix.isConnected(ForgeDirection.SOUTH)) {
            state.currentTexture = icons.getIcon(state.textureMatrix.getTextureIndex(ForgeDirection.SOUTH));
            renderblocks.func_83020_a((double)minSize, (double)minSize, (double)maxSize, (double)maxSize, (double)maxSize, 1.0);
            this.renderAllFaceExeptAxe(renderblocks, block, state.currentTexture, x, y, z, 'z');
            south = true;
        }
        state.currentTexture = icons.getIcon(state.textureMatrix.getTextureIndex(ForgeDirection.UNKNOWN));
        renderblocks.func_83020_a((double)minSize, (double)minSize, (double)minSize, (double)maxSize, (double)maxSize, (double)maxSize);
        if (!west) {
            this.renderTwoWayXFace(renderblocks, block, state.currentTexture, x, y, z, minSize, minSize, maxSize, maxSize, minSize);
        }
        if (!east) {
            this.renderTwoWayXFace(renderblocks, block, state.currentTexture, x, y, z, minSize, minSize, maxSize, maxSize, maxSize);
        }
        if (!down) {
            this.renderTwoWayYFace(renderblocks, block, state.currentTexture, x, y, z, minSize, minSize, maxSize, maxSize, minSize);
        }
        if (!up) {
            this.renderTwoWayYFace(renderblocks, block, state.currentTexture, x, y, z, minSize, minSize, maxSize, maxSize, maxSize);
        }
        if (!north) {
            this.renderTwoWayZFace(renderblocks, block, state.currentTexture, x, y, z, minSize, minSize, maxSize, maxSize, minSize);
        }
        if (!south) {
            this.renderTwoWayZFace(renderblocks, block, state.currentTexture, x, y, z, minSize, minSize, maxSize, maxSize, maxSize);
        }
        renderblocks.func_83020_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        if (state.wireMatrix.hasWire(IPipe.WireColor.Red)) {
            state.currentTexture = BuildCraftTransport.instance.wireIconProvider.getIcon(state.wireMatrix.getWireIconIndex(IPipe.WireColor.Red));
            this.pipeWireRender(renderblocks, (Block)block, state, 0.25f, 0.75f, 0.25f, IPipe.WireColor.Red, x, y, z);
        }
        if (state.wireMatrix.hasWire(IPipe.WireColor.Blue)) {
            state.currentTexture = BuildCraftTransport.instance.wireIconProvider.getIcon(state.wireMatrix.getWireIconIndex(IPipe.WireColor.Blue));
            this.pipeWireRender(renderblocks, (Block)block, state, 0.75f, 0.75f, 0.75f, IPipe.WireColor.Blue, x, y, z);
        }
        if (state.wireMatrix.hasWire(IPipe.WireColor.Green)) {
            state.currentTexture = BuildCraftTransport.instance.wireIconProvider.getIcon(state.wireMatrix.getWireIconIndex(IPipe.WireColor.Green));
            this.pipeWireRender(renderblocks, (Block)block, state, 0.75f, 0.25f, 0.25f, IPipe.WireColor.Green, x, y, z);
        }
        if (state.wireMatrix.hasWire(IPipe.WireColor.Yellow)) {
            state.currentTexture = BuildCraftTransport.instance.wireIconProvider.getIcon(state.wireMatrix.getWireIconIndex(IPipe.WireColor.Yellow));
            this.pipeWireRender(renderblocks, (Block)block, state, 0.25f, 0.25f, 0.75f, IPipe.WireColor.Yellow, x, y, z);
        }
        if (state.hasGate()) {
            this.pipeGateRender(renderblocks, (Block)block, state, x, y, z);
        }
        this.pipeFacadeRenderer(renderblocks, (Block)block, state, x, y, z);
        this.pipePlugRenderer(renderblocks, (Block)block, state, x, y, z);
    }

    private void pipeFacadeRenderer(RenderBlocks renderblocks, Block block, PipeRenderState state, int x, int y, int z) {
        float zFightOffset = 2.4414062E-4f;
        float[][] zeroState = new float[3][2];
        zeroState[0][0] = 0.0f - zFightOffset / 2.0f;
        zeroState[0][1] = 1.0f + zFightOffset / 2.0f;
        zeroState[1][0] = 0.0f - zFightOffset;
        zeroState[1][1] = 0.0625f;
        zeroState[2][0] = 0.0f;
        zeroState[2][1] = 1.0f;
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            int facadeId = state.facadeMatrix.getFacadeBlockId(direction);
            if (facadeId != 0) {
                float[][] rotated;
                Block renderBlock = Block.field_71973_m[facadeId];
                int renderMeta = state.facadeMatrix.getFacadeMetaId(direction);
                state.currentTexture = renderBlock.func_71858_a(direction.ordinal(), renderMeta);
                try {
                    BlockGenericPipe.facadeRenderColor = Item.field_77698_e[state.facadeMatrix.getFacadeBlockId(direction)].func_82790_a(new ItemStack(facadeId, 1, renderMeta), 0);
                }
                catch (Throwable error) {
                    // empty catch block
                }
                if (renderBlock.func_71857_b() == 31) {
                    if ((renderMeta & 0xC) == 4) {
                        renderblocks.field_78662_g = 1;
                        renderblocks.field_78683_h = 1;
                        renderblocks.field_78681_k = 1;
                        renderblocks.field_78675_l = 1;
                    } else if ((renderMeta & 0xC) == 8) {
                        renderblocks.field_78685_i = 1;
                        renderblocks.field_78679_j = 1;
                    }
                }
                if (state.pipeConnectionMatrix.isConnected(direction)) {
                    rotated = this.deepClone(zeroState);
                    rotated[2][0] = 0.0f;
                    rotated[2][1] = 0.25f - zFightOffset;
                    float[] fArray = rotated[1];
                    fArray[0] = fArray[0] - zFightOffset / 2.0f;
                    this.transform(rotated, direction);
                    renderblocks.func_83020_a((double)rotated[0][0], (double)rotated[1][0], (double)rotated[2][0], (double)rotated[0][1], (double)rotated[1][1], (double)rotated[2][1]);
                    renderblocks.func_78570_q(block, x, y, z);
                    rotated = this.deepClone(zeroState);
                    rotated[2][0] = 0.75f + zFightOffset;
                    float[] fArray2 = rotated[1];
                    fArray2[0] = fArray2[0] - zFightOffset / 2.0f;
                    this.transform(rotated, direction);
                    renderblocks.func_83020_a((double)rotated[0][0], (double)rotated[1][0], (double)rotated[2][0], (double)rotated[0][1], (double)rotated[1][1], (double)rotated[2][1]);
                    renderblocks.func_78570_q(block, x, y, z);
                    rotated = this.deepClone(zeroState);
                    rotated[0][0] = 0.0f;
                    rotated[0][1] = 0.25f - zFightOffset;
                    float[] fArray3 = rotated[1];
                    fArray3[1] = fArray3[1] - zFightOffset;
                    this.transform(rotated, direction);
                    renderblocks.func_83020_a((double)rotated[0][0], (double)rotated[1][0], (double)rotated[2][0], (double)rotated[0][1], (double)rotated[1][1], (double)rotated[2][1]);
                    renderblocks.func_78570_q(block, x, y, z);
                    rotated = this.deepClone(zeroState);
                    rotated[0][0] = 0.75f + zFightOffset;
                    rotated[0][1] = 1.0f;
                    float[] fArray4 = rotated[1];
                    fArray4[1] = fArray4[1] - zFightOffset;
                    this.transform(rotated, direction);
                    renderblocks.func_83020_a((double)rotated[0][0], (double)rotated[1][0], (double)rotated[2][0], (double)rotated[0][1], (double)rotated[1][1], (double)rotated[2][1]);
                    renderblocks.func_78570_q(block, x, y, z);
                } else {
                    rotated = this.deepClone(zeroState);
                    this.transform(rotated, direction);
                    renderblocks.func_83020_a((double)rotated[0][0], (double)rotated[1][0], (double)rotated[2][0], (double)rotated[0][1], (double)rotated[1][1], (double)rotated[2][1]);
                    renderblocks.func_78570_q(block, x, y, z);
                }
                if (renderBlock.func_71857_b() == 31) {
                    renderblocks.field_78685_i = 0;
                    renderblocks.field_78662_g = 0;
                    renderblocks.field_78683_h = 0;
                    renderblocks.field_78679_j = 0;
                    renderblocks.field_78681_k = 0;
                    renderblocks.field_78675_l = 0;
                }
            }
            BlockGenericPipe.facadeRenderColor = -1;
        }
        zeroState[0][0] = 0.25f;
        zeroState[0][1] = 0.75f;
        zeroState[1][0] = 0.0625f;
        zeroState[1][1] = 0.25f;
        zeroState[2][0] = 0.25f;
        zeroState[2][1] = 0.75f;
        state.currentTexture = BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.PipeStructureCobblestone.ordinal());
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (state.facadeMatrix.getFacadeBlockId(direction) == 0 || state.pipeConnectionMatrix.isConnected(direction)) continue;
            float[][] rotated = this.deepClone(zeroState);
            this.transform(rotated, direction);
            renderblocks.func_83020_a((double)rotated[0][0], (double)rotated[1][0], (double)rotated[2][0], (double)rotated[0][1], (double)rotated[1][1], (double)rotated[2][1]);
            renderblocks.func_78570_q(block, x, y, z);
        }
    }

    private void pipePlugRenderer(RenderBlocks renderblocks, Block block, PipeRenderState state, int x, int y, int z) {
        float[][] rotated;
        float zFightOffset = 2.4414062E-4f;
        float[][] zeroState = new float[3][2];
        zeroState[0][0] = 0.25f + zFightOffset;
        zeroState[0][1] = 0.75f - zFightOffset;
        zeroState[1][0] = 0.125f;
        zeroState[1][1] = 0.251f;
        zeroState[2][0] = 0.25f + zFightOffset;
        zeroState[2][1] = 0.75f - zFightOffset;
        state.currentTexture = BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.PipeStructureCobblestone.ordinal());
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (!state.plugMatrix.isConnected(direction)) continue;
            rotated = this.deepClone(zeroState);
            this.transform(rotated, direction);
            renderblocks.func_83020_a((double)rotated[0][0], (double)rotated[1][0], (double)rotated[2][0], (double)rotated[0][1], (double)rotated[1][1], (double)rotated[2][1]);
            renderblocks.func_78570_q(block, x, y, z);
        }
        zeroState[0][0] = 0.3125f + zFightOffset;
        zeroState[0][1] = 0.6875f + zFightOffset;
        zeroState[1][0] = 0.25f;
        zeroState[1][1] = 0.375f;
        zeroState[2][0] = 0.3125f;
        zeroState[2][1] = 0.6875f;
        state.currentTexture = BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.PipeStructureCobblestone.ordinal());
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (!state.plugMatrix.isConnected(direction)) continue;
            rotated = this.deepClone(zeroState);
            this.transform(rotated, direction);
            renderblocks.func_83020_a((double)rotated[0][0], (double)rotated[1][0], (double)rotated[2][0], (double)rotated[0][1], (double)rotated[1][1], (double)rotated[2][1]);
            renderblocks.func_78570_q(block, x, y, z);
        }
    }

    private void pipeWireRender(RenderBlocks renderblocks, Block block, PipeRenderState state, float cx, float cy, float cz, IPipe.WireColor color, int x, int y, int z) {
        boolean found;
        float minX = 0.25f;
        float minY = 0.25f;
        float minZ = 0.25f;
        float maxX = 0.75f;
        float maxY = 0.75f;
        float maxZ = 0.75f;
        boolean foundX = false;
        boolean foundY = false;
        boolean foundZ = false;
        if (state.wireMatrix.isWireConnected(color, ForgeDirection.WEST)) {
            minX = 0.0f;
            foundX = true;
        }
        if (state.wireMatrix.isWireConnected(color, ForgeDirection.EAST)) {
            maxX = 1.0f;
            foundX = true;
        }
        if (state.wireMatrix.isWireConnected(color, ForgeDirection.DOWN)) {
            minY = 0.0f;
            foundY = true;
        }
        if (state.wireMatrix.isWireConnected(color, ForgeDirection.UP)) {
            maxY = 1.0f;
            foundY = true;
        }
        if (state.wireMatrix.isWireConnected(color, ForgeDirection.NORTH)) {
            minZ = 0.0f;
            foundZ = true;
        }
        if (state.wireMatrix.isWireConnected(color, ForgeDirection.SOUTH)) {
            maxZ = 1.0f;
            foundZ = true;
        }
        boolean center = false;
        if (minX == 0.0f && maxX != 1.0f && (foundY || foundZ)) {
            if (cx == 0.25f) {
                maxX = 0.25f;
            } else {
                center = true;
            }
        }
        if (minX != 0.0f && maxX == 1.0f && (foundY || foundZ)) {
            if (cx == 0.75f) {
                minX = 0.75f;
            } else {
                center = true;
            }
        }
        if (minY == 0.0f && maxY != 1.0f && (foundX || foundZ)) {
            if (cy == 0.25f) {
                maxY = 0.25f;
            } else {
                center = true;
            }
        }
        if (minY != 0.0f && maxY == 1.0f && (foundX || foundZ)) {
            if (cy == 0.75f) {
                minY = 0.75f;
            } else {
                center = true;
            }
        }
        if (minZ == 0.0f && maxZ != 1.0f && (foundX || foundY)) {
            if (cz == 0.25f) {
                maxZ = 0.25f;
            } else {
                center = true;
            }
        }
        if (minZ != 0.0f && maxZ == 1.0f && (foundX || foundY)) {
            if (cz == 0.75f) {
                minZ = 0.75f;
            } else {
                center = true;
            }
        }
        boolean bl = found = foundX || foundY || foundZ;
        if (minZ != 0.25f || maxZ != 0.75f || !found) {
            renderblocks.func_83020_a(cx == 0.25f ? (double)(cx - 0.05f) : (double)cx, cy == 0.25f ? (double)(cy - 0.05f) : (double)cy, (double)minZ, cx == 0.25f ? (double)cx : (double)(cx + 0.05f), cy == 0.25f ? (double)cy : (double)(cy + 0.05f), (double)maxZ);
            renderblocks.func_78570_q(block, x, y, z);
        }
        if (minX != 0.25f || maxX != 0.75f || !found) {
            renderblocks.func_83020_a((double)minX, cy == 0.25f ? (double)(cy - 0.05f) : (double)cy, cz == 0.25f ? (double)(cz - 0.05f) : (double)cz, (double)maxX, cy == 0.25f ? (double)cy : (double)(cy + 0.05f), cz == 0.25f ? (double)cz : (double)(cz + 0.05f));
            renderblocks.func_78570_q(block, x, y, z);
        }
        if (minY != 0.25f || maxY != 0.75f || !found) {
            renderblocks.func_83020_a(cx == 0.25f ? (double)(cx - 0.05f) : (double)cx, (double)minY, cz == 0.25f ? (double)(cz - 0.05f) : (double)cz, cx == 0.25f ? (double)cx : (double)(cx + 0.05f), (double)maxY, cz == 0.25f ? (double)cz : (double)(cz + 0.05f));
            renderblocks.func_78570_q(block, x, y, z);
        }
        if (center || !found) {
            renderblocks.func_83020_a(cx == 0.25f ? (double)(cx - 0.05f) : (double)cx, cy == 0.25f ? (double)(cy - 0.05f) : (double)cy, cz == 0.25f ? (double)(cz - 0.05f) : (double)cz, cx == 0.25f ? (double)cx : (double)(cx + 0.05f), cy == 0.25f ? (double)cy : (double)(cy + 0.05f), cz == 0.25f ? (double)cz : (double)(cz + 0.05f));
            renderblocks.func_78570_q(block, x, y, z);
        }
    }

    private void pipeGateRender(RenderBlocks renderblocks, Block block, PipeRenderState state, int x, int y, int z) {
        state.currentTexture = BuildCraftTransport.instance.gateIconProvider.getIcon(state.getGateIconIndex());
        float min = 0.3f;
        float max = 0.7f;
        if (this.shouldRenderNormalPipeSide(state, ForgeDirection.WEST)) {
            renderblocks.func_83020_a((double)0.15f, (double)min, (double)min, (double)0.251f, (double)max, (double)max);
            renderblocks.func_78570_q(block, x, y, z);
        }
        if (this.shouldRenderNormalPipeSide(state, ForgeDirection.EAST)) {
            renderblocks.func_83020_a((double)0.751f, (double)min, (double)min, (double)0.85f, (double)max, (double)max);
            renderblocks.func_78570_q(block, x, y, z);
        }
        if (this.shouldRenderNormalPipeSide(state, ForgeDirection.DOWN)) {
            renderblocks.func_83020_a((double)min, (double)0.15f, (double)min, (double)max, (double)0.251f, (double)max);
            renderblocks.func_78570_q(block, x, y, z);
        }
        if (this.shouldRenderNormalPipeSide(state, ForgeDirection.UP)) {
            renderblocks.func_83020_a((double)min, (double)0.751f, (double)min, (double)max, (double)0.85f, (double)max);
            renderblocks.func_78570_q(block, x, y, z);
        }
        if (this.shouldRenderNormalPipeSide(state, ForgeDirection.NORTH)) {
            renderblocks.func_83020_a((double)min, (double)min, (double)0.15f, (double)max, (double)max, (double)0.251f);
            renderblocks.func_78570_q(block, x, y, z);
        }
        if (this.shouldRenderNormalPipeSide(state, ForgeDirection.SOUTH)) {
            renderblocks.func_83020_a((double)min, (double)min, (double)0.751f, (double)max, (double)max, (double)0.85f);
            renderblocks.func_78570_q(block, x, y, z);
        }
    }

    private boolean shouldRenderNormalPipeSide(PipeRenderState state, ForgeDirection direction) {
        return !state.pipeConnectionMatrix.isConnected(direction) && state.facadeMatrix.getFacadeBlockId(direction) == 0 && !state.plugMatrix.isConnected(direction);
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof IPipeRenderState) {
            IPipeRenderState pipeTile = (IPipeRenderState)tile;
            this.renderPipe(renderer, world, (BlockGenericPipe)block, pipeTile, x, y, z);
        }
        return true;
    }

    public boolean shouldRender3DInInventory() {
        return false;
    }

    public int getRenderId() {
        return TransportProxy.pipeModel;
    }
}

