/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.Position;
import buildcraft.api.tools.IToolWrench;
import buildcraft.core.utils.EnumColor;
import buildcraft.core.utils.Utils;
import buildcraft.transport.IItemTravelingHook;
import buildcraft.transport.IPipeTransportItemsHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.triggers.ActionPipeColor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsLapis
extends Pipe
implements IItemTravelingHook,
IPipeTransportItemsHook {
    public PipeItemsLapis(int itemID) {
        super(new PipeTransportItems(), itemID);
        ((PipeTransportItems)this.transport).travelHook = this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        if (this.container == null) {
            return PipeIconProvider.TYPE.PipeItemsLapis_White.ordinal();
        }
        return PipeIconProvider.TYPE.PipeItemsLapis_Black.ordinal() + this.container.func_70322_n();
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        Item equipped;
        Item item = equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(player, this.container.field_70329_l, this.container.field_70330_m, this.container.field_70327_n)) {
            if (player.func_70093_af()) {
                this.setColor(this.getColor().getPrevious());
            } else {
                this.setColor(this.getColor().getNext());
            }
            ((IToolWrench)equipped).wrenchUsed(player, this.container.field_70329_l, this.container.field_70330_m, this.container.field_70327_n);
            return true;
        }
        return false;
    }

    public EnumColor getColor() {
        return EnumColor.fromId(this.container.func_70322_n());
    }

    public void setColor(EnumColor color) {
        if (color.ordinal() != this.container.func_70322_n()) {
            this.container.field_70331_k.func_72921_c(this.container.field_70329_l, this.container.field_70330_m, this.container.field_70327_n, color.ordinal(), 3);
            this.container.scheduleRenderUpdate();
            this.container.markBlockForUpdate();
        }
    }

    @Override
    public void drop(PipeTransportItems transport, TravelingItem data) {
    }

    @Override
    public void centerReached(PipeTransportItems transport, TravelingItem item) {
        item.color = this.getColor();
    }

    @Override
    public boolean endReached(PipeTransportItems pipe, TravelingItem item, TileEntity tile) {
        return false;
    }

    @Override
    public void readjustSpeed(TravelingItem item) {
        if (item.getSpeed() > Utils.pipeNormalSpeed) {
            item.setSpeed(item.getSpeed() - Utils.pipeNormalSpeed / 4.0f);
        }
        if (item.getSpeed() < Utils.pipeNormalSpeed) {
            item.setSpeed(Utils.pipeNormalSpeed);
        }
    }

    @Override
    public LinkedList filterPossibleMovements(LinkedList possibleOrientations, Position pos, TravelingItem travellingItem) {
        return possibleOrientations;
    }

    @Override
    public void entityEntered(TravelingItem travellingItem, ForgeDirection orientation) {
    }

    @Override
    protected void actionsActivated(Map actions) {
        super.actionsActivated(actions);
        for (Map.Entry action : actions.entrySet()) {
            if (!(action.getKey() instanceof ActionPipeColor) || action.getValue() == null || !((Boolean)action.getValue()).booleanValue()) continue;
            this.setColor(((ActionPipeColor)action.getKey()).color);
            break;
        }
    }

    @Override
    public LinkedList getActions() {
        LinkedList result = super.getActions();
        result.addAll(Arrays.asList(BuildCraftTransport.actionPipeColor));
        return result;
    }
}

