/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.Position;
import buildcraft.api.tools.IToolWrench;
import buildcraft.core.network.TileNetworkData;
import buildcraft.core.utils.EnumColor;
import buildcraft.core.utils.Utils;
import buildcraft.transport.IPipeTransportItemsHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.pipes.PipeItemsWood;
import buildcraft.transport.pipes.PipeLogicIron;
import buildcraft.transport.triggers.ActionPipeColor;
import buildcraft.transport.triggers.ActionPipeDirection;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsDaizuli
extends Pipe
implements IPipeTransportItemsHook {
    private int standardIconIndex = PipeIconProvider.TYPE.PipeItemsDaizuli_Black.ordinal();
    private int solidIconIndex = PipeIconProvider.TYPE.PipeAllDaizuli_Solid.ordinal();
    @TileNetworkData
    private int color = EnumColor.WHITE.ordinal();
    private PipeLogicIron logic = new PipeLogicIron(this){

        @Override
        protected boolean isValidConnectingTile(TileEntity tile) {
            if (tile instanceof TileGenericPipe) {
                Pipe otherPipe = ((TileGenericPipe)tile).pipe;
                if (otherPipe instanceof PipeItemsWood) {
                    return false;
                }
                return otherPipe.transport instanceof PipeTransportItems;
            }
            return tile instanceof IInventory;
        }
    };

    public PipeItemsDaizuli(int itemID) {
        super(new PipeTransportItems(), itemID);
        ((PipeTransportItems)this.transport).allowBouncing = true;
    }

    public EnumColor getColor() {
        return EnumColor.fromId(this.color);
    }

    public void setColor(EnumColor c) {
        if (this.color != c.ordinal()) {
            this.color = c.ordinal();
            this.container.scheduleRenderUpdate();
            this.container.markBlockForUpdate();
        }
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        Item equipped;
        Item item = equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        if (player.func_70093_af() && equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(player, this.container.field_70329_l, this.container.field_70330_m, this.container.field_70327_n)) {
            this.setColor(this.getColor().getNext());
            ((IToolWrench)equipped).wrenchUsed(player, this.container.field_70329_l, this.container.field_70330_m, this.container.field_70327_n);
            return true;
        }
        return this.logic.blockActivated(player);
    }

    @Override
    public void onBlockPlaced() {
        this.logic.onBlockPlaced();
        super.onBlockPlaced();
    }

    @Override
    public void initialize() {
        this.logic.initialize();
        super.initialize();
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        if (this.container != null && this.container.func_70322_n() == direction.ordinal()) {
            return this.solidIconIndex;
        }
        return this.standardIconIndex + this.color;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    @Override
    public LinkedList filterPossibleMovements(LinkedList possibleOrientations, Position pos, TravelingItem item) {
        LinkedList<ForgeDirection> newMovements = new LinkedList<ForgeDirection>();
        EnumColor c = this.getColor();
        for (ForgeDirection dir : possibleOrientations) {
            if (item.color == c) {
                if (dir.ordinal() != this.container.func_70322_n()) continue;
                newMovements.add(dir);
                continue;
            }
            if (dir.ordinal() == this.container.func_70322_n()) continue;
            newMovements.add(dir);
        }
        return newMovements;
    }

    @Override
    public void entityEntered(TravelingItem item, ForgeDirection orientation) {
    }

    @Override
    public void readjustSpeed(TravelingItem item) {
        if (item.getSpeed() > Utils.pipeNormalSpeed) {
            item.setSpeed(item.getSpeed() - Utils.pipeNormalSpeed / 4.0f);
        }
        if (item.getSpeed() < Utils.pipeNormalSpeed) {
            item.setSpeed(Utils.pipeNormalSpeed);
        }
    }

    @Override
    protected void actionsActivated(Map actions) {
        super.actionsActivated(actions);
        for (Map.Entry action : actions.entrySet()) {
            if (!(action.getKey() instanceof ActionPipeColor) || action.getValue() == null || !((Boolean)action.getValue()).booleanValue()) continue;
            this.setColor(((ActionPipeColor)action.getKey()).color);
            break;
        }
        for (Map.Entry action : actions.entrySet()) {
            if (!(action.getKey() instanceof ActionPipeDirection) || action.getValue() == null || !((Boolean)action.getValue()).booleanValue()) continue;
            this.logic.setFacing(((ActionPipeDirection)action.getKey()).direction);
            break;
        }
    }

    @Override
    public LinkedList getActions() {
        LinkedList action = super.getActions();
        action.addAll(Arrays.asList(BuildCraftTransport.actionPipeColor));
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.container.isPipeConnected(direction)) continue;
            action.add(BuildCraftTransport.actionPipeDirection[direction.ordinal()]);
        }
        return action;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74774_a("color", (byte)this.color);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.color = data.func_74771_c("color");
    }
}

