/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.pipes.PipeFluidsWood;
import buildcraft.transport.pipes.PipeLogicIron;
import buildcraft.transport.pipes.PipeStructureCobblestone;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public class PipeFluidsIron
extends Pipe {
    protected int standardIconIndex = PipeIconProvider.TYPE.PipeFluidsIron_Standard.ordinal();
    protected int solidIconIndex = PipeIconProvider.TYPE.PipeAllIron_Solid.ordinal();
    private PipeLogicIron logic = new PipeLogicIron(this){

        @Override
        protected boolean isValidConnectingTile(TileEntity tile) {
            if (tile instanceof TileGenericPipe) {
                Pipe otherPipe = ((TileGenericPipe)tile).pipe;
                if (otherPipe instanceof PipeFluidsWood || otherPipe instanceof PipeStructureCobblestone) {
                    return false;
                }
                return otherPipe.transport instanceof PipeTransportFluids;
            }
            return tile instanceof IFluidHandler;
        }
    };

    public PipeFluidsIron(int itemID) {
        super(new PipeTransportFluids(), itemID);
    }

    @Override
    public boolean blockActivated(EntityPlayer entityplayer) {
        return this.logic.blockActivated(entityplayer);
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        this.logic.switchOnRedstone();
        super.onNeighborBlockChange(blockId);
    }

    @Override
    public void onBlockPlaced() {
        this.logic.onBlockPlaced();
        super.onBlockPlaced();
    }

    @Override
    public void initialize() {
        this.logic.initialize();
        super.initialize();
    }

    @Override
    public boolean outputOpen(ForgeDirection to) {
        return super.outputOpen(to) && this.logic.outputOpen(to);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return this.standardIconIndex;
        }
        int metadata = this.container.func_70322_n();
        if (metadata == direction.ordinal()) {
            return this.solidIconIndex;
        }
        return this.standardIconIndex;
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }
}

