/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gui;

import buildcraft.api.gates.IAction;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerParameter;
import buildcraft.core.gui.GuiAdvancedInterface;
import buildcraft.core.utils.StringUtils;
import buildcraft.transport.Gate;
import buildcraft.transport.Pipe;
import buildcraft.transport.gui.ContainerGateInterface;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiGateInterface
extends GuiAdvancedInterface {
    IInventory playerInventory;
    private final ContainerGateInterface _container;
    private int nbEntries;

    public GuiGateInterface(IInventory playerInventory, Pipe pipe) {
        block7: {
            int k;
            int position;
            block9: {
                int k2;
                block8: {
                    block6: {
                        super(new ContainerGateInterface(playerInventory, pipe), null);
                        this._container = (ContainerGateInterface)this.field_74193_d;
                        this.playerInventory = playerInventory;
                        this.field_74194_b = 175;
                        this.field_74195_c = 207;
                        position = 0;
                        if (pipe.gate.kind != Gate.GateKind.Single) break block6;
                        this.nbEntries = 1;
                        this.slots = new GuiAdvancedInterface.AdvancedSlot[2];
                        this.slots[0] = new TriggerSlot(65, 54, pipe, 0);
                        this.slots[1] = new ActionSlot(99, 54, pipe, 0);
                        break block7;
                    }
                    if (pipe.gate.kind != Gate.GateKind.AND_2 && pipe.gate.kind != Gate.GateKind.OR_2) break block8;
                    this.nbEntries = 2;
                    this.slots = new GuiAdvancedInterface.AdvancedSlot[4];
                    this.slots[0] = new TriggerSlot(65, 46, pipe, 0);
                    this.slots[1] = new TriggerSlot(65, 64, pipe, 1);
                    this.slots[2] = new ActionSlot(99, 46, pipe, 0);
                    this.slots[3] = new ActionSlot(99, 64, pipe, 1);
                    break block7;
                }
                if (pipe.gate.kind != Gate.GateKind.AND_3 && pipe.gate.kind != Gate.GateKind.OR_3) break block9;
                this.nbEntries = 4;
                this.slots = new GuiAdvancedInterface.AdvancedSlot[12];
                for (k2 = 0; k2 < 4; ++k2) {
                    this.slots[position] = new TriggerSlot(60, 36 + 18 * k2, pipe, position);
                    ++position;
                }
                for (k2 = 0; k2 < 4; ++k2) {
                    this.slots[position] = new ActionSlot(112, 36 + 18 * k2, pipe, position - 4);
                    ++position;
                }
                for (k2 = 0; k2 < 4; ++k2) {
                    this.slots[position] = new TriggerParameterSlot(78, 36 + 18 * k2, pipe, position - 8);
                    ++position;
                }
                break block7;
            }
            if (pipe.gate.kind != Gate.GateKind.AND_4 && pipe.gate.kind != Gate.GateKind.OR_4) break block7;
            this.nbEntries = 8;
            this.slots = new GuiAdvancedInterface.AdvancedSlot[24];
            for (k = 0; k < 4; ++k) {
                this.slots[position] = new TriggerSlot(8, 36 + 18 * k, pipe, position);
                this.slots[++position] = new TriggerSlot(100, 36 + 18 * k, pipe, position);
                ++position;
            }
            for (k = 0; k < 4; ++k) {
                this.slots[position] = new ActionSlot(60, 36 + 18 * k, pipe, position - 8);
                this.slots[++position] = new ActionSlot(152, 36 + 18 * k, pipe, position - 8);
                ++position;
            }
            for (k = 0; k < 4; ++k) {
                this.slots[position] = new TriggerParameterSlot(26, 36 + 18 * k, pipe, position - 16);
                this.slots[++position] = new TriggerParameterSlot(118, 36 + 18 * k, pipe, position - 16);
                ++position;
            }
        }
    }

    @Override
    protected void func_74189_g(int par1, int par2) {
        String name = this._container.getGateName();
        this.field_73886_k.func_78276_b(name, this.getCenteredOffset(name), 15, 0x404040);
        this.field_73886_k.func_78276_b(StringUtils.localize("gui.inventory"), 8, this.field_74195_c - 97, 0x404040);
        this.drawForegroundSelection(par1, par2);
    }

    protected void func_74185_a(float f, int x, int y) {
        this._container.synchronize();
        ResourceLocation texture = this._container.getGateGuiFile();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_110577_a(texture);
        int cornerX = (this.field_73880_f - this.field_74194_b) / 2;
        int cornerY = (this.field_73881_g - this.field_74195_c) / 2;
        this.func_73729_b(cornerX, cornerY, 0, 0, this.field_74194_b, this.field_74195_c);
        int triggerTracker = 0;
        for (int s = 0; s < this.slots.length; ++s) {
            GuiAdvancedInterface.AdvancedSlot slot = this.slots[s];
            if (!(slot instanceof TriggerSlot)) continue;
            ITrigger trigger = ((TriggerSlot)slot).getTrigger();
            if (this._container.getGateOrdinal() >= Gate.GateKind.AND_3.ordinal()) {
                if (this._container.triggerState[triggerTracker++]) {
                    this.field_73882_e.field_71446_o.func_110577_a(texture);
                    this.func_73729_b(cornerX + slot.x + 35, cornerY + slot.y + 6, 176, 18, 18, 4);
                }
                if (trigger != null && trigger.hasParameter()) continue;
                this.field_73882_e.field_71446_o.func_110577_a(texture);
                this.func_73729_b(cornerX + slot.x + 17, cornerY + slot.y - 1, 176, 0, 18, 18);
                continue;
            }
            if (!this._container.triggerState[triggerTracker++]) continue;
            this.field_73882_e.field_71446_o.func_110577_a(texture);
            this.func_73729_b(cornerX + slot.x + 17, cornerY + slot.y + 6, 176, 18, 18, 4);
        }
        this.drawBackgroundSlots();
    }

    @Override
    protected void func_73864_a(int i, int j, int k) {
        ITriggerParameter param;
        TriggerSlot trigger;
        super.func_73864_a(i, j, k);
        int cornerX = (this.field_73880_f - this.field_74194_b) / 2;
        int cornerY = (this.field_73881_g - this.field_74195_c) / 2;
        int position = this.getSlotAtLocation(i - cornerX, j - cornerY);
        GuiAdvancedInterface.AdvancedSlot slot = null;
        if (position < 0) {
            return;
        }
        slot = this.slots[position];
        if (slot instanceof TriggerSlot && this._container.hasTriggers()) {
            TriggerSlot triggerSlot = (TriggerSlot)slot;
            ITrigger changed = null;
            if (triggerSlot.getTrigger() == null) {
                changed = k == 0 ? this._container.getFirstTrigger() : this._container.getLastTrigger();
            } else {
                Iterator it = this._container.getTriggerIterator(k != 0);
                while (it.hasNext()) {
                    ITrigger trigger2 = (ITrigger)it.next();
                    if (!it.hasNext()) {
                        changed = null;
                        break;
                    }
                    if (trigger2 != triggerSlot.getTrigger()) continue;
                    changed = (ITrigger)it.next();
                    break;
                }
            }
            this._container.setTrigger(position, changed, true);
            if (this._container.getGateOrdinal() >= Gate.GateKind.AND_3.ordinal()) {
                this._container.setTriggerParameter(position, null, true);
            }
        } else if (slot instanceof ActionSlot) {
            ActionSlot actionSlot = (ActionSlot)slot;
            IAction changed = null;
            if (actionSlot.getAction() == null) {
                changed = k == 0 ? this._container.getFirstAction() : this._container.getLastAction();
            } else {
                Iterator it = this._container.getActionIterator(k != 0);
                while (it.hasNext()) {
                    IAction action = (IAction)it.next();
                    if (!it.hasNext()) {
                        changed = null;
                        break;
                    }
                    if (action != actionSlot.getAction()) continue;
                    changed = (IAction)it.next();
                    break;
                }
            }
            this._container.setAction(position - this.nbEntries, changed, true);
        } else if (slot instanceof TriggerParameterSlot && (trigger = (TriggerSlot)this.slots[position - this.nbEntries * 2]).isDefined() && trigger.getTrigger().hasParameter() && (param = trigger.getTrigger().createParameter()) != null) {
            param.set(this.field_73882_e.field_71439_g.field_71071_by.func_70445_o());
            this._container.setTriggerParameter(position - this.nbEntries * 2, param, true);
        }
        this._container.markDirty();
    }

    class TriggerParameterSlot
    extends GuiAdvancedInterface.AdvancedSlot {
        Pipe pipe;
        int slot;

        public TriggerParameterSlot(int x, int y, Pipe pipe, int slot) {
            super(x, y);
            this.pipe = pipe;
            this.slot = slot;
        }

        @Override
        public boolean isDefined() {
            return this.pipe.gate.getTriggerParameter(this.slot) != null;
        }

        @Override
        public ItemStack getItemStack() {
            ITriggerParameter parameter = this.pipe.gate.getTriggerParameter(this.slot);
            if (parameter != null) {
                return parameter.getItem();
            }
            return null;
        }

        public ITriggerParameter getTriggerParameter() {
            return this.pipe.gate.getTriggerParameter(this.slot);
        }
    }

    class ActionSlot
    extends GuiAdvancedInterface.AdvancedSlot {
        Pipe pipe;
        int slot;

        public ActionSlot(int x, int y, Pipe pipe, int slot) {
            super(x, y);
            this.pipe = pipe;
            this.slot = slot;
        }

        @Override
        public String getDescription() {
            IAction action = this.pipe.gate.getAction(this.slot);
            if (action != null) {
                return action.getDescription();
            }
            return "";
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public Icon getIcon() {
            IAction action = this.pipe.gate.getAction(this.slot);
            if (action != null) {
                return action.getIcon();
            }
            return null;
        }

        @Override
        public boolean isDefined() {
            return this.pipe.gate.getAction(this.slot) != null;
        }

        public IAction getAction() {
            return this.pipe.gate.getAction(this.slot);
        }
    }

    class TriggerSlot
    extends GuiAdvancedInterface.AdvancedSlot {
        Pipe pipe;
        int slot;

        public TriggerSlot(int x, int y, Pipe pipe, int slot) {
            super(x, y);
            this.pipe = pipe;
            this.slot = slot;
        }

        @Override
        public String getDescription() {
            ITrigger trigger = this.pipe.gate.getTrigger(this.slot);
            if (trigger != null) {
                return trigger.getDescription();
            }
            return "";
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public Icon getIcon() {
            ITrigger trigger = this.pipe.gate.getTrigger(this.slot);
            if (trigger != null) {
                return trigger.getIcon();
            }
            return null;
        }

        @Override
        public boolean isDefined() {
            return this.pipe.gate.getTrigger(this.slot) != null;
        }

        public ITrigger getTrigger() {
            return this.pipe.gate.getTrigger(this.slot);
        }
    }
}

