/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gui;

import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.IAction;
import buildcraft.api.gates.IOverrideDefaultTriggers;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerParameter;
import buildcraft.api.gates.TriggerParameter;
import buildcraft.core.gui.BuildCraftContainer;
import buildcraft.core.network.PacketCoordinates;
import buildcraft.core.network.PacketPayload;
import buildcraft.core.network.PacketPayloadArrays;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.transport.Pipe;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeDirection;

public class ContainerGateInterface
extends BuildCraftContainer {
    IInventory playerIInventory;
    Pipe pipe;
    private final LinkedList _potentialTriggers = new LinkedList();
    private final LinkedList _potentialActions = new LinkedList();
    private boolean isSynchronized = false;
    private boolean isNetInitialized = false;
    public boolean[] triggerState = new boolean[8];
    private int lastTriggerState = 0;

    public ContainerGateInterface(IInventory playerInventory, Pipe pipe) {
        super(0);
        this.playerIInventory = playerInventory;
        for (int l = 0; l < 3; ++l) {
            for (int k1 = 0; k1 < 9; ++k1) {
                this.func_75146_a(new Slot(playerInventory, k1 + l * 9 + 9, 8 + k1 * 18, 123 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.func_75146_a(new Slot(playerInventory, i1, 8 + i1 * 18, 181));
        }
        this.pipe = pipe;
        if (!CoreProxy.proxy.isRenderWorld(pipe.container.field_70331_k)) {
            this._potentialActions.addAll(pipe.getActions());
            this._potentialTriggers.addAll(ActionManager.getPipeTriggers(pipe));
            if (pipe.container instanceof IOverrideDefaultTriggers) {
                this._potentialTriggers.addAll(pipe.container.getTriggers());
            }
            for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = pipe.container.getTile(o);
                int blockID = pipe.container.getBlockId(o);
                Block block = Block.field_71973_m[blockID];
                LinkedList nearbyTriggers = ActionManager.getNeighborTriggers(block, tile);
                for (ITrigger t : nearbyTriggers) {
                    if (this._potentialTriggers.contains(t)) continue;
                    this._potentialTriggers.add(t);
                }
                LinkedList nearbyActions = ActionManager.getNeighborActions(block, tile);
                for (IAction a : nearbyActions) {
                    if (this._potentialActions.contains(a)) continue;
                    this._potentialActions.add(a);
                }
            }
        }
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return true;
    }

    public void markDirty() {
        this.isSynchronized = false;
    }

    public void updateActions(PacketUpdate packet) {
        this._potentialActions.clear();
        PacketPayloadArrays payload = (PacketPayloadArrays)packet.payload;
        int length = payload.intPayload[0];
        for (int i = 0; i < length; ++i) {
            this._potentialActions.add(ActionManager.actions.get(payload.stringPayload[i]));
        }
    }

    public void updateTriggers(PacketUpdate packet) {
        this._potentialTriggers.clear();
        PacketPayloadArrays payload = (PacketPayloadArrays)packet.payload;
        int length = payload.intPayload[0];
        for (int i = 0; i < length; ++i) {
            this._potentialTriggers.add(ActionManager.triggers.get(payload.stringPayload[i]));
        }
    }

    public void setSelection(PacketUpdate packet, boolean notify) {
        PacketPayloadArrays payload = (PacketPayloadArrays)packet.payload;
        int position = payload.intPayload[0];
        this.setTrigger(position, (ITrigger)ActionManager.triggers.get(payload.stringPayload[0]), notify);
        this.setAction(position, (IAction)ActionManager.actions.get(payload.stringPayload[1]), notify);
        int itemID = payload.intPayload[1];
        if (itemID <= 0) {
            this.setTriggerParameter(position, null, notify);
            return;
        }
        TriggerParameter param = new TriggerParameter();
        param.set(new ItemStack(itemID, payload.intPayload[2], payload.intPayload[3]));
        this.setTriggerParameter(position, param, notify);
    }

    private PacketPayload getSelectionPayload(int position) {
        PacketPayloadArrays payload = new PacketPayloadArrays(4, 0, 2);
        payload.intPayload[0] = position;
        payload.stringPayload[0] = this.pipe.gate.triggers[position] != null ? this.pipe.gate.triggers[position].getUniqueTag() : "";
        payload.stringPayload[1] = this.pipe.gate.actions[position] != null ? this.pipe.gate.actions[position].getUniqueTag() : "";
        if (this.pipe.gate.triggerParameters[position] != null && this.pipe.gate.triggerParameters[position].getItemStack() != null) {
            payload.intPayload[1] = this.pipe.gate.triggerParameters[position].getItemStack().field_77993_c;
            payload.intPayload[2] = this.pipe.gate.triggerParameters[position].getItemStack().field_77994_a;
            payload.intPayload[3] = this.pipe.gate.triggerParameters[position].getItemStack().func_77960_j();
        }
        return payload;
    }

    public void sendSelectionChange(int position) {
        CoreProxy.proxy.sendToServer(new PacketUpdate(44, this.pipe.container.field_70329_l, this.pipe.container.field_70330_m, this.pipe.container.field_70327_n, this.getSelectionPayload(position)).getPacket());
    }

    public void synchronize() {
        if (!this.isNetInitialized && CoreProxy.proxy.isRenderWorld(this.pipe.container.field_70331_k)) {
            this.isNetInitialized = true;
            CoreProxy.proxy.sendToServer(new PacketCoordinates(41, this.pipe.container.field_70329_l, this.pipe.container.field_70330_m, this.pipe.container.field_70327_n).getPacket());
        }
        if (!this.isSynchronized && CoreProxy.proxy.isRenderWorld(this.pipe.container.field_70331_k)) {
            this.isSynchronized = true;
            CoreProxy.proxy.sendToServer(new PacketCoordinates(42, this.pipe.container.field_70329_l, this.pipe.container.field_70330_m, this.pipe.container.field_70327_n).getPacket());
        }
    }

    public void func_75137_b(int id, int state) {
        if (id == 0) {
            for (int i = 0; i < 8; ++i) {
                this.triggerState[i] = (state >> i & 1) == 1;
            }
        }
    }

    private int calculateTriggerState() {
        if (this.pipe.gate == null) {
            return 0;
        }
        int state = 0;
        for (int i = 0; i < this.triggerState.length; ++i) {
            if (this.pipe.gate.triggers[i] != null) {
                this.triggerState[i] = this.isNearbyTriggerActive(this.pipe.gate.triggers[i], this.pipe.gate.getTriggerParameter(i));
            }
            state |= this.triggerState[i] ? 1 << i : 0;
        }
        return state;
    }

    public void func_75142_b() {
        super.func_75142_b();
        int state = this.calculateTriggerState();
        if (state != this.lastTriggerState) {
            for (int i = 0; i < this.field_75149_d.size(); ++i) {
                ICrafting viewingPlayer = (ICrafting)this.field_75149_d.get(i);
                viewingPlayer.func_71112_a((Container)this, 0, state);
            }
            this.lastTriggerState = state;
        }
    }

    public void handleInitRequest(EntityPlayer player) {
        this.sendActions(player);
        this.sendTriggers(player);
        this.sendSelection(player);
    }

    private void sendActions(EntityPlayer player) {
        int length = this._potentialActions.size();
        PacketPayloadArrays payload = new PacketPayloadArrays(1, 0, length);
        payload.intPayload[0] = length;
        for (int i = 0; i < length; ++i) {
            payload.stringPayload[i] = ((IAction)this._potentialActions.get(i)).getUniqueTag();
        }
        PacketUpdate packet = new PacketUpdate(40, this.pipe.container.field_70329_l, this.pipe.container.field_70330_m, this.pipe.container.field_70327_n, payload);
        CoreProxy.proxy.sendToPlayer(player, packet);
    }

    private void sendTriggers(EntityPlayer player) {
        int length = this._potentialTriggers.size();
        PacketPayloadArrays payload = new PacketPayloadArrays(1, 0, length);
        payload.intPayload[0] = length;
        for (int i = 0; i < length; ++i) {
            payload.stringPayload[i] = ((ITrigger)this._potentialTriggers.get(i)).getUniqueTag();
        }
        PacketUpdate packet = new PacketUpdate(45, this.pipe.container.field_70329_l, this.pipe.container.field_70330_m, this.pipe.container.field_70327_n, payload);
        CoreProxy.proxy.sendToPlayer(player, packet);
    }

    public void sendSelection(EntityPlayer player) {
        if (this.pipe == null || this.pipe.gate == null) {
            return;
        }
        int positions = 0;
        switch (this.pipe.gate.kind) {
            case Single: {
                positions = 1;
                break;
            }
            case AND_2: 
            case OR_2: {
                positions = 2;
                break;
            }
            case AND_3: 
            case OR_3: {
                positions = 4;
                break;
            }
            default: {
                positions = 8;
            }
        }
        for (int position = 0; position < positions; ++position) {
            CoreProxy.proxy.sendToPlayer(player, new PacketUpdate(43, this.pipe.container.field_70329_l, this.pipe.container.field_70330_m, this.pipe.container.field_70327_n, this.getSelectionPayload(position)));
        }
    }

    public boolean hasTriggers() {
        return this._potentialTriggers.size() > 0;
    }

    public ITrigger getFirstTrigger() {
        return this._potentialTriggers.size() > 0 ? (ITrigger)this._potentialTriggers.getFirst() : null;
    }

    public ITrigger getLastTrigger() {
        return this._potentialTriggers.size() > 0 ? (ITrigger)this._potentialTriggers.getLast() : null;
    }

    public Iterator getTriggerIterator(boolean descending) {
        return descending ? this._potentialTriggers.descendingIterator() : this._potentialTriggers.iterator();
    }

    public boolean isNearbyTriggerActive(ITrigger trigger, ITriggerParameter parameter) {
        return this.pipe.gate.isNearbyTriggerActive(trigger, parameter);
    }

    public void setTrigger(int position, ITrigger trigger, boolean notify) {
        this.pipe.gate.setTrigger(position, trigger);
        if (CoreProxy.proxy.isRenderWorld(this.pipe.container.field_70331_k) && notify) {
            this.sendSelectionChange(position);
        }
    }

    public void setTriggerParameter(int position, ITriggerParameter parameter, boolean notify) {
        this.pipe.gate.setTriggerParameter(position, parameter);
        if (CoreProxy.proxy.isRenderWorld(this.pipe.container.field_70331_k) && notify) {
            this.sendSelectionChange(position);
        }
    }

    public boolean hasActions() {
        return !this._potentialActions.isEmpty();
    }

    public IAction getFirstAction() {
        return (IAction)this._potentialActions.peekFirst();
    }

    public IAction getLastAction() {
        return (IAction)this._potentialActions.peekLast();
    }

    public Iterator getActionIterator(boolean descending) {
        return descending ? this._potentialActions.descendingIterator() : this._potentialActions.iterator();
    }

    public void setAction(int position, IAction action, boolean notify) {
        this.pipe.gate.setAction(position, action);
        if (CoreProxy.proxy.isRenderWorld(this.pipe.container.field_70331_k) && notify) {
            this.sendSelectionChange(position);
        }
    }

    public ResourceLocation getGateGuiFile() {
        return this.pipe.gate.getGuiFile();
    }

    public int getGateOrdinal() {
        return this.pipe.gate.kind.ordinal();
    }

    public String getGateName() {
        return this.pipe.gate.getName();
    }
}

