/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.Position;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.EnumColor;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.ForgeDirection;

public class TravelingItem {
    public static final InsertionHandler DEFAULT_INSERTION_HANDLER = new InsertionHandler();
    private static int maxId = 0;
    protected float speed = 0.01f;
    protected ItemStack item;
    protected TileEntity container;
    public double xCoord;
    public double yCoord;
    public double zCoord;
    public final int id;
    public boolean toCenter = true;
    public EnumColor color;
    public ForgeDirection input = ForgeDirection.UNKNOWN;
    public ForgeDirection output = ForgeDirection.UNKNOWN;
    public final EnumSet blacklist = EnumSet.noneOf(ForgeDirection.class);
    private NBTTagCompound extraData;
    private InsertionHandler insertionHandler = DEFAULT_INSERTION_HANDLER;

    public TravelingItem() {
        this(maxId < Short.MAX_VALUE ? (maxId = maxId + 1) : (maxId = Short.MIN_VALUE));
    }

    public TravelingItem(int id) {
        this.id = id;
    }

    public TravelingItem(double x, double y, double z, ItemStack stack) {
        this();
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        this.item = stack.func_77946_l();
    }

    public void setPosition(double x, double y, double z) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
    }

    public void movePosition(double x, double y, double z) {
        this.xCoord += x;
        this.yCoord += y;
        this.zCoord += z;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public ItemStack getItemStack() {
        return this.item;
    }

    public void setItemStack(ItemStack item) {
        this.item = item;
    }

    public TileEntity getContainer() {
        return this.container;
    }

    public void setContainer(TileEntity container) {
        this.container = container;
    }

    public NBTTagCompound getExtraData() {
        if (this.extraData == null) {
            this.extraData = new NBTTagCompound();
        }
        return this.extraData;
    }

    public boolean hasExtraData() {
        return this.extraData != null;
    }

    public void setInsetionHandler(InsertionHandler handler) {
        if (handler == null) {
            return;
        }
        this.insertionHandler = handler;
    }

    public InsertionHandler getInsertionHandler() {
        return this.insertionHandler;
    }

    public void reset() {
        this.toCenter = true;
        this.blacklist.clear();
        this.input = ForgeDirection.UNKNOWN;
        this.output = ForgeDirection.UNKNOWN;
    }

    public void readFromNBT(NBTTagCompound data) {
        this.setPosition(data.func_74769_h("x"), data.func_74769_h("y"), data.func_74769_h("z"));
        this.setSpeed(data.func_74760_g("speed"));
        this.setItemStack(ItemStack.func_77949_a((NBTTagCompound)data.func_74775_l("Item")));
        this.toCenter = data.func_74767_n("toCenter");
        this.input = ForgeDirection.getOrientation((int)data.func_74762_e("input"));
        this.output = ForgeDirection.getOrientation((int)data.func_74762_e("output"));
        byte c = data.func_74771_c("color");
        if (c != -1) {
            this.color = EnumColor.fromId(c);
        }
        if (data.func_74764_b("extraData")) {
            this.extraData = data.func_74775_l("extraData");
        }
    }

    public void writeToNBT(NBTTagCompound data) {
        data.func_74780_a("x", this.xCoord);
        data.func_74780_a("y", this.yCoord);
        data.func_74780_a("z", this.zCoord);
        data.func_74776_a("speed", this.getSpeed());
        NBTTagCompound nbttagcompound2 = new NBTTagCompound();
        this.getItemStack().func_77955_b(nbttagcompound2);
        data.func_74766_a("Item", nbttagcompound2);
        data.func_74757_a("toCenter", this.toCenter);
        data.func_74768_a("input", this.input.ordinal());
        data.func_74768_a("output", this.output.ordinal());
        data.func_74774_a("color", this.color != null ? (byte)this.color.ordinal() : (byte)-1);
        if (this.extraData != null) {
            data.func_74782_a("extraData", (NBTBase)this.extraData);
        }
    }

    public EntityItem toEntityItem(ForgeDirection dir) {
        if (this.container != null && !CoreProxy.proxy.isRenderWorld(this.container.field_70331_k)) {
            if (this.getItemStack().field_77994_a <= 0) {
                return null;
            }
            Position motion = new Position(0.0, 0.0, 0.0, dir);
            motion.moveForwards(0.1 + (double)(this.getSpeed() * 2.0f));
            EntityItem entityitem = new EntityItem(this.container.field_70331_k, this.xCoord, this.yCoord, this.zCoord, this.getItemStack());
            entityitem.lifespan = BuildCraftCore.itemLifespan;
            entityitem.field_70293_c = 10;
            float f3 = 0.0f + this.container.field_70331_k.field_73012_v.nextFloat() * 0.04f - 0.02f;
            entityitem.field_70159_w = (double)((float)this.container.field_70331_k.field_73012_v.nextGaussian() * f3) + motion.x;
            entityitem.field_70181_x = (double)((float)this.container.field_70331_k.field_73012_v.nextGaussian() * f3) + motion.y;
            entityitem.field_70179_y = (double)((float)this.container.field_70331_k.field_73012_v.nextGaussian() * f3) + motion.z;
            this.container.field_70331_k.func_72838_d((Entity)entityitem);
            return entityitem;
        }
        return null;
    }

    public float getEntityBrightness(float f) {
        int i = MathHelper.func_76128_c((double)this.xCoord);
        int j = MathHelper.func_76128_c((double)this.zCoord);
        if (this.container != null && this.container.field_70331_k.func_72899_e(i, 64, j)) {
            double d = 0.66;
            int k = MathHelper.func_76128_c((double)(this.yCoord + d));
            return this.container.field_70331_k.func_72801_o(i, k, j);
        }
        return 0.0f;
    }

    public boolean isCorrupted() {
        return this.getItemStack() == null || this.getItemStack().field_77994_a <= 0 || Item.field_77698_e[this.getItemStack().field_77993_c] == null;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + this.id;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TravelingItem other = (TravelingItem)obj;
        return this.id == other.id;
    }

    public static class InsertionHandler {
        public boolean canInsertItem(TravelingItem item, IInventory inv) {
            return true;
        }
    }
}

