/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.Position;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.gates.IOverrideDefaultTriggers;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.ISolidSideTile;
import buildcraft.core.DefaultProps;
import buildcraft.core.IDropControlInventory;
import buildcraft.core.ITileBufferHolder;
import buildcraft.core.TileBuffer;
import buildcraft.core.inventory.InvUtils;
import buildcraft.core.network.IClientState;
import buildcraft.core.network.ISyncedTile;
import buildcraft.core.network.PacketTileState;
import buildcraft.core.triggers.BCTrigger;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Gate;
import buildcraft.transport.GateVanilla;
import buildcraft.transport.IPipeRenderState;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeRenderState;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TravelingItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileGenericPipe
extends TileEntity
implements IPowerReceptor,
IFluidHandler,
IPipeTile,
IOverrideDefaultTriggers,
ITileBufferHolder,
IDropControlInventory,
IPipeRenderState,
ISyncedTile,
ISolidSideTile {
    private PipeRenderState renderState = new PipeRenderState();
    private CoreState coreState = new CoreState();
    private boolean deletePipe = false;
    private TileBuffer[] tileBuffer;
    public boolean[] pipeConnectionsBuffer = new boolean[6];
    public SafeTimeTracker networkSyncTracker = new SafeTimeTracker();
    public Pipe pipe;
    private boolean blockNeighborChange = false;
    private boolean refreshRenderState = false;
    private boolean pipeBound = false;
    private int[] facadeBlocks = new int[ForgeDirection.VALID_DIRECTIONS.length];
    private int[] facadeMeta = new int[ForgeDirection.VALID_DIRECTIONS.length];
    private boolean[] plugs = new boolean[ForgeDirection.VALID_DIRECTIONS.length];
    public boolean initialized = false;

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        if (this.pipe != null) {
            nbt.func_74768_a("pipeId", this.pipe.itemID);
            this.pipe.writeToNBT(nbt);
        } else {
            nbt.func_74768_a("pipeId", this.coreState.pipeId);
        }
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            nbt.func_74768_a("facadeBlocks[" + i + "]", this.facadeBlocks[i]);
            nbt.func_74768_a("facadeMeta[" + i + "]", this.facadeMeta[i]);
            nbt.func_74757_a("plug[" + i + "]", this.plugs[i]);
        }
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.coreState.pipeId = nbt.func_74762_e("pipeId");
        this.pipe = BlockGenericPipe.createPipe(this.coreState.pipeId);
        if (this.pipe != null) {
            this.pipe.readFromNBT(nbt);
        } else {
            BuildCraftCore.bcLog.log(Level.WARNING, "Pipe failed to load from NBT at {0},{1},{2}", new Object[]{this.field_70329_l, this.field_70330_m, this.field_70327_n});
            this.deletePipe = true;
        }
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            this.facadeBlocks[i] = nbt.func_74762_e("facadeBlocks[" + i + "]");
            this.facadeMeta[i] = nbt.func_74762_e("facadeMeta[" + i + "]");
            this.plugs[i] = nbt.func_74767_n("plug[" + i + "]");
        }
    }

    public void func_70313_j() {
        this.initialized = false;
        this.tileBuffer = null;
        if (this.pipe != null) {
            this.pipe.invalidate();
        }
        super.func_70313_j();
    }

    public void func_70312_q() {
        super.func_70312_q();
        this.tileBuffer = null;
        this.bindPipe();
        if (this.pipe != null) {
            this.pipe.validate();
        }
    }

    public void func_70316_g() {
        PowerHandler.PowerReceiver provider;
        if (!this.field_70331_k.field_72995_K) {
            if (this.deletePipe) {
                this.field_70331_k.func_94571_i(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
            if (this.pipe == null) {
                return;
            }
            if (!this.initialized) {
                this.initialize(this.pipe);
            }
        }
        if (!BlockGenericPipe.isValid(this.pipe)) {
            return;
        }
        this.pipe.updateEntity();
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        if (this.blockNeighborChange) {
            this.computeConnections();
            this.pipe.onNeighborBlockChange(0);
            this.blockNeighborChange = false;
            this.refreshRenderState = true;
        }
        if (this.refreshRenderState) {
            this.refreshRenderState();
            this.refreshRenderState = false;
        }
        if ((provider = this.getPowerReceiver(null)) != null) {
            provider.update();
        }
    }

    private void refreshRenderState() {
        for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
            this.renderState.pipeConnectionMatrix.setConnected(forgeDirection, this.pipeConnectionsBuffer[forgeDirection.ordinal()]);
        }
        for (int i = 0; i < 7; ++i) {
            ForgeDirection o = ForgeDirection.getOrientation((int)i);
            this.renderState.textureMatrix.setIconIndex(o, this.pipe.getIconIndex(o));
        }
        block8: for (IPipe.WireColor wireColor : IPipe.WireColor.values()) {
            this.renderState.wireMatrix.setWire(wireColor, this.pipe.wireSet[wireColor.ordinal()]);
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                this.renderState.wireMatrix.setWireConnected(wireColor, direction, this.pipe.isWireConnectedTo(this.getTile(direction), wireColor));
            }
            boolean lit = this.pipe.signalStrength[wireColor.ordinal()] > 0;
            switch (wireColor) {
                case Red: {
                    this.renderState.wireMatrix.setWireIndex(wireColor, lit ? 1 : 0);
                    continue block8;
                }
                case Blue: {
                    this.renderState.wireMatrix.setWireIndex(wireColor, lit ? 3 : 2);
                    continue block8;
                }
                case Green: {
                    this.renderState.wireMatrix.setWireIndex(wireColor, lit ? 5 : 4);
                    continue block8;
                }
                case Yellow: {
                    this.renderState.wireMatrix.setWireIndex(wireColor, lit ? 7 : 6);
                    continue block8;
                }
            }
        }
        this.renderState.setHasGate(this.pipe.hasGate());
        this.renderState.setGateIconIndex(!this.pipe.hasGate() ? 0 : this.pipe.gate.getTextureIconIndex(this.pipe.gate.isGateActive()));
        for (IPipe.WireColor wireColor : ForgeDirection.VALID_DIRECTIONS) {
            int blockId = this.facadeBlocks[wireColor.ordinal()];
            this.renderState.facadeMatrix.setFacade((ForgeDirection)wireColor, blockId, this.facadeMeta[wireColor.ordinal()]);
        }
        for (IPipe.WireColor wireColor : ForgeDirection.VALID_DIRECTIONS) {
            this.renderState.plugMatrix.setConnected((ForgeDirection)wireColor, this.plugs[wireColor.ordinal()]);
        }
        if (this.renderState.isDirty()) {
            this.markBlockForUpdate();
            this.renderState.clean();
        }
    }

    public void initialize(Pipe pipe) {
        this.field_70324_q = this.func_70311_o();
        if (pipe == null) {
            BuildCraftCore.bcLog.log(Level.WARNING, "Pipe failed to initialize at {0},{1},{2}, deleting", new Object[]{this.field_70329_l, this.field_70330_m, this.field_70327_n});
            this.field_70331_k.func_94571_i(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            return;
        }
        this.pipe = pipe;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.getTile(o);
            if (tile instanceof ITileBufferHolder) {
                ((ITileBufferHolder)tile).blockCreated(o, BuildCraftTransport.genericPipeBlock.field_71990_ca, this);
            }
            if (!(tile instanceof TileGenericPipe)) continue;
            ((TileGenericPipe)tile).scheduleNeighborChange();
        }
        this.bindPipe();
        this.computeConnections();
        this.scheduleRenderUpdate();
        if (pipe.needsInit()) {
            pipe.initialize();
        }
        this.initialized = true;
    }

    private void bindPipe() {
        if (!this.pipeBound && this.pipe != null) {
            this.pipe.setTile(this);
            this.coreState.pipeId = this.pipe.itemID;
            this.pipeBound = true;
        }
    }

    @Override
    public IPipe getPipe() {
        return this.pipe;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe instanceof IPowerReceptor) {
            return ((IPowerReceptor)((Object)this.pipe)).getPowerReceiver(null);
        }
        return null;
    }

    @Override
    public void doWork(PowerHandler workProvider) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe instanceof IPowerReceptor) {
            ((IPowerReceptor)((Object)this.pipe)).doWork(workProvider);
        }
    }

    public void scheduleNeighborChange() {
        this.blockNeighborChange = true;
    }

    @Override
    public int injectItem(ItemStack payload, boolean doAdd, ForgeDirection from) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof PipeTransportItems && this.isPipeConnected(from)) {
            if (doAdd) {
                Position itemPos = new Position((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, from.getOpposite());
                itemPos.moveBackwards(0.4);
                TravelingItem pipedItem = new TravelingItem(itemPos.x, itemPos.y, itemPos.z, payload);
                ((PipeTransportItems)this.pipe.transport).injectItem(pipedItem, itemPos.orientation);
            }
            return payload.field_77994_a;
        }
        return 0;
    }

    @Override
    public IPipeTile.PipeType getPipeType() {
        if (BlockGenericPipe.isValid(this.pipe)) {
            return this.pipe.transport.getPipeType();
        }
        return null;
    }

    public Packet func_70319_e() {
        this.bindPipe();
        PacketTileState packet = new PacketTileState(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.coreState.gateKind = this.pipe != null && this.pipe.gate != null ? this.pipe.gate.kind.ordinal() : 0;
        if (this.pipe != null && this.pipe.transport != null) {
            this.pipe.transport.sendDescriptionPacket();
        }
        packet.addStateForSerialization((byte)0, this.coreState);
        packet.addStateForSerialization((byte)1, this.renderState);
        if (this.pipe instanceof IClientState) {
            packet.addStateForSerialization((byte)2, (IClientState)((Object)this.pipe));
        }
        return packet.getPacket();
    }

    @Override
    public LinkedList getTriggers() {
        LinkedList<BCTrigger> result = new LinkedList<BCTrigger>();
        if (BlockGenericPipe.isFullyDefined(this.pipe) && this.pipe.hasGate()) {
            result.add(BuildCraftCore.triggerRedstoneActive);
            result.add(BuildCraftCore.triggerRedstoneInactive);
        }
        return result;
    }

    @Override
    public void blockRemoved(ForgeDirection from) {
    }

    public TileBuffer[] getTileCache() {
        if (this.tileBuffer == null && this.pipe != null) {
            this.tileBuffer = TileBuffer.makeBuffer(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.pipe.transport.delveIntoUnloadedChunks());
        }
        return this.tileBuffer;
    }

    @Override
    public void blockCreated(ForgeDirection from, int blockID, TileEntity tile) {
        TileBuffer[] cache = this.getTileCache();
        if (cache != null) {
            cache[from.getOpposite().ordinal()].set(blockID, tile);
        }
    }

    @Override
    public int getBlockId(ForgeDirection to) {
        TileBuffer[] cache = this.getTileCache();
        if (cache != null) {
            return cache[to.ordinal()].getBlockID();
        }
        return 0;
    }

    @Override
    public TileEntity getTile(ForgeDirection to) {
        TileBuffer[] cache = this.getTileCache();
        if (cache != null) {
            return cache[to.ordinal()].getTile();
        }
        return null;
    }

    protected boolean canPipeConnect(TileEntity with, ForgeDirection side) {
        IPipeConnection.ConnectOverride override;
        if (with == null) {
            return false;
        }
        if (this.hasPlug(side)) {
            return false;
        }
        if (!BlockGenericPipe.isValid(this.pipe)) {
            return false;
        }
        if (with instanceof IPipeConnection && (override = ((IPipeConnection)with).overridePipeConnection(this.pipe.transport.getPipeType(), side.getOpposite())) != IPipeConnection.ConnectOverride.DEFAULT) {
            return override == IPipeConnection.ConnectOverride.CONNECT;
        }
        if (with instanceof TileGenericPipe) {
            if (((TileGenericPipe)with).hasPlug(side.getOpposite())) {
                return false;
            }
            Pipe otherPipe = ((TileGenericPipe)with).pipe;
            if (!BlockGenericPipe.isValid(otherPipe)) {
                return false;
            }
            if (!otherPipe.canPipeConnect(this, side.getOpposite())) {
                return false;
            }
        }
        return this.pipe.canPipeConnect(with, side);
    }

    private void computeConnections() {
        TileBuffer[] cache = this.getTileCache();
        if (cache == null) {
            return;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileBuffer t = cache[side.ordinal()];
            t.refresh();
            this.pipeConnectionsBuffer[side.ordinal()] = this.canPipeConnect(t.getTile(), side);
        }
    }

    @Override
    public boolean isPipeConnected(ForgeDirection with) {
        if (this.field_70331_k.field_72995_K) {
            return this.renderState.pipeConnectionMatrix.isConnected(with);
        }
        return this.pipeConnectionsBuffer[with.ordinal()];
    }

    @Override
    public boolean doDrop() {
        if (BlockGenericPipe.isValid(this.pipe)) {
            return this.pipe.doDrop();
        }
        return false;
    }

    public void onChunkUnload() {
        if (this.pipe != null) {
            this.pipe.onChunkUnload();
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof IFluidHandler && !this.hasPlug(from)) {
            return ((IFluidHandler)this.pipe.transport).fill(from, resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof IFluidHandler && !this.hasPlug(from)) {
            return ((IFluidHandler)this.pipe.transport).drain(from, maxDrain, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof IFluidHandler && !this.hasPlug(from)) {
            return ((IFluidHandler)this.pipe.transport).drain(from, resource, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof IFluidHandler && !this.hasPlug(from)) {
            return ((IFluidHandler)this.pipe.transport).canFill(from, fluid);
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (BlockGenericPipe.isValid(this.pipe) && this.pipe.transport instanceof IFluidHandler && !this.hasPlug(from)) {
            return ((IFluidHandler)this.pipe.transport).canDrain(from, fluid);
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return null;
    }

    public void scheduleRenderUpdate() {
        this.refreshRenderState = true;
    }

    public boolean addFacade(ForgeDirection direction, int blockid, int meta) {
        if (this.field_70331_k.field_72995_K) {
            return false;
        }
        if (this.facadeBlocks[direction.ordinal()] == blockid) {
            return false;
        }
        if (this.hasFacade(direction)) {
            this.dropFacadeItem(direction);
        }
        this.facadeBlocks[direction.ordinal()] = blockid;
        this.facadeMeta[direction.ordinal()] = meta;
        this.field_70331_k.func_72851_f(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getBlockId());
        this.scheduleRenderUpdate();
        return true;
    }

    public boolean hasFacade(ForgeDirection direction) {
        if (this.field_70331_k.field_72995_K) {
            return this.renderState.facadeMatrix.getFacadeBlockId(direction) != 0;
        }
        return this.facadeBlocks[direction.ordinal()] != 0;
    }

    private void dropFacadeItem(ForgeDirection direction) {
        InvUtils.dropItems(this.field_70331_k, ItemFacade.getStack(this.facadeBlocks[direction.ordinal()], this.facadeMeta[direction.ordinal()]), this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void dropFacade(ForgeDirection direction) {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        if (!this.hasFacade(direction)) {
            return;
        }
        this.dropFacadeItem(direction);
        this.facadeBlocks[direction.ordinal()] = 0;
        this.facadeMeta[direction.ordinal()] = 0;
        this.field_70331_k.func_72851_f(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getBlockId());
        this.scheduleRenderUpdate();
    }

    @Override
    public PipeRenderState getRenderState() {
        return this.renderState;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getPipeIcons() {
        if (this.pipe == null) {
            return null;
        }
        return this.pipe.getIconProvider();
    }

    @Override
    public IClientState getStateInstance(byte stateId) {
        switch (stateId) {
            case 0: {
                return this.coreState;
            }
            case 1: {
                return this.renderState;
            }
            case 2: {
                return (IClientState)((Object)this.pipe);
            }
        }
        throw new RuntimeException("Unknown state requested: " + stateId + " this is a bug!");
    }

    @Override
    public void afterStateUpdated(byte stateId) {
        if (!this.field_70331_k.field_72995_K) {
            return;
        }
        switch (stateId) {
            case 0: {
                if (this.pipe == null && this.coreState.pipeId != 0) {
                    this.initialize(BlockGenericPipe.createPipe(this.coreState.pipeId));
                }
                if (this.pipe == null || this.coreState.gateKind == Gate.GateKind.None.ordinal()) break;
                if (this.pipe.gate == null) {
                    this.pipe.gate = new GateVanilla(this.pipe);
                }
                this.pipe.gate.kind = Gate.GateKind.values()[this.coreState.gateKind];
            }
        }
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_82115_m() {
        return DefaultProps.PIPE_CONTENTS_RENDER_DIST * DefaultProps.PIPE_CONTENTS_RENDER_DIST;
    }

    public boolean shouldRefresh(int oldID, int newID, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return oldID != newID;
    }

    @Override
    public boolean isSolidOnSide(ForgeDirection side) {
        if (this.hasFacade(side)) {
            return true;
        }
        return BlockGenericPipe.isValid(this.pipe) && this.pipe instanceof ISolidSideTile && ((ISolidSideTile)((Object)this.pipe)).isSolidOnSide(side);
    }

    public boolean hasPlug(ForgeDirection side) {
        if (side == null || side == ForgeDirection.UNKNOWN) {
            return false;
        }
        if (this.field_70331_k.field_72995_K) {
            return this.renderState.plugMatrix.isConnected(side);
        }
        return this.plugs[side.ordinal()];
    }

    public void removeAndDropPlug(ForgeDirection side) {
        if (!this.hasPlug(side)) {
            return;
        }
        this.plugs[side.ordinal()] = false;
        InvUtils.dropItems(this.field_70331_k, new ItemStack(BuildCraftTransport.plugItem), this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.field_70331_k.func_72851_f(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getBlockId());
        this.scheduleNeighborChange();
        this.scheduleRenderUpdate();
    }

    public boolean addPlug(ForgeDirection forgeDirection) {
        if (this.hasPlug(forgeDirection)) {
            return false;
        }
        this.plugs[forgeDirection.ordinal()] = true;
        this.field_70331_k.func_72851_f(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getBlockId());
        this.scheduleNeighborChange();
        this.scheduleRenderUpdate();
        return true;
    }

    public int getBlockId() {
        Block block = this.func_70311_o();
        if (block != null) {
            return block.field_71990_ca;
        }
        return 0;
    }

    @Override
    public World getWorld() {
        return this.field_70331_k;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) == this;
    }

    public void markBlockForUpdate() {
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    private class CoreState
    implements IClientState {
        public int pipeId = -1;
        public int gateKind = 0;

        private CoreState() {
        }

        @Override
        public void writeData(DataOutputStream data) throws IOException {
            data.writeInt(this.pipeId);
            data.writeInt(this.gateKind);
        }

        @Override
        public void readData(DataInputStream data) throws IOException {
            this.pipeId = data.readInt();
            this.gateKind = data.readInt();
        }
    }
}

