/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.Position;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.gates.IAction;
import buildcraft.api.gates.IActionReceptor;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.core.BlockIndex;
import buildcraft.core.EntityEnergyLaser;
import buildcraft.core.IMachine;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.triggers.ActionMachineControl;
import buildcraft.silicon.ILaserTarget;
import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class TileLaser
extends TileBuildCraft
implements IPowerReceptor,
IActionReceptor,
IMachine {
    private EntityEnergyLaser laser = null;
    private final SafeTimeTracker laserTickTracker = new SafeTimeTracker();
    private final SafeTimeTracker searchTracker = new SafeTimeTracker();
    private final SafeTimeTracker networkTracker = new SafeTimeTracker();
    private ILaserTarget laserTarget;
    protected PowerHandler powerHandler;
    private int nextNetworkUpdate = 3;
    private int nextLaserUpdate = 10;
    private int nextLaserSearch = 100;
    private ActionMachineControl.Mode lastMode = ActionMachineControl.Mode.Unknown;
    private static final PowerHandler.PerditionCalculator PERDITION = new PowerHandler.PerditionCalculator(0.5f);

    public TileLaser() {
        this.powerHandler = new PowerHandler(this, PowerHandler.Type.MACHINE);
        this.initPowerProvider();
    }

    private void initPowerProvider() {
        this.powerHandler.configure(25.0f, 150.0f, 25.0f, 1000.0f);
        this.powerHandler.setPerdition(PERDITION);
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!CoreProxy.proxy.isSimulating(this.field_70331_k)) {
            return;
        }
        if (this.powerHandler.getEnergyStored() == 0.0f) {
            this.removeLaser();
            return;
        }
        if (this.lastMode == ActionMachineControl.Mode.Off) {
            this.removeLaser();
            return;
        }
        if (!this.isValidTable() && this.canFindTable()) {
            this.findTable();
        }
        if (!this.isValidTable()) {
            this.removeLaser();
            return;
        }
        if (this.laser == null) {
            this.createLaser();
        }
        if (this.laser != null && this.canUpdateLaser()) {
            this.updateLaser();
        }
        float power = this.powerHandler.useEnergy(0.0f, this.getMaxPowerSent(), true);
        this.laserTarget.receiveLaserEnergy(power);
        if (this.laser != null) {
            this.laser.pushPower(power);
        }
        this.onPowerSent(power);
        this.sendNetworkUpdate();
    }

    protected float getMaxPowerSent() {
        return 4.0f;
    }

    protected void onPowerSent(float power) {
    }

    protected boolean canFindTable() {
        return this.searchTracker.markTimeIfDelay(this.field_70331_k, this.nextLaserSearch);
    }

    protected boolean canUpdateLaser() {
        return this.laserTickTracker.markTimeIfDelay(this.field_70331_k, this.nextLaserUpdate);
    }

    protected boolean isValidTable() {
        return this.laserTarget != null && !this.laserTarget.isInvalidTarget() && this.laserTarget.hasCurrentWork();
    }

    protected void findTable() {
        int meta = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        int minX = this.field_70329_l - 5;
        int minY = this.field_70330_m - 5;
        int minZ = this.field_70327_n - 5;
        int maxX = this.field_70329_l + 5;
        int maxY = this.field_70330_m + 5;
        int maxZ = this.field_70327_n + 5;
        switch (ForgeDirection.values()[meta]) {
            case WEST: {
                maxX = this.field_70329_l;
                break;
            }
            case EAST: {
                minX = this.field_70329_l;
                break;
            }
            case DOWN: {
                maxY = this.field_70330_m;
                break;
            }
            case UP: {
                minY = this.field_70330_m;
                break;
            }
            case NORTH: {
                maxZ = this.field_70327_n;
                break;
            }
            default: {
                minZ = this.field_70327_n;
            }
        }
        LinkedList<BlockIndex> targets = new LinkedList<BlockIndex>();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    ILaserTarget table;
                    TileEntity tile = this.field_70331_k.func_72796_p(x, y, z);
                    if (!(tile instanceof ILaserTarget) || !(table = (ILaserTarget)tile).hasCurrentWork()) continue;
                    targets.add(new BlockIndex(x, y, z));
                }
            }
        }
        if (targets.size() == 0) {
            return;
        }
        BlockIndex b = (BlockIndex)targets.get(this.field_70331_k.field_73012_v.nextInt(targets.size()));
        this.laserTarget = (ILaserTarget)this.field_70331_k.func_72796_p(b.x, b.y, b.z);
    }

    protected void createLaser() {
        this.laser = new EntityEnergyLaser(this.field_70331_k, new Position(this.field_70329_l, this.field_70330_m, this.field_70327_n), new Position(this.field_70329_l, this.field_70330_m, this.field_70327_n));
        this.field_70331_k.func_72838_d((Entity)this.laser);
    }

    protected void updateLaser() {
        int meta = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        double px = 0.0;
        double py = 0.0;
        double pz = 0.0;
        switch (ForgeDirection.values()[meta]) {
            case WEST: {
                px = -0.3;
                break;
            }
            case EAST: {
                px = 0.3;
                break;
            }
            case DOWN: {
                py = -0.3;
                break;
            }
            case UP: {
                py = 0.3;
                break;
            }
            case NORTH: {
                pz = -0.3;
                break;
            }
            default: {
                pz = 0.3;
            }
        }
        Position head = new Position((double)this.field_70329_l + 0.5 + px, (double)this.field_70330_m + 0.5 + py, (double)this.field_70327_n + 0.5 + pz);
        Position tail = new Position((double)this.laserTarget.getXCoord() + 0.475 + ((double)this.field_70331_k.field_73012_v.nextFloat() - 0.5) / 5.0, (float)this.laserTarget.getYCoord() + 0.5625f, (double)this.laserTarget.getZCoord() + 0.475 + ((double)this.field_70331_k.field_73012_v.nextFloat() - 0.5) / 5.0);
        this.laser.setPositions(head, tail);
        if (!this.laser.isVisible()) {
            this.laser.show();
        }
    }

    protected void removeLaser() {
        if (this.laser != null) {
            this.laser.func_70106_y();
            this.laser = null;
        }
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.powerHandler.getPowerReceiver();
    }

    @Override
    public void doWork(PowerHandler workProvider) {
    }

    @Override
    public void sendNetworkUpdate() {
        if (this.networkTracker.markTimeIfDelay(this.field_70331_k, this.nextNetworkUpdate)) {
            super.sendNetworkUpdate();
        }
    }

    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.powerHandler.readFromNBT(nbttagcompound);
        this.initPowerProvider();
    }

    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        this.powerHandler.writeToNBT(nbttagcompound);
    }

    @Override
    public void func_70313_j() {
        super.func_70313_j();
        this.removeLaser();
    }

    @Override
    public boolean isActive() {
        return this.laser != null;
    }

    @Override
    public boolean manageFluids() {
        return false;
    }

    @Override
    public boolean manageSolids() {
        return false;
    }

    @Override
    public boolean allowAction(IAction action) {
        return action == BuildCraftCore.actionOn || action == BuildCraftCore.actionOff;
    }

    @Override
    public void actionActivated(IAction action) {
        if (action == BuildCraftCore.actionOn) {
            this.lastMode = ActionMachineControl.Mode.On;
        } else if (action == BuildCraftCore.actionOff) {
            this.lastMode = ActionMachineControl.Mode.Off;
        }
    }
}

