/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.fluids.Tank;
import buildcraft.core.fluids.TankManager;
import buildcraft.core.network.PacketPayload;
import buildcraft.core.network.PacketPayloadStream;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.proxy.CoreProxy;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileTank
extends TileBuildCraft
implements IFluidHandler {
    public final Tank tank = new Tank("tank", 16000);
    public final TankManager tankManager = new TankManager(this.tank);
    public boolean hasUpdate = false;
    public SafeTimeTracker tracker = new SafeTimeTracker();

    @Override
    public void func_70316_g() {
        if (CoreProxy.proxy.isRenderWorld(this.field_70331_k)) {
            return;
        }
        if (this.tank.getFluid() != null) {
            this.moveFluidBelow();
        }
        if (this.hasUpdate && this.tracker.markTimeIfDelay(this.field_70331_k, 2 * BuildCraftCore.updateFactor)) {
            this.sendNetworkUpdate();
            this.hasUpdate = false;
        }
    }

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayloadStream payload = new PacketPayloadStream(new PacketPayloadStream.StreamWriter(){

            @Override
            public void writeData(DataOutputStream data) throws IOException {
                TileTank.this.tankManager.writeData(data);
            }
        });
        return payload;
    }

    @Override
    public void handleUpdatePacket(PacketUpdate packet) throws IOException {
        DataInputStream stream = ((PacketPayloadStream)packet.payload).stream;
        this.tankManager.readData(stream);
    }

    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.tankManager.readFromNBT(data);
    }

    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        this.tankManager.writeToNBT(data);
    }

    public TileTank getBottomTank() {
        TileTank below;
        TileTank lastTank = this;
        while ((below = TileTank.getTankBelow(lastTank)) != null) {
            lastTank = below;
        }
        return lastTank;
    }

    public TileTank getTopTank() {
        TileTank above;
        TileTank lastTank = this;
        while ((above = TileTank.getTankAbove(lastTank)) != null) {
            lastTank = above;
        }
        return lastTank;
    }

    public static TileTank getTankBelow(TileTank tile) {
        TileEntity below = tile.field_70331_k.func_72796_p(tile.field_70329_l, tile.field_70330_m - 1, tile.field_70327_n);
        if (below instanceof TileTank) {
            return (TileTank)below;
        }
        return null;
    }

    public static TileTank getTankAbove(TileTank tile) {
        TileEntity above = tile.field_70331_k.func_72796_p(tile.field_70329_l, tile.field_70330_m + 1, tile.field_70327_n);
        if (above instanceof TileTank) {
            return (TileTank)above;
        }
        return null;
    }

    public void moveFluidBelow() {
        TileTank below = TileTank.getTankBelow(this);
        if (below == null) {
            return;
        }
        int used = below.tank.fill(this.tank.getFluid(), true);
        if (used > 0) {
            this.hasUpdate = true;
            below.hasUpdate = true;
            this.tank.drain(used, true);
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        resource = resource.copy();
        int totalUsed = 0;
        TileTank tankToFill = this.getBottomTank();
        FluidStack liquid = tankToFill.tank.getFluid();
        if (liquid != null && liquid.amount > 0 && !liquid.isFluidEqual(resource)) {
            return 0;
        }
        while (tankToFill != null && resource.amount > 0) {
            int used = tankToFill.tank.fill(resource, doFill);
            resource.amount -= used;
            if (used > 0) {
                tankToFill.hasUpdate = true;
            }
            totalUsed += used;
            tankToFill = TileTank.getTankAbove(tankToFill);
        }
        return totalUsed;
    }

    public FluidStack drain(ForgeDirection from, int maxEmpty, boolean doDrain) {
        TileTank bottom = this.getBottomTank();
        bottom.hasUpdate = true;
        return bottom.tank.drain(maxEmpty, doDrain);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (!resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection direction) {
        FluidTank compositeTank = new FluidTank(this.tank.getCapacity());
        TileTank tile = this.getBottomTank();
        int capacity = this.tank.getCapacity();
        if (tile == null || tile.tank.getFluid() == null) {
            return new FluidTankInfo[]{compositeTank.getInfo()};
        }
        compositeTank.setFluid(tile.tank.getFluid().copy());
        tile = TileTank.getTankAbove(tile);
        while (tile != null) {
            FluidStack liquid = tile.tank.getFluid();
            if (liquid != null && liquid.amount != 0) {
                if (!compositeTank.getFluid().isFluidEqual(liquid)) break;
                compositeTank.getFluid().amount += liquid.amount;
            }
            capacity += tile.tank.getCapacity();
            tile = TileTank.getTankAbove(tile);
        }
        compositeTank.setCapacity(capacity);
        return new FluidTankInfo[]{compositeTank.getInfo()};
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }
}

