/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftFactory;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.gates.IAction;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.core.BlockIndex;
import buildcraft.core.EntityBlock;
import buildcraft.core.IMachine;
import buildcraft.core.TileBuffer;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.fluids.FluidUtils;
import buildcraft.core.fluids.SingleUseTank;
import buildcraft.core.network.PacketPayload;
import buildcraft.core.network.PacketPayloadStream;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.BlockUtil;
import buildcraft.core.utils.Utils;
import buildcraft.factory.FactoryProxy;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TilePump
extends TileBuildCraft
implements IMachine,
IPowerReceptor,
IFluidHandler {
    public static int REBUID_DELAY = 512;
    public static int MAX_LIQUID = 16000;
    EntityBlock tube;
    private TreeMap pumpLayerQueues = new TreeMap();
    SingleUseTank tank;
    double tubeY = Double.NaN;
    int aimY = 0;
    private PowerHandler powerHandler;
    private TileBuffer[] tileBuffer = null;
    private SafeTimeTracker timer = new SafeTimeTracker();
    private int tick = Utils.RANDOM.nextInt();
    private int numFluidBlocksFound = 0;

    public TilePump() {
        this.powerHandler = new PowerHandler(this, PowerHandler.Type.MACHINE);
        this.initPowerProvider();
        this.tank = new SingleUseTank("tank", MAX_LIQUID);
    }

    private void initPowerProvider() {
        this.powerHandler.configure(1.0f, 15.0f, 10.0f, 100.0f);
        this.powerHandler.configurePowerPerdition(1, 100);
    }

    @Override
    public void func_70316_g() {
        FluidStack fluidToPump;
        super.func_70316_g();
        if (this.tube == null) {
            return;
        }
        if (CoreProxy.proxy.isRenderWorld(this.field_70331_k)) {
            return;
        }
        this.pushToConsumers();
        if (this.tube.field_70163_u - (double)this.aimY > 0.01) {
            this.tubeY = this.tube.field_70163_u - 0.01;
            this.setTubePosition();
            this.sendNetworkUpdate();
            return;
        }
        ++this.tick;
        if (this.tick % 16 != 0) {
            return;
        }
        BlockIndex index = this.getNextIndexToPump(false);
        FluidStack fluidStack = fluidToPump = index != null ? BlockUtil.drainBlock(this.field_70331_k, index.x, index.y, index.z, false) : null;
        if (fluidToPump != null) {
            if (this.isFluidAllowed(fluidToPump.getFluid()) && this.tank.fill(fluidToPump, false) == fluidToPump.amount && this.powerHandler.useEnergy(10.0f, 10.0f, true) == 10.0f) {
                if (fluidToPump.getFluid() != FluidRegistry.WATER || BuildCraftCore.consumeWaterSources || this.numFluidBlocksFound < 9) {
                    index = this.getNextIndexToPump(true);
                    BlockUtil.drainBlock(this.field_70331_k, index.x, index.y, index.z, true);
                }
                this.tank.fill(fluidToPump, true);
            }
        } else if (this.tick % 128 == 0) {
            this.rebuildQueue();
            if (this.getNextIndexToPump(false) == null) {
                for (int y = this.field_70330_m - 1; y > 0; --y) {
                    if (this.isPumpableFluid(this.field_70329_l, y, this.field_70327_n)) {
                        this.aimY = y;
                        return;
                    }
                    if (this.field_70331_k.func_72799_c(this.field_70329_l, y, this.field_70327_n)) continue;
                    return;
                }
            }
        }
    }

    private void pushToConsumers() {
        if (this.tileBuffer == null) {
            this.tileBuffer = TileBuffer.makeBuffer(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, false);
        }
        FluidUtils.pushFluidToConsumers((IFluidTank)this.tank, 400, this.tileBuffer);
    }

    private TileEntity getTile(ForgeDirection side) {
        if (this.tileBuffer == null) {
            this.tileBuffer = TileBuffer.makeBuffer(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, false);
        }
        return this.tileBuffer[side.ordinal()].getTile();
    }

    @Override
    public void initialize() {
        this.tube = FactoryProxy.proxy.newPumpTube(this.field_70331_k);
        this.tube.field_70163_u = !Double.isNaN(this.tubeY) ? this.tubeY : (double)this.field_70330_m;
        this.tubeY = this.tube.field_70163_u;
        if (this.aimY == 0) {
            this.aimY = this.field_70330_m;
        }
        this.setTubePosition();
        this.field_70331_k.func_72838_d((Entity)this.tube);
        if (CoreProxy.proxy.isSimulating(this.field_70331_k)) {
            this.sendNetworkUpdate();
        }
    }

    private BlockIndex getNextIndexToPump(boolean remove) {
        if (this.pumpLayerQueues.isEmpty()) {
            if (this.timer.markTimeIfDelay(this.field_70331_k, REBUID_DELAY)) {
                this.rebuildQueue();
            }
            return null;
        }
        Deque topLayer = (Deque)this.pumpLayerQueues.lastEntry().getValue();
        if (topLayer != null) {
            if (topLayer.isEmpty()) {
                this.pumpLayerQueues.pollLastEntry();
            }
            if (remove) {
                BlockIndex index = (BlockIndex)topLayer.pollLast();
                return index;
            }
            return (BlockIndex)topLayer.peekLast();
        }
        return null;
    }

    private Deque getLayerQueue(int layer) {
        LinkedList pumpQueue = (LinkedList)this.pumpLayerQueues.get(layer);
        if (pumpQueue == null) {
            pumpQueue = new LinkedList();
            this.pumpLayerQueues.put(layer, pumpQueue);
        }
        return pumpQueue;
    }

    public void rebuildQueue() {
        this.numFluidBlocksFound = 0;
        this.pumpLayerQueues.clear();
        int x = this.field_70329_l;
        int y = this.aimY;
        int z = this.field_70327_n;
        Fluid pumpingFluid = BlockUtil.getFluid(this.field_70331_k.func_72798_a(x, y, z));
        if (pumpingFluid == null) {
            return;
        }
        if (pumpingFluid != this.tank.getAcceptedFluid() && this.tank.getAcceptedFluid() != null) {
            return;
        }
        HashSet visitedBlocks = new HashSet();
        LinkedList fluidsFound = new LinkedList();
        this.queueForPumping(x, y, z, visitedBlocks, fluidsFound, pumpingFluid);
        while (!fluidsFound.isEmpty()) {
            LinkedList fluidsToExpand = fluidsFound;
            fluidsFound = new LinkedList();
            for (BlockIndex index : fluidsToExpand) {
                this.queueForPumping(index.x, index.y + 1, index.z, visitedBlocks, fluidsFound, pumpingFluid);
                this.queueForPumping(index.x + 1, index.y, index.z, visitedBlocks, fluidsFound, pumpingFluid);
                this.queueForPumping(index.x - 1, index.y, index.z, visitedBlocks, fluidsFound, pumpingFluid);
                this.queueForPumping(index.x, index.y, index.z + 1, visitedBlocks, fluidsFound, pumpingFluid);
                this.queueForPumping(index.x, index.y, index.z - 1, visitedBlocks, fluidsFound, pumpingFluid);
                if (pumpingFluid != FluidRegistry.WATER || BuildCraftCore.consumeWaterSources || this.numFluidBlocksFound < 9) continue;
                return;
            }
        }
    }

    public void queueForPumping(int x, int y, int z, Set visitedBlocks, Deque fluidsFound, Fluid pumpingFluid) {
        BlockIndex index = new BlockIndex(x, y, z);
        if (visitedBlocks.add(index)) {
            if ((x - this.field_70329_l) * (x - this.field_70329_l) + (z - this.field_70327_n) * (z - this.field_70327_n) > 4096) {
                return;
            }
            int blockId = this.field_70331_k.func_72798_a(x, y, z);
            if (BlockUtil.getFluid(blockId) == pumpingFluid) {
                fluidsFound.add(index);
            }
            if (this.canDrainBlock(blockId, x, y, z, pumpingFluid)) {
                this.getLayerQueue(y).add(index);
                ++this.numFluidBlocksFound;
            }
        }
    }

    private boolean isPumpableFluid(int x, int y, int z) {
        Fluid fluid = BlockUtil.getFluid(this.field_70331_k.func_72798_a(x, y, z));
        if (fluid == null) {
            return false;
        }
        return this.isFluidAllowed(fluid);
    }

    private boolean canDrainBlock(int blockId, int x, int y, int z, Fluid fluid) {
        if (!this.isFluidAllowed(fluid)) {
            return false;
        }
        FluidStack fluidStack = BlockUtil.drainBlock(blockId, this.field_70331_k, x, y, z, false);
        if (fluidStack == null || fluidStack.amount <= 0) {
            return false;
        }
        return fluidStack.getFluid() == fluid;
    }

    private boolean isFluidAllowed(Fluid fluid) {
        return BuildCraftFactory.pumpDimensionList.isFluidAllowed(fluid, this.field_70331_k.field_73011_w.field_76574_g);
    }

    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.powerHandler.readFromNBT(data);
        this.tank.readFromNBT(data);
        this.aimY = data.func_74762_e("aimY");
        this.tubeY = data.func_74760_g("tubeY");
        this.initPowerProvider();
    }

    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        this.powerHandler.writeToNBT(data);
        this.tank.writeToNBT(data);
        data.func_74768_a("aimY", this.aimY);
        if (this.tube != null) {
            data.func_74776_a("tubeY", (float)this.tube.field_70163_u);
        } else {
            data.func_74776_a("tubeY", (float)this.field_70330_m);
        }
    }

    @Override
    public boolean isActive() {
        BlockIndex next = this.getNextIndexToPump(false);
        if (next != null) {
            return this.isPumpableFluid(next.x, next.y, next.z);
        }
        return false;
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.powerHandler.getPowerReceiver();
    }

    @Override
    public void doWork(PowerHandler workProvider) {
    }

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayloadStream payload = new PacketPayloadStream(new PacketPayloadStream.StreamWriter(){

            @Override
            public void writeData(DataOutputStream data) throws IOException {
                data.writeInt(TilePump.this.aimY);
                data.writeFloat((float)TilePump.this.tubeY);
            }
        });
        return payload;
    }

    @Override
    public void handleUpdatePacket(PacketUpdate packet) throws IOException {
        PacketPayloadStream payload = (PacketPayloadStream)packet.payload;
        DataInputStream data = payload.stream;
        this.aimY = data.readInt();
        this.tubeY = data.readFloat();
        this.setTubePosition();
    }

    @Override
    public void handleDescriptionPacket(PacketUpdate packet) throws IOException {
        this.handleUpdatePacket(packet);
    }

    private void setTubePosition() {
        if (this.tube != null) {
            this.tube.iSize = 0.5;
            this.tube.kSize = 0.5;
            this.tube.jSize = (double)this.field_70330_m - this.tube.field_70163_u;
            this.tube.func_70107_b((float)this.field_70329_l + 0.25f, this.tubeY, (float)this.field_70327_n + 0.25f);
        }
    }

    @Override
    public void func_70313_j() {
        super.func_70313_j();
        this.destroy();
    }

    public void func_70312_q() {
        this.tileBuffer = null;
        super.func_70312_q();
    }

    @Override
    public void destroy() {
        this.tileBuffer = null;
        this.pumpLayerQueues.clear();
        if (this.tube != null) {
            CoreProxy.proxy.removeEntity(this.tube);
            this.tube = null;
            this.tubeY = Double.NaN;
            this.aimY = 0;
        }
    }

    @Override
    public boolean manageFluids() {
        return true;
    }

    @Override
    public boolean manageSolids() {
        return false;
    }

    @Override
    public boolean allowAction(IAction action) {
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource != null && !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }
}

