/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.fluids.Fluid;

public class PumpDimensionList {
    private List entries = new LinkedList();

    public PumpDimensionList(String string) {
        for (String entryString : string.trim().split(",")) {
            Entry e = new Entry();
            if (entryString.startsWith("+/")) {
                e.isWhitelist = true;
            } else if (entryString.startsWith("-/")) {
                e.isWhitelist = false;
            } else {
                throw new RuntimeException("Malformed pumping.controlList entry: " + entryString + " (must start with +/ or -/)");
            }
            entryString = entryString.substring(2);
            int i = entryString.indexOf(47);
            if (i < 0) {
                throw new RuntimeException("Malformed pumping.controlList entry: " + entryString + " (missing second /)");
            }
            String dimIDString = entryString.substring(0, i);
            if (dimIDString.equals("*")) {
                e.matchAnyDim = true;
            } else {
                e.dimID = Integer.parseInt(dimIDString);
            }
            e.fluidName = entryString.substring(i + 1);
            if (e.fluidName.equals("*")) {
                e.matchAnyFluid = true;
            }
            this.entries.add(0, e);
        }
        this.entries = new ArrayList(this.entries);
    }

    public boolean isFluidAllowed(Fluid fluid, int dim) {
        for (Entry e : this.entries) {
            if (!e.matches(fluid, dim)) continue;
            return e.isWhitelist;
        }
        return false;
    }

    private class Entry {
        boolean isWhitelist;
        String fluidName;
        int dimID;
        boolean matchAnyFluid;
        boolean matchAnyDim;

        private Entry() {
        }

        boolean matches(Fluid fluid, int dim) {
            if (!this.matchAnyFluid && !fluid.getName().equals(this.fluidName)) {
                return false;
            }
            return this.matchAnyDim || this.dimID == dim;
        }
    }
}

