/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftFactory;
import buildcraft.api.core.Position;
import buildcraft.api.tools.IToolWrench;
import buildcraft.core.Box;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.Utils;
import buildcraft.factory.BlockMachineRoot;
import buildcraft.factory.TileQuarry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockQuarry
extends BlockMachineRoot {
    Icon textureTop;
    Icon textureFront;
    Icon textureSide;

    public BlockQuarry(int i) {
        super(i, Material.field_76243_f);
        this.func_71848_c(1.5f);
        this.func_71894_b(10.0f);
        this.func_71884_a(field_71976_h);
    }

    public void func_71860_a(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        super.func_71860_a(world, i, j, k, entityliving, stack);
        ForgeDirection orientation = Utils.get2dOrientation(new Position(entityliving.field_70165_t, entityliving.field_70163_u, entityliving.field_70161_v), new Position(i, j, k));
        world.func_72921_c(i, j, k, orientation.getOpposite().ordinal(), 1);
        if (entityliving instanceof EntityPlayer) {
            TileQuarry tq = (TileQuarry)world.func_72796_p(i, j, k);
            tq.placedBy = (EntityPlayer)entityliving;
        }
    }

    public Icon func_71858_a(int i, int j) {
        if (j == 0 && i == 3) {
            return this.textureFront;
        }
        if (i == j && i > 1) {
            return this.textureFront;
        }
        switch (i) {
            case 1: {
                return this.textureTop;
            }
        }
        return this.textureSide;
    }

    public TileEntity func_72274_a(World var1) {
        return new TileQuarry();
    }

    public void searchFrames(World world, int i, int j, int k) {
        int width2 = 1;
        if (!world.func_72904_c(i - width2, j - width2, k - width2, i + width2, j + width2, k + width2)) {
            return;
        }
        int blockID = world.func_72798_a(i, j, k);
        if (blockID != BuildCraftFactory.frameBlock.field_71990_ca) {
            return;
        }
        int meta = world.func_72805_g(i, j, k);
        if ((meta & 8) == 0) {
            ForgeDirection[] dirs;
            world.func_72921_c(i, j, k, meta | 8, 0);
            for (ForgeDirection dir : dirs = ForgeDirection.VALID_DIRECTIONS) {
                switch (dir) {
                    case UP: {
                        this.searchFrames(world, i, j + 1, k);
                    }
                    case DOWN: {
                        this.searchFrames(world, i, j - 1, k);
                    }
                    case SOUTH: {
                        this.searchFrames(world, i, j, k + 1);
                    }
                    case NORTH: {
                        this.searchFrames(world, i, j, k - 1);
                    }
                    case EAST: {
                        this.searchFrames(world, i + 1, j, k);
                    }
                }
                this.searchFrames(world, i - 1, j, k);
            }
        }
    }

    private void markFrameForDecay(World world, int x, int y, int z) {
        if (world.func_72798_a(x, y, z) == BuildCraftFactory.frameBlock.field_71990_ca) {
            world.func_72921_c(x, y, z, 1, 0);
        }
    }

    public void func_71852_a(World world, int i, int j, int k, int par5, int par6) {
        if (!CoreProxy.proxy.isSimulating(world)) {
            return;
        }
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile instanceof TileQuarry) {
            TileQuarry quarry = (TileQuarry)tile;
            Box box = quarry.box;
            if (box.isInitialized() && Integer.MAX_VALUE != box.xMax) {
                for (int x = box.xMin; x <= box.xMax; ++x) {
                    this.markFrameForDecay(world, x, box.yMin, box.zMin);
                    this.markFrameForDecay(world, x, box.yMax, box.zMin);
                    this.markFrameForDecay(world, x, box.yMin, box.zMax);
                    this.markFrameForDecay(world, x, box.yMax, box.zMax);
                }
                for (int z = box.zMin + 1; z <= box.zMax - 1; ++z) {
                    this.markFrameForDecay(world, box.xMin, box.yMin, z);
                    this.markFrameForDecay(world, box.xMax, box.yMin, z);
                    this.markFrameForDecay(world, box.xMin, box.yMax, z);
                    this.markFrameForDecay(world, box.xMax, box.yMax, z);
                }
                for (int y = box.yMin + 1; y <= box.yMax - 1; ++y) {
                    this.markFrameForDecay(world, box.xMin, y, box.zMin);
                    this.markFrameForDecay(world, box.xMax, y, box.zMin);
                    this.markFrameForDecay(world, box.xMin, y, box.zMax);
                    this.markFrameForDecay(world, box.xMax, y, box.zMax);
                }
            }
            quarry.destroy();
        }
        Utils.preDestroyBlock(world, i, j, k);
        super.func_71852_a(world, i, j, k, par5, par6);
    }

    public boolean func_71903_a(World world, int i, int j, int k, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        Item equipped;
        TileQuarry tile = (TileQuarry)world.func_72796_p(i, j, k);
        if (entityplayer.func_70093_af()) {
            return false;
        }
        Item item = equipped = entityplayer.func_71045_bC() != null ? entityplayer.func_71045_bC().func_77973_b() : null;
        if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(entityplayer, i, j, k)) {
            tile.reinitalize();
            ((IToolWrench)equipped).wrenchUsed(entityplayer, i, j, k);
            return true;
        }
        return false;
    }

    public void addCreativeItems(ArrayList itemList) {
        itemList.add(new ItemStack((Block)this));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
        this.textureSide = par1IconRegister.func_94245_a("buildcraft:quarry_side");
        this.textureTop = par1IconRegister.func_94245_a("buildcraft:quarry_top");
        this.textureFront = par1IconRegister.func_94245_a("buildcraft:quarry_front");
    }
}

