/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.worldgen;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftEnergy;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockFluid;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.EnumHelper;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fluids.IFluidBlock;

public class OilPopulate {
    public static final OilPopulate INSTANCE = new OilPopulate();
    public static final PopulateChunkEvent.Populate.EventType EVENT_TYPE = (PopulateChunkEvent.Populate.EventType)EnumHelper.addEnum(PopulateChunkEvent.Populate.EventType.class, (String)"BUILDCRAFT_OIL", (Class[])new Class[0], (Object[])new Object[0]);
    private static final byte LARGE_WELL_HEIGHT = 16;
    private static final byte MEDIUM_WELL_HEIGHT = 6;
    public final Set excessiveBiomes = new HashSet();
    public final Set surfaceDepositBiomes = new HashSet();
    public final Set excludedBiomes = new HashSet();

    private OilPopulate() {
        this.surfaceDepositBiomes.add(BiomeGenBase.field_76769_d.field_76756_M);
        this.surfaceDepositBiomes.add(BiomeGenBase.field_76768_g.field_76756_M);
        this.excludedBiomes.add(BiomeGenBase.field_76779_k.field_76756_M);
        this.excludedBiomes.add(BiomeGenBase.field_76778_j.field_76756_M);
    }

    @ForgeSubscribe
    public void populate(PopulateChunkEvent.Pre event) {
        boolean doGen = TerrainGen.populate((IChunkProvider)event.chunkProvider, (World)event.world, (Random)event.rand, (int)event.chunkX, (int)event.chunkX, (boolean)event.hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)EVENT_TYPE);
        if (!doGen) {
            return;
        }
        this.generateOil(event.world, event.rand, event.chunkX, event.chunkZ);
    }

    public void generateOil(World world, Random rand, int chunkX, int chunkZ) {
        int lakeZ;
        int lakeY;
        int lakeX;
        int blockId;
        double bonus;
        int x = chunkX * 16 + 8 + rand.nextInt(16);
        int z = chunkZ * 16 + 8 + rand.nextInt(16);
        BiomeGenBase biome = world.func_72807_a(x, z);
        if (this.excludedBiomes.contains(biome.field_76756_M)) {
            return;
        }
        boolean oilBiome = this.surfaceDepositBiomes.contains(biome.field_76756_M) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DESERT) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND) && !BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FROZEN) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) && BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FROZEN);
        double d = bonus = oilBiome ? 3.0 : 1.0;
        if (this.excessiveBiomes.contains(biome.field_76756_M)) {
            bonus *= 30.0;
        } else if (BuildCraftCore.debugMode) {
            bonus *= 20.0;
        }
        GenType type = GenType.NONE;
        if (rand.nextDouble() <= 4.0E-4 * bonus) {
            type = GenType.LARGE;
        } else if (rand.nextDouble() <= 0.001 * bonus) {
            type = GenType.MEDIUM;
        } else if (oilBiome && rand.nextDouble() <= 0.02 * bonus) {
            type = GenType.LAKE;
        }
        if (type == GenType.NONE) {
            return;
        }
        int groundLevel = this.getTopBlock(world, x, z);
        if (groundLevel < 5) {
            return;
        }
        double deviation = this.surfaceDeviation(world, x, groundLevel, z, 8);
        if (deviation > 0.45) {
            return;
        }
        if (type == GenType.LARGE || type == GenType.MEDIUM) {
            int y;
            int maxHeight;
            int wellX = x;
            int wellZ = z;
            int wellHeight = 6;
            if (type == GenType.LARGE) {
                wellHeight = 16;
            }
            if ((maxHeight = groundLevel + wellHeight) >= world.func_72940_L() - 1) {
                return;
            }
            int wellY = 20 + rand.nextInt(10);
            int radius = type == GenType.LARGE ? 8 + rand.nextInt(9) : 4 + rand.nextInt(4);
            int radiusSq = radius * radius;
            for (int poolX = -radius; poolX <= radius; ++poolX) {
                for (int poolY = -radius; poolY <= radius; ++poolY) {
                    for (int poolZ = -radius; poolZ <= radius; ++poolZ) {
                        int distance = poolX * poolX + poolY * poolY + poolZ * poolZ;
                        if (distance > radiusSq) continue;
                        world.func_72832_d(poolX + wellX, poolY + wellY, poolZ + wellZ, BuildCraftEnergy.blockOil.field_71990_ca, 0, distance == radiusSq ? 3 : 2);
                    }
                }
            }
            int lakeRadius = type == GenType.LARGE ? 25 + rand.nextInt(20) : 5 + rand.nextInt(10);
            this.generateSurfaceDeposit(world, rand, biome, wellX, groundLevel, wellZ, lakeRadius);
            int baseY = type == GenType.LARGE && BuildCraftEnergy.spawnOilSprings && (BuildCraftCore.debugMode || rand.nextDouble() <= 0.25) ? 0 : wellY;
            if (world.func_72798_a(wellX, baseY, wellZ) == Block.field_71986_z.field_71990_ca && BuildCraftEnergy.spawnOilSprings) {
                world.func_72832_d(wellX, baseY, wellZ, BuildCraftCore.springBlock.field_71990_ca, 1, 3);
            }
            for (y = baseY + 1; y <= maxHeight; ++y) {
                world.func_94575_c(wellX, y, wellZ, BuildCraftEnergy.blockOil.field_71990_ca);
            }
            if (type == GenType.LARGE) {
                for (y = wellY; y <= maxHeight - wellHeight / 2; ++y) {
                    world.func_94575_c(wellX + 1, y, wellZ, BuildCraftEnergy.blockOil.field_71990_ca);
                    world.func_94575_c(wellX - 1, y, wellZ, BuildCraftEnergy.blockOil.field_71990_ca);
                    world.func_94575_c(wellX, y, wellZ + 1, BuildCraftEnergy.blockOil.field_71990_ca);
                    world.func_94575_c(wellX, y, wellZ - 1, BuildCraftEnergy.blockOil.field_71990_ca);
                }
            }
        } else if (type == GenType.LAKE && (blockId = world.func_72798_a(lakeX = x, lakeY = groundLevel, lakeZ = z)) == biome.field_76752_A) {
            this.generateSurfaceDeposit(world, rand, biome, lakeX, lakeY, lakeZ, 5 + rand.nextInt(10));
        }
    }

    public void generateSurfaceDeposit(World world, Random rand, int x, int y, int z, int radius) {
        BiomeGenBase biome = world.func_72807_a(x, z);
        this.generateSurfaceDeposit(world, rand, biome, x, y, z, radius);
    }

    private void generateSurfaceDeposit(World world, Random rand, BiomeGenBase biome, int x, int y, int z, int radius) {
        int depth = rand.nextDouble() < 0.5 ? 1 : 2;
        this.setOilColumnForLake(world, biome, x, y, z, depth, 2);
        for (int w = 1; w <= radius; ++w) {
            float proba = (float)(radius - w + 4) / (float)(radius + 4);
            this.setOilWithProba(world, biome, rand, proba, x, y, z + w, depth);
            this.setOilWithProba(world, biome, rand, proba, x, y, z - w, depth);
            this.setOilWithProba(world, biome, rand, proba, x + w, y, z, depth);
            this.setOilWithProba(world, biome, rand, proba, x - w, y, z, depth);
            for (int i = 1; i <= w; ++i) {
                this.setOilWithProba(world, biome, rand, proba, x + i, y, z + w, depth);
                this.setOilWithProba(world, biome, rand, proba, x + i, y, z - w, depth);
                this.setOilWithProba(world, biome, rand, proba, x + w, y, z + i, depth);
                this.setOilWithProba(world, biome, rand, proba, x - w, y, z + i, depth);
                this.setOilWithProba(world, biome, rand, proba, x - i, y, z + w, depth);
                this.setOilWithProba(world, biome, rand, proba, x - i, y, z - w, depth);
                this.setOilWithProba(world, biome, rand, proba, x + w, y, z - i, depth);
                this.setOilWithProba(world, biome, rand, proba, x - w, y, z - i, depth);
            }
        }
        for (int dx = x - radius; dx <= x + radius; ++dx) {
            for (int dz = z - radius; dz <= z + radius; ++dz) {
                if (this.isOil(world, dx, y, dz) || !this.isOilSurrounded(world, dx, y, dz)) continue;
                this.setOilColumnForLake(world, biome, dx, y, dz, depth, 2);
            }
        }
    }

    private boolean isReplaceableFluid(World world, int x, int y, int z) {
        int blockId = world.func_72798_a(x, y, z);
        Block block = Block.field_71973_m[blockId];
        return (block instanceof BlockFluid || block instanceof IFluidBlock) && block.field_72018_cp != Material.field_76256_h;
    }

    private boolean isOil(World world, int x, int y, int z) {
        int blockId = world.func_72798_a(x, y, z);
        return blockId == BuildCraftEnergy.blockOil.field_71990_ca;
    }

    private boolean isReplaceableForLake(World world, BiomeGenBase biome, int x, int y, int z) {
        int blockId = world.func_72798_a(x, y, z);
        if (blockId == 0) {
            return true;
        }
        if (blockId == biome.field_76753_B || blockId == biome.field_76752_A) {
            return true;
        }
        Block block = Block.field_71973_m[blockId];
        if (!block.field_72018_cp.func_76230_c()) {
            return true;
        }
        if (block.isGenMineableReplaceable(world, x, y, z, Block.field_71981_t.field_71990_ca)) {
            return true;
        }
        if (block instanceof BlockFlower) {
            return true;
        }
        return !world.func_72804_r(x, y, z);
    }

    private boolean isOilAdjacent(World world, int x, int y, int z) {
        return this.isOil(world, x + 1, y, z) || this.isOil(world, x - 1, y, z) || this.isOil(world, x, y, z + 1) || this.isOil(world, x, y, z - 1);
    }

    private boolean isOilSurrounded(World world, int x, int y, int z) {
        return this.isOil(world, x + 1, y, z) && this.isOil(world, x - 1, y, z) && this.isOil(world, x, y, z + 1) && this.isOil(world, x, y, z - 1);
    }

    private void setOilWithProba(World world, BiomeGenBase biome, Random rand, float proba, int x, int y, int z, int depth) {
        if (rand.nextFloat() <= proba && world.func_72798_a(x, y - depth - 1, z) != 0 && this.isOilAdjacent(world, x, y, z)) {
            this.setOilColumnForLake(world, biome, x, y, z, depth, 3);
        }
    }

    private void setOilColumnForLake(World world, BiomeGenBase biome, int x, int y, int z, int depth, int update) {
        if (this.isReplaceableForLake(world, biome, x, y + 1, z)) {
            if (!world.func_72799_c(x, y + 2, z)) {
                return;
            }
            if (!this.isReplaceableFluid(world, x, y, z) && !world.isBlockSolidOnSide(x, y - 1, z, ForgeDirection.UP)) {
                return;
            }
            world.func_72832_d(x, y, z, BuildCraftEnergy.blockOil.field_71990_ca, 0, update);
            if (!world.func_72799_c(x, y + 1, z)) {
                world.func_72832_d(x, y + 1, z, 0, 0, update);
            }
            for (int d = 1; d <= depth - 1; ++d) {
                if (this.isReplaceableFluid(world, x, y - d, z) || !world.isBlockSolidOnSide(x, y - d - 1, z, ForgeDirection.UP)) {
                    return;
                }
                world.func_72832_d(x, y - d, z, BuildCraftEnergy.blockOil.field_71990_ca, 0, 2);
            }
        }
    }

    private int getTopBlock(World world, int x, int z) {
        Chunk chunk = world.func_72938_d(x, z);
        int trimmedX = x & 0xF;
        int trimmedZ = z & 0xF;
        for (int y = chunk.func_76625_h() + 15; y > 0; --y) {
            int blockId = chunk.func_76610_a(trimmedX, y, trimmedZ);
            Block block = Block.field_71973_m[blockId];
            if (blockId == 0) continue;
            if (block instanceof BlockFluid) {
                return y;
            }
            if (block instanceof IFluidBlock) {
                return y;
            }
            if (!block.field_72018_cp.func_76230_c() || block instanceof BlockFlower) continue;
            return y - 1;
        }
        return -1;
    }

    private double surfaceDeviation(World world, int x, int y, int z, int radius) {
        int diameter = radius * 2;
        double centralTendancy = y;
        double deviation = 0.0;
        for (int i = 0; i < diameter; ++i) {
            for (int k = 0; k < diameter; ++k) {
                deviation += (double)this.getTopBlock(world, x - radius + i, z - radius + k) - centralTendancy;
            }
        }
        return Math.abs(deviation / centralTendancy);
    }

    private static enum GenType {
        LARGE,
        MEDIUM,
        LAKE,
        NONE;

    }
}

