/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.energy.render.EntityDropParticleFX;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;

public class BlockBuildcraftFluid
extends BlockFluidClassic {
    protected float particleRed;
    protected float particleGreen;
    protected float particleBlue;
    @SideOnly(value=Side.CLIENT)
    protected Icon[] theIcon;
    protected boolean flammable;
    protected int flammability = 0;

    public BlockBuildcraftFluid(int id, Fluid fluid, Material material) {
        super(id, fluid, material);
    }

    public Icon func_71858_a(int side, int meta) {
        return side != 0 && side != 1 ? this.theIcon[1] : this.theIcon[0];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.theIcon = new Icon[]{iconRegister.func_94245_a("buildcraft:" + this.fluidName + "_still"), iconRegister.func_94245_a("buildcraft:" + this.fluidName + "_flow")};
    }

    public BlockBuildcraftFluid setFlammable(boolean flammable) {
        this.flammable = flammable;
        return this;
    }

    public BlockBuildcraftFluid setFlammability(int flammability) {
        this.flammability = flammability;
        return this;
    }

    public int getFireSpreadSpeed(World world, int x, int y, int z, int metadata, ForgeDirection face) {
        return this.flammable ? 300 : 0;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        return this.flammability;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        return this.flammable;
    }

    public boolean isFireSource(World world, int x, int y, int z, int metadata, ForgeDirection side) {
        return this.flammable && this.flammability == 0;
    }

    public BlockBuildcraftFluid setParticleColor(float particleRed, float particleGreen, float particleBlue) {
        this.particleRed = particleRed;
        this.particleGreen = particleGreen;
        this.particleBlue = particleBlue;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71862_a(World world, int x, int y, int z, Random rand) {
        super.func_71862_a(world, x, y, z, rand);
        if (rand.nextInt(10) == 0 && world.func_72797_t(x, y - 1, z) && !world.func_72803_f(x, y - 2, z).func_76230_c()) {
            double px = (float)x + rand.nextFloat();
            double py = (double)y - 1.05;
            double pz = (float)z + rand.nextFloat();
            EntityDropParticleFX fx = new EntityDropParticleFX(world, px, py, pz, this.particleRed, this.particleGreen, this.particleBlue);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public boolean canDisplace(IBlockAccess world, int x, int y, int z) {
        if (world.func_72803_f(x, y, z).func_76224_d()) {
            return false;
        }
        return super.canDisplace(world, x, y, z);
    }

    public boolean displaceIfPossible(World world, int x, int y, int z) {
        if (world.func_72803_f(x, y, z).func_76224_d()) {
            return false;
        }
        return super.displaceIfPossible(world, x, y, z);
    }
}

