/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.utils;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftEnergy;
import buildcraft.api.core.BuildCraftAPI;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFluid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet60Explosion;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public class BlockUtil {
    public static List getItemStackFromBlock(World world, int i, int j, int k) {
        Block block = Block.field_71973_m[world.func_72798_a(i, j, k)];
        if (block == null) {
            return null;
        }
        if (block.isAirBlock(world, i, j, k)) {
            return null;
        }
        int meta = world.func_72805_g(i, j, k);
        return block.getBlockDropped(world, i, j, k, meta, 0);
    }

    public static void breakBlock(World world, int x, int y, int z) {
        BlockUtil.breakBlock(world, x, y, z, BuildCraftCore.itemLifespan);
    }

    public static void breakBlock(World world, int x, int y, int z, int forcedLifespan) {
        if (!world.func_72799_c(x, y, z) && BuildCraftCore.dropBrokenBlocks && !world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            int blockId = world.func_72798_a(x, y, z);
            ArrayList items = Block.field_71973_m[blockId].getBlockDropped(world, x, y, z, world.func_72805_g(x, y, z), 0);
            for (ItemStack item : items) {
                float var = 0.7f;
                double dx = (double)(world.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
                double dy = (double)(world.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
                double dz = (double)(world.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
                EntityItem entityitem = new EntityItem(world, (double)x + dx, (double)y + dy, (double)z + dz, item);
                entityitem.lifespan = forcedLifespan;
                entityitem.field_70293_c = 10;
                world.func_72838_d((Entity)entityitem);
            }
        }
        world.func_94575_c(x, y, z, 0);
    }

    public static boolean canChangeBlock(World world, int x, int y, int z) {
        return BlockUtil.canChangeBlock(world.func_72798_a(x, y, z), world, x, y, z);
    }

    public static boolean canChangeBlock(int blockID, World world, int x, int y, int z) {
        Block block = Block.field_71973_m[blockID];
        if (blockID == 0 || block == null || block.isAirBlock(world, x, y, z)) {
            return true;
        }
        if (block.func_71934_m(world, x, y, z) < 0.0f) {
            return false;
        }
        if (blockID == BuildCraftEnergy.blockOil.field_71990_ca) {
            return false;
        }
        return blockID != Block.field_71938_D.field_71990_ca && blockID != Block.field_71944_C.field_71990_ca;
    }

    public static boolean isSoftBlock(World world, int x, int y, int z) {
        return BlockUtil.isSoftBlock(world.func_72798_a(x, y, z), world, x, y, z);
    }

    public static boolean isSoftBlock(int blockID, World world, int x, int y, int z) {
        Block block = Block.field_71973_m[blockID];
        return blockID == 0 || block == null || BuildCraftAPI.softBlocks[blockID] || block.isAirBlock(world, x, y, z);
    }

    public static boolean isToughBlock(World world, int x, int y, int z) {
        return !world.func_72803_f(x, y, z).func_76229_l();
    }

    public static boolean isFullFluidBlock(World world, int x, int y, int z) {
        return BlockUtil.isFullFluidBlock(world.func_72798_a(x, y, z), world, x, y, z);
    }

    public static boolean isFullFluidBlock(int blockId, World world, int x, int y, int z) {
        Block block = Block.field_71973_m[blockId];
        if (block instanceof BlockFluid || block instanceof IFluidBlock) {
            return world.func_72805_g(x, y, z) == 0;
        }
        return false;
    }

    public static Fluid getFluid(int blockId) {
        Block block = Block.field_71973_m[blockId];
        if (block instanceof IFluidBlock) {
            return ((IFluidBlock)block).getFluid();
        }
        if (blockId == Block.field_71943_B.field_71990_ca || blockId == Block.field_71942_A.field_71990_ca) {
            return FluidRegistry.WATER;
        }
        if (blockId == Block.field_71938_D.field_71990_ca || blockId == Block.field_71944_C.field_71990_ca) {
            return FluidRegistry.LAVA;
        }
        return null;
    }

    public static FluidStack drainBlock(World world, int x, int y, int z, boolean doDrain) {
        return BlockUtil.drainBlock(world.func_72798_a(x, y, z), world, x, y, z, doDrain);
    }

    public static FluidStack drainBlock(int blockId, World world, int x, int y, int z, boolean doDrain) {
        if (Block.field_71973_m[blockId] instanceof IFluidBlock) {
            IFluidBlock fluidBlock = (IFluidBlock)Block.field_71973_m[blockId];
            if (fluidBlock.canDrain(world, x, y, z)) {
                return fluidBlock.drain(world, x, y, z, doDrain);
            }
        } else {
            if (blockId == Block.field_71943_B.field_71990_ca || blockId == Block.field_71942_A.field_71990_ca) {
                int meta = world.func_72805_g(x, y, z);
                if (meta != 0) {
                    return null;
                }
                if (doDrain) {
                    world.func_94571_i(x, y, z);
                }
                return new FluidStack(FluidRegistry.WATER, 1000);
            }
            if (blockId == Block.field_71938_D.field_71990_ca || blockId == Block.field_71944_C.field_71990_ca) {
                int meta = world.func_72805_g(x, y, z);
                if (meta != 0) {
                    return null;
                }
                if (doDrain) {
                    world.func_94571_i(x, y, z);
                }
                return new FluidStack(FluidRegistry.LAVA, 1000);
            }
        }
        return null;
    }

    public static void explodeBlock(World world, int x, int y, int z) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        Explosion explosion = new Explosion(world, null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 3.0f);
        explosion.field_77281_g.add(new ChunkPosition(x, y, z));
        explosion.func_77279_a(true);
        for (EntityPlayer player : world.field_73010_i) {
            if (!(player instanceof EntityPlayerMP) || !(player.func_70092_e((double)x, (double)y, (double)z) < 4096.0)) continue;
            ((EntityPlayerMP)player).field_71135_a.func_72567_b((Packet)new Packet60Explosion((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 3.0f, explosion.field_77281_g, null));
        }
    }
}

