/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.network;

import buildcraft.core.network.ISyncedTile;
import buildcraft.core.network.ISynchronizedTile;
import buildcraft.core.network.PacketTileState;
import buildcraft.core.network.PacketTileUpdate;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketHandler
implements IPacketHandler {
    private void onTileUpdate(EntityPlayer player, PacketTileUpdate packet) throws IOException {
        World world = player.field_70170_p;
        if (!packet.targetExists(world)) {
            return;
        }
        TileEntity entity = packet.getTarget(world);
        if (!(entity instanceof ISynchronizedTile)) {
            return;
        }
        ISynchronizedTile tile = (ISynchronizedTile)entity;
        tile.handleUpdatePacket(packet);
        tile.postPacketHandling(packet);
    }

    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        try {
            int packetID = data.read();
            switch (packetID) {
                case 0: {
                    PacketTileUpdate packetT = new PacketTileUpdate();
                    packetT.readData(data);
                    this.onTileUpdate((EntityPlayer)player, packetT);
                    break;
                }
                case 100: {
                    PacketTileState inPacket = new PacketTileState();
                    inPacket.readData(data);
                    World world = ((EntityPlayer)player).field_70170_p;
                    TileEntity tile = world.func_72796_p(inPacket.posX, inPacket.posY, inPacket.posZ);
                    if (!(tile instanceof ISyncedTile)) break;
                    inPacket.applyStates(data, (ISyncedTile)tile);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

