/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.gui;

import buildcraft.core.DefaultProps;
import buildcraft.core.gui.BuildCraftContainer;
import buildcraft.core.gui.buttons.GuiBetterButton;
import buildcraft.core.gui.slots.SlotBase;
import buildcraft.core.gui.tooltips.ToolTip;
import buildcraft.core.gui.tooltips.ToolTipLine;
import buildcraft.core.utils.SessionVars;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class GuiBuildCraft
extends GuiContainer {
    public static final ResourceLocation LEDGER_TEXTURE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/ledger.png");
    protected LedgerManager ledgerManager = new LedgerManager(this);
    protected TileEntity tile;

    public GuiBuildCraft(BuildCraftContainer container, IInventory inventory) {
        super((Container)container);
        if (inventory instanceof TileEntity) {
            this.tile = (TileEntity)inventory;
        }
        this.initLedgers(inventory);
    }

    protected void initLedgers(IInventory inventory) {
    }

    public void func_73863_a(int mouseX, int mouseY, float par3) {
        boolean mouseOver;
        ToolTip tips;
        super.func_73863_a(mouseX, mouseY, par3);
        int left = this.field_74198_m;
        int top = this.field_74197_n;
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)left, (float)top, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74518_a();
        InventoryPlayer playerInv = this.field_73882_e.field_71439_g.field_71071_by;
        if (playerInv.func_70445_o() == null) {
            for (Object button : this.field_73887_h) {
                GuiBetterButton betterButton;
                if (!(button instanceof GuiBetterButton) || (tips = (betterButton = (GuiBetterButton)((Object)button)).getToolTip()) == null) continue;
                mouseOver = betterButton.isMouseOverButton(mouseX, mouseY);
                tips.onTick(mouseOver);
                if (!mouseOver || !tips.isReady()) continue;
                tips.refresh();
                this.drawToolTips(tips, mouseX, mouseY);
            }
        }
        for (Object obj : this.field_74193_d.field_75151_b) {
            SlotBase slot;
            if (!(obj instanceof SlotBase) || (slot = (SlotBase)((Object)obj)).func_75211_c() != null || (tips = slot.getToolTip()) == null) continue;
            mouseOver = this.isMouseOverSlot(slot, mouseX, mouseY);
            tips.onTick(mouseOver);
            if (!mouseOver || !tips.isReady()) continue;
            tips.refresh();
            this.drawToolTips(tips, mouseX, mouseY);
        }
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    protected void func_74189_g(int par1, int par2) {
        this.ledgerManager.drawLedgers(par1, par2);
    }

    protected int getCenteredOffset(String string) {
        return this.getCenteredOffset(string, this.field_74194_b);
    }

    protected int getCenteredOffset(String string, int xWidth) {
        return (xWidth - this.field_73886_k.func_78256_a(string)) / 2;
    }

    private boolean isMouseOverSlot(Slot slot, int mouseX, int mouseY) {
        int left = this.field_74198_m;
        int top = this.field_74197_n;
        return (mouseX -= left) >= slot.field_75223_e - 1 && mouseX < slot.field_75223_e + 16 + 1 && (mouseY -= top) >= slot.field_75221_f - 1 && mouseY < slot.field_75221_f + 16 + 1;
    }

    protected void func_73864_a(int par1, int par2, int mouseButton) {
        super.func_73864_a(par1, par2, mouseButton);
        this.ledgerManager.handleMouseClicked(par1, par2, mouseButton);
    }

    private void drawToolTips(ToolTip toolTips, int mouseX, int mouseY) {
        if (toolTips.size() > 0) {
            int y;
            int left = this.field_74198_m;
            int top = this.field_74197_n;
            int lenght = 0;
            Iterator i$ = toolTips.iterator();
            while (i$.hasNext()) {
                ToolTipLine tip = (ToolTipLine)i$.next();
                y = this.field_73886_k.func_78256_a(tip.text);
                if (y <= lenght) continue;
                lenght = y;
            }
            int x = mouseX - left + 12;
            y = mouseY - top - 12;
            int var14 = 8;
            if (toolTips.size() > 1) {
                var14 += 2 + (toolTips.size() - 1) * 10;
            }
            this.field_73735_i = 300.0f;
            GuiBuildCraft.field_74196_a.field_77023_b = 300.0f;
            int var15 = -267386864;
            this.func_73733_a(x - 3, y - 4, x + lenght + 3, y - 3, var15, var15);
            this.func_73733_a(x - 3, y + var14 + 3, x + lenght + 3, y + var14 + 4, var15, var15);
            this.func_73733_a(x - 3, y - 3, x + lenght + 3, y + var14 + 3, var15, var15);
            this.func_73733_a(x - 4, y - 3, x - 3, y + var14 + 3, var15, var15);
            this.func_73733_a(x + lenght + 3, y - 3, x + lenght + 4, y + var14 + 3, var15, var15);
            int var16 = 0x505000FF;
            int var17 = (var16 & 0xFEFEFE) >> 1 | var16 & 0xFF000000;
            this.func_73733_a(x - 3, y - 3 + 1, x - 3 + 1, y + var14 + 3 - 1, var16, var17);
            this.func_73733_a(x + lenght + 2, y - 3 + 1, x + lenght + 3, y + var14 + 3 - 1, var16, var17);
            this.func_73733_a(x - 3, y - 3, x + lenght + 3, y - 3 + 1, var16, var16);
            this.func_73733_a(x - 3, y + var14 + 2, x + lenght + 3, y + var14 + 3, var17, var17);
            Iterator i$2 = toolTips.iterator();
            while (i$2.hasNext()) {
                ToolTipLine tip = (ToolTipLine)i$2.next();
                String line = tip.text;
                line = tip.color == -1 ? "\u00a77" + line : "\u00a7" + Integer.toHexString(tip.color) + line;
                this.field_73886_k.func_78261_a(line, x, y, -1);
                y += 10 + tip.getSpacing();
            }
            this.field_73735_i = 0.0f;
            GuiBuildCraft.field_74196_a.field_77023_b = 0.0f;
        }
    }

    protected abstract class Ledger {
        private boolean open;
        protected int overlayColor = 0xFFFFFF;
        public int currentShiftX = 0;
        public int currentShiftY = 0;
        protected int limitWidth = 128;
        protected int maxWidth = 124;
        protected int minWidth;
        protected int currentWidth = this.minWidth = 24;
        protected int maxHeight = 24;
        protected int minHeight;
        protected int currentHeight = this.minHeight = 24;

        protected Ledger() {
        }

        public void update() {
            if (this.open && this.currentWidth < this.maxWidth) {
                this.currentWidth += 4;
            } else if (!this.open && this.currentWidth > this.minWidth) {
                this.currentWidth -= 4;
            }
            if (this.open && this.currentHeight < this.maxHeight) {
                this.currentHeight += 4;
            } else if (!this.open && this.currentHeight > this.minHeight) {
                this.currentHeight -= 4;
            }
        }

        public int getHeight() {
            return this.currentHeight;
        }

        public abstract void draw(int var1, int var2);

        public abstract String getTooltip();

        public boolean handleMouseClicked(int x, int y, int mouseButton) {
            return false;
        }

        public boolean intersectsWith(int mouseX, int mouseY, int shiftX, int shiftY) {
            return mouseX >= shiftX && mouseX <= shiftX + this.currentWidth && mouseY >= shiftY && mouseY <= shiftY + this.getHeight();
        }

        public void setFullyOpen() {
            this.open = true;
            this.currentWidth = this.maxWidth;
            this.currentHeight = this.maxHeight;
        }

        public void toggleOpen() {
            if (this.open) {
                this.open = false;
                SessionVars.setOpenedLedger(null);
            } else {
                this.open = true;
                SessionVars.setOpenedLedger(this.getClass());
            }
        }

        public boolean isVisible() {
            return true;
        }

        public boolean isOpen() {
            return this.open;
        }

        protected boolean isFullyOpened() {
            return this.currentWidth >= this.maxWidth;
        }

        protected void drawBackground(int x, int y) {
            float colorR = (float)(this.overlayColor >> 16 & 0xFF) / 255.0f;
            float colorG = (float)(this.overlayColor >> 8 & 0xFF) / 255.0f;
            float colorB = (float)(this.overlayColor & 0xFF) / 255.0f;
            GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
            ((GuiBuildCraft)GuiBuildCraft.this).field_73882_e.field_71446_o.func_110577_a(LEDGER_TEXTURE);
            GuiBuildCraft.this.func_73729_b(x, y, 0, 256 - this.currentHeight, 4, this.currentHeight);
            GuiBuildCraft.this.func_73729_b(x + 4, y, 256 - this.currentWidth + 4, 0, this.currentWidth - 4, 4);
            GuiBuildCraft.this.func_73729_b(x, y, 0, 0, 4, 4);
            GuiBuildCraft.this.func_73729_b(x + 4, y + 4, 256 - this.currentWidth + 4, 256 - this.currentHeight + 4, this.currentWidth - 4, this.currentHeight - 4);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        protected void drawIcon(Icon icon, int x, int y) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiBuildCraft.this.func_94065_a(x, y, icon, 16, 16);
        }
    }

    protected class LedgerManager {
        private GuiBuildCraft gui;
        protected ArrayList ledgers = new ArrayList();

        public LedgerManager(GuiBuildCraft gui) {
            this.gui = gui;
        }

        public void add(Ledger ledger) {
            this.ledgers.add(ledger);
            if (SessionVars.getOpenedLedger() != null && ledger.getClass().equals(SessionVars.getOpenedLedger())) {
                ledger.setFullyOpen();
            }
        }

        public void insert(Ledger ledger) {
            this.ledgers.add(this.ledgers.size() - 1, ledger);
        }

        protected Ledger getAtPosition(int mX, int mY) {
            int xShift = (this.gui.field_73880_f - this.gui.field_74194_b) / 2 + this.gui.field_74194_b;
            int yShift = (this.gui.field_73881_g - this.gui.field_74195_c) / 2 + 8;
            for (int i = 0; i < this.ledgers.size(); ++i) {
                Ledger ledger = (Ledger)this.ledgers.get(i);
                if (!ledger.isVisible()) continue;
                ledger.currentShiftX = xShift;
                ledger.currentShiftY = yShift;
                if (ledger.intersectsWith(mX, mY, xShift, yShift)) {
                    return ledger;
                }
                yShift += ledger.getHeight();
            }
            return null;
        }

        protected void drawLedgers(int mouseX, int mouseY) {
            int xPos = 8;
            for (Ledger ledger : this.ledgers) {
                ledger.update();
                if (!ledger.isVisible()) continue;
                ledger.draw(GuiBuildCraft.this.field_74194_b, xPos);
                xPos += ledger.getHeight();
            }
            Ledger ledger = this.getAtPosition(mouseX, mouseY);
            if (ledger != null) {
                int startX = mouseX - (this.gui.field_73880_f - this.gui.field_74194_b) / 2 + 12;
                int startY = mouseY - (this.gui.field_73881_g - this.gui.field_74195_c) / 2 - 12;
                String tooltip = ledger.getTooltip();
                int textWidth = GuiBuildCraft.this.field_73886_k.func_78256_a(tooltip);
                GuiBuildCraft.this.func_73733_a(startX - 3, startY - 3, startX + textWidth + 3, startY + 8 + 3, -1073741824, -1073741824);
                GuiBuildCraft.this.field_73886_k.func_78261_a(tooltip, startX, startY, -1);
            }
        }

        public void handleMouseClicked(int x, int y, int mouseButton) {
            Ledger ledger;
            if (mouseButton == 0 && (ledger = this.getAtPosition(x, y)) != null && !ledger.handleMouseClicked(x, y, mouseButton)) {
                for (Ledger other : this.ledgers) {
                    if (other == ledger || !other.isOpen()) continue;
                    other.toggleOpen();
                }
                ledger.toggleOpen();
            }
        }
    }
}

